/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.AppendPartOfCharArrayKt;
import androidx.compose.ui.text.input.GapBufferKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
final class GapBuffer {
    private int capacity;
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    /*
     * WARNING - void declaration
     */
    public GapBuffer(char[] initBuffer, int initGapStart, int initGapEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)initBuffer, (String)"initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = var1_1;
        this.gapStart = var2_2;
        this.gapEnd = var3_3;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index) {
        void var1_1;
        if (index < this.gapStart) {
            return this.buffer[index];
        }
        return this.buffer[var1_1 - this.gapStart + this.gapEnd];
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, String text) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n3 = text.length() - (end - start);
        GapBuffer gapBuffer = this;
        if (n3 > gapBuffer.gapLength()) {
            n2 = n3 - gapBuffer.gapLength();
            n = gapBuffer.capacity * 2;
            while (n - gapBuffer.capacity < n2) {
                n *= 2;
            }
            char[] cArray = new char[n];
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])cArray, (int)0, (int)0, (int)gapBuffer.gapStart);
            n2 = gapBuffer.capacity - gapBuffer.gapEnd;
            int n4 = n - n2;
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])cArray, (int)n4, (int)gapBuffer.gapEnd, (int)(gapBuffer.gapEnd + n2));
            gapBuffer.buffer = cArray;
            gapBuffer.capacity = n;
            gapBuffer.gapEnd = n4;
        }
        n2 = var2_2;
        n3 = var1_1;
        gapBuffer = this;
        if (n3 < gapBuffer.gapStart && n2 <= gapBuffer.gapStart) {
            n = gapBuffer.gapStart - n2;
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])gapBuffer.buffer, (int)(gapBuffer.gapEnd - n), (int)n2, (int)gapBuffer.gapStart);
            gapBuffer.gapStart = n3;
            gapBuffer.gapEnd -= n;
        } else if (n3 < gapBuffer.gapStart && n2 >= gapBuffer.gapStart) {
            gapBuffer.gapEnd = n2 + gapBuffer.gapLength();
            gapBuffer.gapStart = n3;
        } else {
            n = n3 + gapBuffer.gapLength();
            n3 = n2 + gapBuffer.gapLength();
            n2 = n - gapBuffer.gapEnd;
            ArraysKt.copyInto((char[])gapBuffer.buffer, (char[])gapBuffer.buffer, (int)gapBuffer.gapStart, (int)gapBuffer.gapEnd, (int)n);
            gapBuffer.gapStart += n2;
            gapBuffer.gapEnd = n3;
        }
        GapBufferKt.access$toCharArray(text, this.buffer, this.gapStart);
        this.gapStart += var3_3.length();
    }

    /*
     * WARNING - void declaration
     */
    public final void append(StringBuilder builder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        AppendPartOfCharArrayKt.appendPartOfCharArray(builder, this.buffer, 0, this.gapStart);
        AppendPartOfCharArrayKt.appendPartOfCharArray((StringBuilder)var1_1, this.buffer, this.gapEnd, this.capacity - this.gapEnd);
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)var2_2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

