/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextCommand\n+ 2 MathUtils.kt\nandroidx/compose/ui/text/input/MathUtilsKt\n*L\n1#1,570:1\n23#2,3:571\n32#2,4:574\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextCommand\n*L\n268#1:571,3\n273#1:574,4\n*E\n"})
public final class DeleteSurroundingTextCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;

    /*
     * WARNING - void declaration
     */
    public DeleteSurroundingTextCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        void var2_3;
        void var1_1;
        this.lengthBeforeCursor = var1_1;
        this.lengthAfterCursor = var2_3;
        if (!(this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0)) {
            String string = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var3_3;
        void $this$subtractExactOrElse$iv;
        void $this$addExactOrElse$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int n = buffer.getSelectionEnd$ui_text();
        int right$iv = this.lengthAfterCursor;
        void result$iv = $this$addExactOrElse$iv + right$iv;
        int end = (($this$addExactOrElse$iv ^ result$iv) & (right$iv ^ result$iv)) < 0 ? buffer.getLength$ui_text() : result$iv;
        EditingBuffer editingBuffer = buffer;
        editingBuffer.delete$ui_text(editingBuffer.getSelectionEnd$ui_text(), Math.min(end, buffer.getLength$ui_text()));
        right$iv = buffer.getSelectionStart$ui_text();
        int right$iv2 = this.lengthBeforeCursor;
        result$iv = $this$subtractExactOrElse$iv - right$iv2;
        boolean start = (($this$subtractExactOrElse$iv ^ right$iv2) & (var3_3 ^ result$iv)) < 0 ? false : result$iv;
        buffer.delete$ui_text(Math.max(0, n), var1_1.getSelectionStart$ui_text());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextCommand)var1_1).lengthAfterCursor;
    }

    public final int hashCode() {
        int n;
        int result2 = this.lengthBeforeCursor;
        n = 31 * n + this.lengthAfterCursor;
        return n;
    }

    public final String toString() {
        return "DeleteSurroundingTextCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ')';
    }
}

