/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.caches.ContainerHelpersKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0013\b\u0017\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\r\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0010J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u0019R\u0016\u0010\u001e\u001a\u00020\u00048\u0004@\u0004X\u0085\f\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%"}, d2={"Landroidx/compose/ui/text/caches/SimpleArrayMap;", "K", "V", "", "", "capacity", "<init>", "(I)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "key", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "()I", "hash", "indexOf", "(Ljava/lang/Object;I)I", "indexOfKey", "(Ljava/lang/Object;)I", "indexOfNull", "index", "keyAt", "(I)Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "valueAt", "_size", "I", "", "hashes", "[I", "", "keyValues", "[Ljava/lang/Object;"})
@StabilityInferred(parameters=0)
public final class SimpleArrayMap<K, V> {
    private int[] hashes;
    private Object[] keyValues;
    protected int _size;
    public static final int $stable = 8;

    private int indexOf(Object key, int hash) {
        int end;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpersKt.binarySearchInternal(this.hashes, N, hash);
        if (index < 0) {
            return index;
        }
        if (Intrinsics.areEqual((Object)key, (Object)this.keyValues[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.hashes[end] == hash; ++end) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - void declaration
     */
    private int indexOfNull() {
        void var3_3;
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpersKt.binarySearchInternal(this.hashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (this.keyValues[index << 1] == null) {
            return index;
        }
        for (int end = index + 1; end < N && this.hashes[end] == 0; ++end) {
            if (this.keyValues[end << 1] != null) continue;
            return end;
        }
        for (void i = var2_2 - true; i >= 0 && this.hashes[i] == 0; --i) {
            if (this.keyValues[i << 1] != null) continue;
            return (int)i;
        }
        return (int)(~var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    private SimpleArrayMap(int capacity) {
        if (capacity == 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.keyValues = ContainerHelpersKt.EMPTY_OBJECTS;
        } else {
            void var1_1;
            this.hashes = new int[capacity];
            this.keyValues = new Object[var1_1 << 1];
        }
        this._size = 0;
    }

    public /* synthetic */ SimpleArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    private int indexOfKey(Object key) {
        void var1_1;
        Object object = key;
        if (object == null) {
            return this.indexOfNull();
        }
        return this.indexOf(object, var1_1.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            void var1_2;
            return (V)this.keyValues[(var1_2 << 1) + true];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private K keyAt(int index) {
        void var1_1;
        return (K)this.keyValues[var1_1 << 1];
    }

    /*
     * WARNING - void declaration
     */
    private V valueAt(int index) {
        void var1_1;
        return (V)this.keyValues[(var1_1 << 1) + true];
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        try {
            SimpleArrayMap map;
            if (other instanceof SimpleArrayMap) {
                map = (SimpleArrayMap)other;
                if (this._size != map._size) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    Object key = this.keyAt(i);
                    Object mine = this.valueAt(i);
                    V theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !(((SimpleArrayMap)(key = map)).indexOfKey(mine = key) >= 0) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
            if (map instanceof Map) {
                if (this._size != ((Map)((Object)map)).size()) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = ((Map)((Object)map)).get(key);
                    if (!(mine == null ? theirs != null || !((Map)((Object)map)).containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {}
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        int[] hashes = this.hashes;
        Object[] array = this.keyValues;
        int result2 = 0;
        int i = 0;
        int v = 1;
        int s = this._size;
        while (i < s) {
            Object value = array[v];
            Object object = value;
            result2 += hashes[i] ^ (object != null ? object.hashCode() : 0);
            ++i;
            v += 2;
        }
        return (int)var3_3;
    }

    public final String toString() {
        SimpleArrayMap simpleArrayMap = this;
        if (simpleArrayMap._size <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this._size * 28);
        buffer.append('{');
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        String string = ((StringBuilder)((Object)simpleArrayMap)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public SimpleArrayMap() {
        this(0, 1, null);
    }
}

