/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.ExtendedCommand;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class JDBC3Statement
extends CoreStatement {
    private int queryTimeout = 0;
    protected long updateCount;
    protected boolean exhaustedResults = false;

    /*
     * WARNING - void declaration
     */
    protected JDBC3Statement(SQLiteConnection conn) {
        super((SQLiteConnection)var1_1);
        void var1_1;
    }

    public void close() throws SQLException {
        this.clearGeneratedKeys();
        this.internalClose();
    }

    /*
     * WARNING - void declaration
     */
    public boolean execute(String sql) throws SQLException {
        void var1_1;
        this.internalClose();
        JDBC3Statement jDBC3Statement = this;
        return jDBC3Statement.withConnectionTimeout(() -> jDBC3Statement.lambda$execute$0((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        void var1_1;
        return this.execute((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResultSet executeQuery(String sql, boolean closeStmt) throws SQLException {
        void var1_1;
        void var2_2;
        this.rs.closeStmt = var2_2;
        return this.executeQuery((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        void var1_1;
        this.internalClose();
        this.sql = var1_1;
        JDBC3Statement jDBC3Statement = this;
        return jDBC3Statement.withConnectionTimeout(() -> {
            this.conn.getDatabase().prepare(this);
            if (!this.exec()) {
                this.internalClose();
                throw new SQLException("query does not return ResultSet", "SQLITE_DONE", 101);
            }
            this.exhaustedResults = false;
            return this.getResultSet();
        });
    }

    /*
     * WARNING - void declaration
     */
    public int executeUpdate(String sql) throws SQLException {
        void var1_1;
        return (int)this.executeLargeUpdate((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        void var1_1;
        return this.executeUpdate((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long executeLargeUpdate(String sql) throws SQLException {
        void var1_1;
        this.internalClose();
        this.sql = sql;
        JDBC3Statement jDBC3Statement = this;
        return jDBC3Statement.withConnectionTimeout(() -> jDBC3Statement.lambda$executeLargeUpdate$2((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        void var1_1;
        return this.executeLargeUpdate((String)var1_1);
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        if (this.exhaustedResults) {
            return null;
        }
        if (this.rs.isOpen()) {
            throw new SQLException("ResultSet already requested");
        }
        if (this.pointer.safeRunInt(DB::column_count) == 0) {
            return null;
        }
        if (this.rs.colsMeta == null) {
            this.rs.colsMeta = this.pointer.safeRun(DB::column_names);
        }
        this.rs.cols = this.rs.colsMeta;
        this.rs.emptyResultSet = !this.resultsWaiting;
        this.rs.open = true;
        this.resultsWaiting = false;
        return (ResultSet)((Object)this.rs);
    }

    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    public long getLargeUpdateCount() throws SQLException {
        this.conn.getDatabase();
        if (!(this.pointer.isClosed() || this.rs.isOpen() || this.resultsWaiting || this.pointer.safeRunInt(DB::column_count) != 0)) {
            return this.updateCount;
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public void addBatch(String sql) throws SQLException {
        void var1_1;
        this.internalClose();
        if (this.batch == null || this.batchPos + 1 >= this.batch.length) {
            void var2_2;
            Object[] nb = new Object[Math.max(10, this.batchPos * 2)];
            if (this.batch != null) {
                System.arraycopy(this.batch, 0, nb, 0, this.batch.length);
            }
            this.batch = var2_2;
        }
        this.batch[this.batchPos++] = var1_1;
    }

    public void clearBatch() throws SQLException {
        this.batchPos = 0;
        if (this.batch != null) {
            for (int i = 0; i < this.batch.length; ++i) {
                this.batch[i] = null;
            }
        }
    }

    public int[] executeBatch() throws SQLException {
        return Arrays.stream(this.executeLargeBatch()).mapToInt(l -> (int)l).toArray();
    }

    /*
     * WARNING - void declaration
     */
    public long[] executeLargeBatch() throws SQLException {
        DB db;
        this.internalClose();
        if (this.batch == null || this.batchPos == 0) {
            return new long[0];
        }
        long[] changes = new long[this.batchPos];
        DB dB = db = this.conn.getDatabase();
        synchronized (db) {
            void var1_1;
            try {
                for (int i = 0; i < changes.length; ++i) {
                    try {
                        this.sql = (String)this.batch[i];
                        db.prepare(this);
                        changes[i] = db.executeUpdate(this, null);
                        continue;
                    }
                    catch (SQLException e) {
                        void var2_6;
                        throw new BatchUpdateException("batch entry " + i + ": " + e.getMessage(), null, 0, changes, (Throwable)var2_6);
                    }
                    finally {
                        if (this.pointer != null) {
                            this.pointer.close();
                        }
                    }
                }
            }
            finally {
                this.clearBatch();
            }
            // ** MonitorExit[var3_7] (shouldn't be in output)
            return var1_1;
        }
    }

    public void setCursorName(String name) {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public void cancel() throws SQLException {
        this.conn.getDatabase().interrupt();
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryTimeout(int seconds) throws SQLException {
        void var1_1;
        if (seconds < 0) {
            throw new SQLException("query timeout must be >= 0");
        }
        this.queryTimeout = var1_1;
    }

    public int getMaxRows() throws SQLException {
        return (int)this.rs.maxRows;
    }

    public long getLargeMaxRows() throws SQLException {
        return this.rs.maxRows;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxRows(int max) throws SQLException {
        void var1_1;
        this.setLargeMaxRows((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLargeMaxRows(long max) throws SQLException {
        void var1_1;
        if (max < 0L) {
            throw new SQLException("max row count must be >= 0");
        }
        this.rs.maxRows = var1_1;
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            void var1_1;
            throw new SQLException("max field size " + (int)var1_1 + " cannot be negative");
        }
    }

    public int getFetchSize() throws SQLException {
        return ((ResultSet)((Object)this.rs)).getFetchSize();
    }

    /*
     * WARNING - void declaration
     */
    public void setFetchSize(int r) throws SQLException {
        void var1_1;
        ((ResultSet)((Object)this.rs)).setFetchSize((int)var1_1);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    /*
     * WARNING - void declaration
     */
    public void setFetchDirection(int direction) throws SQLException {
        void var1_1;
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                return;
            }
        }
        throw new SQLException("Unknown fetch direction " + (int)var1_1 + ". Must be one of FETCH_FORWARD, FETCH_REVERSE, or FETCH_UNKNOWN in java.sql.ResultSet");
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getMoreResults(int current) throws SQLException {
        void var1_1;
        this.checkOpen();
        if (current == 2 || current == 3) {
            throw new SQLFeatureNotSupportedException("Argument not supported: Statement.KEEP_CURRENT_RESULT or Statement.CLOSE_ALL_RESULTS");
        }
        if (var1_1 != true) {
            throw new SQLException("Invalid argument");
        }
        this.rs.close();
        this.updateCount = -1L;
        this.exhaustedResults = true;
        return false;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public int getResultSetType() throws SQLException {
        return 1003;
    }

    public void setEscapeProcessing(boolean enable) {
    }

    protected SQLException unsupported() {
        return new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    public boolean execute(String sql, int[] colinds) throws SQLException {
        throw this.unsupported();
    }

    public boolean execute(String sql, String[] colnames) throws SQLException {
        throw this.unsupported();
    }

    public int executeUpdate(String sql, int[] colinds) throws SQLException {
        throw this.unsupported();
    }

    public int executeUpdate(String sql, String[] cols) throws SQLException {
        throw this.unsupported();
    }

    public long executeLargeUpdate(String sql, int[] colinds) throws SQLException {
        throw this.unsupported();
    }

    public long executeLargeUpdate(String sql, String[] cols) throws SQLException {
        throw this.unsupported();
    }

    /*
     * WARNING - void declaration
     */
    protected <T> T withConnectionTimeout(SQLCallable<T> callable) throws SQLException {
        Object t;
        block4: {
            int origBusyTimeout = this.conn.getBusyTimeout();
            if (this.queryTimeout > 0) {
                this.conn.setBusyTimeout(1000 * this.queryTimeout);
            }
            try {
                t = t.call();
                if (this.queryTimeout <= 0) break block4;
            }
            catch (Throwable throwable) {
                if (this.queryTimeout > 0) {
                    void var2_3;
                    this.conn.setBusyTimeout((int)var2_3);
                }
                throw throwable;
            }
            this.conn.setBusyTimeout(origBusyTimeout);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Long lambda$executeLargeUpdate$2(String sql) throws SQLException {
        void var3_6;
        DB db = this.conn.getDatabase();
        long changes = 0L;
        ExtendedCommand.SQLExtension ext = ExtendedCommand.parse(sql);
        if (ext != null) {
            ext.execute(db);
        } else {
            try {
                DB dB = db;
                synchronized (dB) {
                    void var2_5;
                    changes = db.total_changes();
                    int statusCode = db._exec(sql);
                    if (statusCode != 0) {
                        void var1_2;
                        throw DB.newSQLException((int)var1_2, "");
                    }
                    this.updateGeneratedKeys();
                    changes = var2_5.total_changes() - changes;
                }
            }
            finally {
                this.internalClose();
            }
        }
        return (long)var3_6;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Boolean lambda$execute$0(String sql) throws SQLException {
        SQLiteConnection sQLiteConnection;
        ExtendedCommand.SQLExtension ext = ExtendedCommand.parse(sql);
        if (ext != null) {
            ext.execute(this.conn.getDatabase());
            return Boolean.FALSE;
        }
        this.sql = sQLiteConnection;
        sQLiteConnection = this.conn;
        synchronized (sQLiteConnection) {
            void var2_3;
            this.conn.getDatabase().prepare(this);
            boolean result = this.exec();
            this.updateGeneratedKeys();
            this.updateCount = this.getDatabase().changes();
            this.exhaustedResults = false;
            return (boolean)var2_3;
        }
    }

    @FunctionalInterface
    protected static interface SQLCallable<T> {
        public T call() throws SQLException;
    }

    static class BackupObserver
    implements DB.ProgressObserver {
        private static final Logger logger = LoggerFactory.getLogger(BackupObserver.class);

        BackupObserver() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void progress(int remaining, int pageCount) {
            void var2_2;
            void var1_1;
            logger.info("remaining:{}, page count:{}", (Object)((int)var1_1), (Object)((int)var2_2));
        }
    }
}

