/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.javax;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import org.sqlite.SQLiteConnection;
import org.sqlite.jdbc4.JDBC4PooledConnection;

public class SQLitePooledConnection
extends JDBC4PooledConnection {
    protected SQLiteConnection physicalConn;
    protected volatile Connection handleConn;
    protected List<ConnectionEventListener> listeners = new ArrayList<ConnectionEventListener>();

    /*
     * WARNING - void declaration
     */
    protected SQLitePooledConnection(SQLiteConnection physicalConn) {
        void var1_1;
        this.physicalConn = var1_1;
    }

    public SQLiteConnection getPhysicalConn() {
        return this.physicalConn;
    }

    @Override
    public void close() throws SQLException {
        if (this.handleConn != null) {
            this.listeners.clear();
            this.handleConn.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
                return;
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.handleConn != null) {
            this.handleConn.close();
        }
        this.handleConn = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(this){
            boolean isClosed;
            final /* synthetic */ SQLitePooledConnection this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ConnectionEvent event;
                try {
                    void i2;
                    String name = method.getName();
                    if ("close".equals(name)) {
                        event = new ConnectionEvent(this.this$0);
                        for (int i2 = this.this$0.listeners.size() - 1; i2 >= 0; --i2) {
                            this.this$0.listeners.get(i2).connectionClosed(event);
                        }
                        if (!this.this$0.physicalConn.getAutoCommit()) {
                            this.this$0.physicalConn.rollback();
                        }
                        this.this$0.physicalConn.setAutoCommit(true);
                        this.isClosed = true;
                        return null;
                    }
                    if ("isClosed".equals(name)) {
                        if (!this.isClosed) {
                            this.isClosed = (Boolean)((Method)((Object)event)).invoke(this.this$0.physicalConn, (Object[])i2);
                        }
                        return this.isClosed;
                    }
                    if (this.isClosed) {
                        throw new SQLException("Connection is closed");
                    }
                    return ((Method)((Object)event)).invoke(this.this$0.physicalConn, (Object[])i2);
                }
                catch (SQLException e) {
                    void var1_2;
                    if ("database connection closed".equals(e.getMessage())) {
                        event = new ConnectionEvent(this.this$0, e);
                        for (int i = this.this$0.listeners.size() - 1; i >= 0; --i) {
                            this.this$0.listeners.get(i).connectionErrorOccurred(event);
                        }
                    }
                    throw var1_2;
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    throw invocationTargetException.getCause();
                }
            }
        });
        return this.handleConn;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        void var1_1;
        this.listeners.add((ConnectionEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        void var1_1;
        this.listeners.remove(var1_1);
    }

    public List<ConnectionEventListener> getListeners() {
        return this.listeners;
    }
}

