/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sqlite.BusyHandler;
import org.sqlite.Collation;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteCommitListener;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;
import org.sqlite.SQLiteUpdateListener;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.SafeStmtPtr;

public abstract class DB
implements Codes {
    private final String url;
    private final String fileName;
    private final SQLiteConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    volatile SafeStmtPtr begin;
    volatile SafeStmtPtr commit;
    private final Set<SafeStmtPtr> stmts = ConcurrentHashMap.newKeySet();
    private final Set<SQLiteUpdateListener> updateListeners = new HashSet<SQLiteUpdateListener>();
    private final Set<SQLiteCommitListener> commitListeners = new HashSet<SQLiteCommitListener>();

    /*
     * WARNING - void declaration
     */
    public DB(String url, String fileName, SQLiteConfig config) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.url = var1_1;
        this.fileName = var2_2;
        this.config = var3_3;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public SQLiteConfig getConfig() {
        return this.config;
    }

    public abstract void interrupt() throws SQLException;

    public abstract void busy_timeout(int var1) throws SQLException;

    public abstract void busy_handler(BusyHandler var1) throws SQLException;

    abstract String errmsg() throws SQLException;

    public abstract String libversion() throws SQLException;

    public abstract long changes() throws SQLException;

    public abstract long total_changes() throws SQLException;

    public abstract int shared_cache(boolean var1) throws SQLException;

    public abstract int enable_load_extension(boolean var1) throws SQLException;

    /*
     * Exception decompiling
     */
    public final synchronized void exec(String sql, boolean autoCommit) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void open(String file, int openFlags) throws SQLException {
        void var2_2;
        void var1_1;
        this._open((String)var1_1, (int)var2_2);
        this.closed.set(false);
        if (this.fileName.startsWith("file:") && !this.fileName.contains("cache=")) {
            DB dB = this;
            dB.shared_cache(dB.config.isEnabledSharedCache());
        }
        DB dB = this;
        dB.enable_load_extension(dB.config.isEnabledLoadExtension());
        DB dB2 = this;
        dB2.busy_timeout(dB2.config.getBusyTimeout());
    }

    public final synchronized void close() throws SQLException {
        for (SafeStmtPtr safeStmtPtr : this.stmts) {
            safeStmtPtr.close();
        }
        if (this.begin != null) {
            this.begin.close();
        }
        if (this.commit != null) {
            this.commit.close();
        }
        this.closed.set(true);
        this._close();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void prepare(CoreStatement stmt) throws SQLException {
        void var1_1;
        if (stmt.sql == null) {
            throw new NullPointerException();
        }
        if (stmt.pointer != null) {
            stmt.pointer.close();
        }
        stmt.pointer = this.prepare(stmt.sql);
        boolean bl = this.stmts.add(var1_1.pointer);
        if (!bl) {
            throw new IllegalStateException("Already added pointer to statements set");
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int finalize(SafeStmtPtr safePtr, long ptr) throws SQLException {
        int n;
        try {
            void var2_2;
            n = this.finalize((long)var2_2);
            this.stmts.remove(safePtr);
        }
        catch (Throwable throwable) {
            void var1_1;
            this.stmts.remove(var1_1);
            throw throwable;
        }
        return n;
    }

    protected abstract void _open(String var1, int var2) throws SQLException;

    protected abstract void _close() throws SQLException;

    public abstract int _exec(String var1) throws SQLException;

    protected abstract SafeStmtPtr prepare(String var1) throws SQLException;

    protected abstract int finalize(long var1) throws SQLException;

    public abstract int step(long var1) throws SQLException;

    public abstract int reset(long var1) throws SQLException;

    public abstract int clear_bindings(long var1) throws SQLException;

    abstract int bind_parameter_count(long var1) throws SQLException;

    public abstract int column_count(long var1) throws SQLException;

    public abstract int column_type(long var1, int var3) throws SQLException;

    public abstract String column_decltype(long var1, int var3) throws SQLException;

    public abstract String column_table_name(long var1, int var3) throws SQLException;

    public abstract String column_name(long var1, int var3) throws SQLException;

    public abstract String column_text(long var1, int var3) throws SQLException;

    public abstract byte[] column_blob(long var1, int var3) throws SQLException;

    public abstract double column_double(long var1, int var3) throws SQLException;

    public abstract long column_long(long var1, int var3) throws SQLException;

    public abstract int column_int(long var1, int var3) throws SQLException;

    abstract int bind_null(long var1, int var3) throws SQLException;

    abstract int bind_int(long var1, int var3, int var4) throws SQLException;

    abstract int bind_long(long var1, int var3, long var4) throws SQLException;

    abstract int bind_double(long var1, int var3, double var4) throws SQLException;

    abstract int bind_text(long var1, int var3, String var4) throws SQLException;

    abstract int bind_blob(long var1, int var3, byte[] var4) throws SQLException;

    public abstract void result_null(long var1) throws SQLException;

    public abstract void result_text(long var1, String var3) throws SQLException;

    public abstract void result_blob(long var1, byte[] var3) throws SQLException;

    public abstract void result_double(long var1, double var3) throws SQLException;

    public abstract void result_long(long var1, long var3) throws SQLException;

    public abstract void result_int(long var1, int var3) throws SQLException;

    public abstract void result_error(long var1, String var3) throws SQLException;

    public abstract String value_text(Function var1, int var2) throws SQLException;

    public abstract byte[] value_blob(Function var1, int var2) throws SQLException;

    public abstract double value_double(Function var1, int var2) throws SQLException;

    public abstract long value_long(Function var1, int var2) throws SQLException;

    public abstract int value_int(Function var1, int var2) throws SQLException;

    public abstract int value_type(Function var1, int var2) throws SQLException;

    public abstract int create_function(String var1, Function var2, int var3, int var4) throws SQLException;

    public abstract int destroy_function(String var1) throws SQLException;

    public abstract int create_collation(String var1, Collation var2) throws SQLException;

    public abstract int destroy_collation(String var1) throws SQLException;

    public abstract int backup(String var1, String var2, ProgressObserver var3) throws SQLException;

    public abstract int backup(String var1, String var2, ProgressObserver var3, int var4, int var5, int var6) throws SQLException;

    public abstract int restore(String var1, String var2, ProgressObserver var3) throws SQLException;

    public abstract int restore(String var1, String var2, ProgressObserver var3, int var4, int var5, int var6) throws SQLException;

    public abstract int limit(int var1, int var2) throws SQLException;

    public abstract void register_progress_handler(int var1, ProgressHandler var2) throws SQLException;

    public abstract void clear_progress_handler() throws SQLException;

    abstract boolean[][] column_metadata(long var1) throws SQLException;

    /*
     * WARNING - void declaration
     */
    public final synchronized String[] column_names(long stmt) throws SQLException {
        void var3_2;
        String[] names = new String[this.column_count(stmt)];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.column_name(stmt, i);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    final synchronized int sqlbind(long stmt, int pos, Object v) throws SQLException {
        ++pos;
        if (v == null) {
            return this.bind_null(stmt, pos);
        }
        if (v instanceof Integer) {
            return this.bind_int(stmt, pos, (Integer)v);
        }
        if (v instanceof Short) {
            return this.bind_int(stmt, pos, ((Short)v).intValue());
        }
        if (v instanceof Long) {
            return this.bind_long(stmt, pos, (Long)v);
        }
        if (v instanceof Float) {
            return this.bind_double(stmt, pos, ((Float)v).doubleValue());
        }
        if (v instanceof Double) {
            return this.bind_double(stmt, pos, (Double)v);
        }
        if (v instanceof String) {
            return this.bind_text(stmt, pos, (String)v);
        }
        if (v instanceof byte[]) {
            void var3_2;
            void var1_1;
            return this.bind_blob((long)var1_1, (int)var3_2, (byte[])v);
        }
        throw new SQLException("unexpected param type: " + v.getClass());
    }

    /*
     * WARNING - void declaration
     */
    final synchronized long[] executeBatch(SafeStmtPtr stmt, int count, Object[] vals, boolean autoCommit) throws SQLException {
        void var3_3;
        void var2_2;
        return stmt.safeRun((arg_0, arg_1) -> this.lambda$executeBatch$0((int)var2_2, (Object[])var3_3, autoCommit, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private synchronized long[] executeBatch(long stmt, int count, Object[] vals, boolean autoCommit) throws SQLException {
        void var1_1;
        if (count <= 0) {
            throw new SQLException("count (" + count + ") < 1");
        }
        int params = this.bind_parameter_count(stmt);
        long[] changes = new long[count];
        try {
            for (int i = 0; i < count; ++i) {
                int rc;
                this.reset(stmt);
                for (int j = 0; j < params; ++j) {
                    rc = this.sqlbind(stmt, j, vals[i * params + j]);
                    if (rc == 0) continue;
                    this.throwex(rc);
                }
                rc = this.step(stmt);
                if (rc != 101) {
                    this.reset(stmt);
                    if (rc == 100) {
                        throw new BatchUpdateException("batch entry " + i + ": query returns results", null, 0, changes, null);
                    }
                    this.throwex(rc);
                }
                changes[i] = this.changes();
            }
        }
        finally {
            this.ensureAutoCommit(autoCommit);
        }
        this.reset((long)var1_1);
        return changes;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean execute(CoreStatement stmt, Object[] vals) throws SQLException {
        void var2_3;
        void var1_1;
        int statusCode = stmt.pointer.safeRunInt((db, ptr) -> {
            void var1_1;
            void var3_3;
            return this.execute((long)var3_3, (Object[])var1_1);
        });
        switch (statusCode & 0xFF) {
            case 101: {
                this.ensureAutoCommit(stmt.conn.getAutoCommit());
                return false;
            }
            case 100: {
                return true;
            }
            case 5: 
            case 6: 
            case 19: 
            case 21: {
                throw this.newSQLException(statusCode);
            }
        }
        var1_1.pointer.close();
        throw this.newSQLException((int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized int execute(long ptr, Object[] vals) throws SQLException {
        int statusCode;
        if (vals != null) {
            int params = this.bind_parameter_count(ptr);
            if (params > vals.length) {
                throw new SQLException("assertion failure: param count (" + params + ") > value count (" + vals.length + ")");
            }
            for (int i = 0; i < params; ++i) {
                int rc = this.sqlbind(ptr, i, vals[i]);
                if (rc == 0) continue;
                this.throwex(rc);
            }
        }
        if (((statusCode = this.step(ptr)) & 0xFF) == 101) {
            void var1_1;
            this.reset((long)var1_1);
        }
        return statusCode;
    }

    /*
     * WARNING - void declaration
     */
    final synchronized boolean execute(String sql, boolean autoCommit) throws SQLException {
        void var1_2;
        int statusCode = this._exec(sql);
        switch (statusCode) {
            case 0: {
                return false;
            }
            case 101: {
                void var2_3;
                this.ensureAutoCommit((boolean)var2_3);
                return false;
            }
            case 100: {
                return true;
            }
        }
        throw this.newSQLException((int)var1_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized long executeUpdate(CoreStatement stmt, Object[] vals) throws SQLException {
        try {
            void var2_2;
            if (this.execute(stmt, (Object[])var2_2)) {
                throw new SQLException("query returns results");
            }
            if (stmt.pointer.isClosed()) return this.changes();
        }
        catch (Throwable throwable) {
            void var1_1;
            if (stmt.pointer.isClosed()) throw throwable;
            var1_1.pointer.safeRunInt(DB::reset);
            throw throwable;
        }
        stmt.pointer.safeRunInt(DB::reset);
        return this.changes();
    }

    abstract void set_commit_listener(boolean var1);

    abstract void set_update_listener(boolean var1);

    /*
     * WARNING - void declaration
     */
    public synchronized void addUpdateListener(SQLiteUpdateListener listener) {
        void var1_1;
        if (this.updateListeners.add((SQLiteUpdateListener)var1_1) && this.updateListeners.size() == 1) {
            this.set_update_listener(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addCommitListener(SQLiteCommitListener listener) {
        void var1_1;
        if (this.commitListeners.add((SQLiteCommitListener)var1_1) && this.commitListeners.size() == 1) {
            this.set_commit_listener(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeUpdateListener(SQLiteUpdateListener listener) {
        void var1_1;
        if (this.updateListeners.remove(var1_1) && this.updateListeners.isEmpty()) {
            this.set_update_listener(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeCommitListener(SQLiteCommitListener listener) {
        void var1_1;
        if (this.commitListeners.remove(var1_1) && this.commitListeners.isEmpty()) {
            this.set_commit_listener(false);
        }
    }

    void onUpdate(int type, String database, String table, long rowId) {
        HashSet<SQLiteUpdateListener> listeners;
        DB dB = this;
        synchronized (dB) {
            listeners = new HashSet<SQLiteUpdateListener>(this.updateListeners);
        }
        for (SQLiteUpdateListener listener : listeners) {
            SQLiteUpdateListener.Type operationType;
            switch (type) {
                case 18: {
                    operationType = SQLiteUpdateListener.Type.INSERT;
                    break;
                }
                case 9: {
                    operationType = SQLiteUpdateListener.Type.DELETE;
                    break;
                }
                case 23: {
                    operationType = SQLiteUpdateListener.Type.UPDATE;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + type));
                }
            }
            listener.onUpdate(operationType, database, table, rowId);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onCommit(boolean commit) {
        HashSet<SQLiteCommitListener> listeners;
        DB dB = this;
        synchronized (dB) {
            listeners = new HashSet<SQLiteCommitListener>(this.commitListeners);
        }
        for (SQLiteCommitListener listener : listeners) {
            void var2_3;
            if (commit) {
                listener.onCommit();
                continue;
            }
            var2_3.onRollback();
        }
    }

    final void throwex() throws SQLException {
        throw new SQLException(this.errmsg());
    }

    /*
     * WARNING - void declaration
     */
    public final void throwex(int errorCode) throws SQLException {
        void var1_1;
        throw this.newSQLException((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void throwex(int errorCode, String errorMessage) throws SQLException {
        void var1_1;
        throw DB.newSQLException(errorCode, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SQLiteException newSQLException(int errorCode, String errorMessage) {
        void var2_3;
        void var0_1;
        void var1_2;
        SQLiteErrorCode code = SQLiteErrorCode.getErrorCode(errorCode);
        String msg = code == SQLiteErrorCode.UNKNOWN_ERROR ? String.format("%s:%s (%s)", new Object[]{code, errorCode, errorMessage}) : String.format("%s (%s)", new Object[]{code, var1_2});
        return new SQLiteException((String)var0_1, (SQLiteErrorCode)var2_3);
    }

    private SQLiteException newSQLException(int errorCode) throws SQLException {
        return DB.newSQLException(errorCode, this.errmsg());
    }

    final void ensureAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            return;
        }
        this.ensureBeginAndCommit();
        this.begin.safeRunConsume((db, beginPtr) -> {
            void var2_2;
            this.commit.safeRunConsume((arg_0, arg_1) -> this.lambda$ensureAutoCommit$2((long)var2_2, arg_0, arg_1));
        });
    }

    private void ensureBeginAndCommit() throws SQLException {
        DB dB;
        if (this.begin == null) {
            dB = this;
            synchronized (dB) {
                if (this.begin == null) {
                    this.begin = this.prepare("begin;");
                }
            }
        }
        if (this.commit == null) {
            dB = this;
            synchronized (dB) {
                if (this.commit == null) {
                    this.commit = this.prepare("commit;");
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureAutocommit(long beginPtr, long commitPtr) throws SQLException {
        block4: {
            block3: {
                try {
                    if (this.step(beginPtr) == 101) break block3;
                }
                catch (Throwable throwable) {
                    void var3_2;
                    void var1_1;
                    this.reset((long)var1_1);
                    this.reset((long)var3_2);
                    throw throwable;
                }
                this.reset(beginPtr);
                this.reset(commitPtr);
                return;
            }
            int rc = this.step(commitPtr);
            if (rc == 101) break block4;
            this.reset(commitPtr);
            this.throwex(rc);
        }
        this.reset(beginPtr);
        this.reset(commitPtr);
    }

    public abstract byte[] serialize(String var1) throws SQLException;

    public abstract void deserialize(String var1, byte[] var2) throws SQLException;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$ensureAutoCommit$2(long beginPtr, DB db2, long commitPtr) throws SQLException {
        void var1_1;
        this.ensureAutocommit((long)var1_1, commitPtr);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ long[] lambda$executeBatch$0(int count, Object[] vals, boolean autoCommit, DB db, long ptr) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.executeBatch(ptr, (int)var1_1, (Object[])var2_2, (boolean)var3_3);
    }

    public static interface ProgressObserver {
        public void progress(int var1, int var2);
    }
}

