/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class CoreResultSet
implements Codes {
    protected final CoreStatement stmt;
    public boolean emptyResultSet = false;
    public boolean open = false;
    public long maxRows;
    public String[] cols = null;
    public String[] colsMeta = null;
    protected boolean[][] meta = null;
    protected int limitRows;
    protected int row = 0;
    protected boolean pastLastRow = false;
    protected int lastCol;
    public boolean closeStmt;
    protected Map<String, Integer> columnNameToIndex = null;

    /*
     * WARNING - void declaration
     */
    protected CoreResultSet(CoreStatement stmt) {
        void var1_1;
        this.stmt = var1_1;
    }

    protected DB getDatabase() {
        return this.stmt.getDatabase();
    }

    protected SQLiteConnectionConfig getConnectionConfig() {
        return this.stmt.getConnectionConfig();
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws SQLException {
        if (!this.open) {
            throw new SQLException("ResultSet closed");
        }
    }

    /*
     * WARNING - void declaration
     */
    public int checkCol(int col) throws SQLException {
        void var1_1;
        if (this.colsMeta == null) {
            throw new SQLException("SQLite JDBC: inconsistent internal state");
        }
        if (col <= 0 || col > this.colsMeta.length) {
            throw new SQLException("column " + col + " out of bounds [1," + this.colsMeta.length + "]");
        }
        --col;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected int markCol(int col) throws SQLException {
        void var1_1;
        this.checkCol(col);
        this.lastCol = col--;
        return (int)var1_1;
    }

    public void checkMeta() throws SQLException {
        this.checkCol(1);
        if (this.meta == null) {
            this.meta = this.stmt.pointer.safeRun(DB::column_metadata);
        }
    }

    public void close() throws SQLException {
        this.cols = null;
        this.colsMeta = null;
        this.meta = null;
        this.limitRows = 0;
        this.row = 0;
        this.pastLastRow = false;
        this.lastCol = -1;
        this.columnNameToIndex = null;
        this.emptyResultSet = false;
        if (this.stmt.pointer.isClosed() || !this.open && !this.closeStmt) {
            return;
        }
        DB dB = this.stmt.getDatabase();
        DB dB2 = dB;
        dB2 = dB;
        synchronized (dB) {
            if (!this.stmt.pointer.isClosed()) {
                this.stmt.pointer.safeRunInt(DB::reset);
                if (this.closeStmt) {
                    this.closeStmt = false;
                    ((Statement)((Object)this.stmt)).close();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.open = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Integer findColumnIndexInCache(String col) {
        void var1_1;
        if (this.columnNameToIndex == null) {
            return null;
        }
        return this.columnNameToIndex.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected int addColumnIndexInCache(String col, int index) {
        void var2_2;
        void var1_1;
        if (this.columnNameToIndex == null) {
            this.columnNameToIndex = new HashMap<String, Integer>(this.cols.length);
        }
        this.columnNameToIndex.put((String)var1_1, index);
        return (int)var2_2;
    }
}

