/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.DB;

public abstract class Function {
    public static final int FLAG_DETERMINISTIC = 2048;
    private SQLiteConnection conn;
    private DB db;
    long context = 0L;
    long value = 0L;
    int args = 0;

    /*
     * WARNING - void declaration
     */
    public static void create(Connection conn, String name, Function f) throws SQLException {
        void var2_2;
        void var1_1;
        Function.create(conn, (String)var1_1, (Function)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void create(Connection conn, String name, Function f, int flags) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        Function.create(conn, (String)var1_1, (Function)var2_2, -1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void create(Connection conn, String name, Function f, int nArgs, int flags) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        Connection connection;
        if (!(conn instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        if (conn.isClosed()) {
            throw new SQLException("connection closed");
        }
        f.conn = (SQLiteConnection)connection;
        f.db = f.conn.getDatabase();
        if (nArgs < -1 || nArgs > 127) {
            throw new SQLException("invalid args provided: " + nArgs);
        }
        if (f.db.create_function((String)var1_1, (Function)var2_2, (int)var3_3, flags) != 0) {
            throw new SQLException("error creating function");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void destroy(Connection conn, String name, int nArgs) throws SQLException {
        void var1_1;
        Connection connection;
        if (!(conn instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        ((SQLiteConnection)connection).getDatabase().destroy_function((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void destroy(Connection conn, String name) throws SQLException {
        void var1_1;
        Function.destroy(conn, (String)var1_1, -1);
    }

    protected abstract void xFunc() throws SQLException;

    protected final synchronized int args() throws SQLException {
        this.checkContext();
        return this.args;
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized void result(byte[] value) throws SQLException {
        void var1_1;
        this.checkContext();
        this.db.result_blob(this.context, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized void result(double value) throws SQLException {
        void var1_1;
        this.checkContext();
        this.db.result_double(this.context, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized void result(int value) throws SQLException {
        void var1_1;
        this.checkContext();
        this.db.result_int(this.context, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized void result(long value) throws SQLException {
        void var1_1;
        this.checkContext();
        this.db.result_long(this.context, (long)var1_1);
    }

    protected final synchronized void result() throws SQLException {
        this.checkContext();
        this.db.result_null(this.context);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized void result(String value) throws SQLException {
        void var1_1;
        this.checkContext();
        this.db.result_text(this.context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized void error(String err) throws SQLException {
        void var1_1;
        this.checkContext();
        this.db.result_error(this.context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized String value_text(int arg) throws SQLException {
        void var1_1;
        this.checkValue(arg);
        return this.db.value_text(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized byte[] value_blob(int arg) throws SQLException {
        void var1_1;
        this.checkValue(arg);
        return this.db.value_blob(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized double value_double(int arg) throws SQLException {
        void var1_1;
        this.checkValue(arg);
        return this.db.value_double(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized int value_int(int arg) throws SQLException {
        void var1_1;
        this.checkValue(arg);
        return this.db.value_int(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized long value_long(int arg) throws SQLException {
        void var1_1;
        this.checkValue(arg);
        return this.db.value_long(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final synchronized int value_type(int arg) throws SQLException {
        void var1_1;
        this.checkValue(arg);
        return this.db.value_type(this, (int)var1_1);
    }

    private void checkContext() throws SQLException {
        if (this.conn == null || this.conn.getDatabase() == null || this.context == 0L) {
            throw new SQLException("no context, not allowed to read value");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkValue(int arg) throws SQLException {
        if (this.conn == null || this.conn.getDatabase() == null || this.value == 0L) {
            throw new SQLException("not in value access state");
        }
        if (arg >= this.args) {
            void var1_1;
            throw new SQLException("arg " + (int)var1_1 + " out bounds [0," + this.args + ")");
        }
    }

    public static abstract class Window
    extends Aggregate {
        protected abstract void xInverse() throws SQLException;

        protected abstract void xValue() throws SQLException;
    }

    public static abstract class Aggregate
    extends Function
    implements Cloneable {
        @Override
        protected final void xFunc() {
        }

        protected abstract void xStep() throws SQLException;

        protected abstract void xFinal() throws SQLException;

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

