/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

public interface NumberConsumptionError {
    public String errorMessage();

    public static final class Conflicting
    implements NumberConsumptionError {
        private final Object conflicting;

        /*
         * WARNING - void declaration
         */
        public Conflicting(Object conflicting) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)conflicting, (String)"conflicting");
            this.conflicting = var1_1;
        }

        @Override
        public final String errorMessage() {
            return "attempted to overwrite the existing value '" + this.conflicting + '\'';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lkotlinx/datetime/internal/format/parser/NumberConsumptionError$ExpectedInt;", "Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "<init>", "()V", "", "errorMessage", "()Ljava/lang/String;"})
    public static final class ExpectedInt
    implements NumberConsumptionError {
        public static final ExpectedInt INSTANCE = new ExpectedInt();

        private ExpectedInt() {
        }

        @Override
        public final String errorMessage() {
            return "expected an Int value";
        }
    }

    public static final class TooFewDigits
    implements NumberConsumptionError {
        private final int minDigits;

        /*
         * WARNING - void declaration
         */
        public TooFewDigits(int minDigits) {
            void var1_1;
            this.minDigits = var1_1;
        }

        @Override
        public final String errorMessage() {
            return "expected at least " + this.minDigits + " digits";
        }
    }

    public static final class TooManyDigits
    implements NumberConsumptionError {
        private final int maxDigits;

        /*
         * WARNING - void declaration
         */
        public TooManyDigits(int maxDigits) {
            void var1_1;
            this.maxDigits = var1_1;
        }

        @Override
        public final String errorMessage() {
            return "expected at most " + this.maxDigits + " digits";
        }
    }

    public static final class WrongConstant
    implements NumberConsumptionError {
        private final String expected;

        /*
         * WARNING - void declaration
         */
        public WrongConstant(String expected) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            this.expected = var1_1;
        }

        @Override
        public final String errorMessage() {
            return "expected '" + this.expected + '\'';
        }
    }
}

