/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.formatter;

import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.internal.DecimalFraction;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;

public final class DecimalFractionFormatterStructure<T>
implements FormatterStructure<T> {
    private final Function1<T, DecimalFraction> number;
    private final int minDigits;
    private final int maxDigits;
    private final List<Integer> zerosToAdd;

    /*
     * WARNING - void declaration
     */
    public DecimalFractionFormatterStructure(Function1<? super T, DecimalFraction> number, int minDigits, int maxDigits, List<Integer> zerosToAdd) {
        void var3_6;
        int n;
        void var1_1;
        Intrinsics.checkNotNullParameter(number, (String)"number");
        Intrinsics.checkNotNullParameter(zerosToAdd, (String)"zerosToAdd");
        this.number = var1_1;
        this.minDigits = n;
        this.maxDigits = var3_6;
        this.zerosToAdd = zerosToAdd;
        int n2 = this.minDigits;
        if (!(n2 > 0 ? n2 < 10 : false)) {
            String string = "The minimum number of digits (" + this.minDigits + ") is not in range 1..9";
            throw new IllegalArgumentException(string.toString());
        }
        n2 = this.minDigits;
        n = this.maxDigits;
        if (!(n2 <= n ? n < 10 : false)) {
            String string = "The maximum number of digits (" + this.maxDigits + ") is not in range " + this.minDigits + "..9";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(T obj, Appendable builder, boolean minusNotRequired) {
        void var2_3;
        void var1_2;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        obj = (DecimalFraction)this.number.invoke(obj);
        int numberWithRequiredPrecision = ((DecimalFraction)obj).fractionalPartWithNDigits(this.maxDigits);
        int zerosToStrip = 0;
        while (this.maxDigits > this.minDigits + zerosToStrip && numberWithRequiredPrecision % MathKt.getPOWERS_OF_TEN()[zerosToStrip + 1] == 0) {
            ++zerosToStrip;
        }
        int zerosToAddBack = ((Number)this.zerosToAdd.get(this.maxDigits - zerosToStrip - 1)).intValue();
        if (zerosToStrip >= zerosToAddBack) {
            zerosToStrip -= zerosToAddBack;
        }
        int digitsToOutput = this.maxDigits - zerosToStrip;
        int numberToOutput = numberWithRequiredPrecision / MathKt.getPOWERS_OF_TEN()[var3_4];
        String string = String.valueOf((int)(var1_2 + MathKt.getPOWERS_OF_TEN()[digitsToOutput])).substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        var2_3.append(string);
    }
}

