/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.MathKt;

@SourceDebugExtension(value={"SMAP\nmath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/DecimalFraction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
public final class DecimalFraction
implements Comparable<DecimalFraction> {
    private final int fractionalPart;
    private final int digits;

    /*
     * WARNING - void declaration
     */
    public DecimalFraction(int fractionalPart, int digits) {
        void var2_3;
        void var1_1;
        this.fractionalPart = var1_1;
        this.digits = var2_3;
        if (!(this.digits >= 0)) {
            String string = "Digits must be non-negative, but was " + this.digits;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int fractionalPartWithNDigits(int newDigits) {
        void var1_1;
        if (newDigits == this.digits) {
            return this.fractionalPart;
        }
        if (newDigits > this.digits) {
            return this.fractionalPart * MathKt.getPOWERS_OF_TEN()[newDigits - this.digits];
        }
        return this.fractionalPart / MathKt.getPOWERS_OF_TEN()[this.digits - var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private int compareTo(DecimalFraction other) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int maxPrecision = Math.max(this.digits, other.digits);
        return Intrinsics.compare((int)this.fractionalPartWithNDigits(maxPrecision), (int)var1_1.fractionalPartWithNDigits((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof DecimalFraction && this.compareTo((DecimalFraction)var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var3_3;
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        int denominator = MathKt.getPOWERS_OF_TEN()[this.digits];
        $this$toString_u24lambda_u242.append(this.fractionalPart / denominator);
        $this$toString_u24lambda_u242.append('.');
        var2_2.append(StringsKt.removePrefix((String)String.valueOf(denominator + this.fractionalPart % var3_3), (CharSequence)"1"));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("DecimalFraction is not supposed to be used as a hash key");
    }
}

