/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.FixedOffsetTimeZone;
import kotlinx.datetime.IllegalTimeZoneException;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZoneKt__TimeZoneJvmKt;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.serializers.TimeZoneSerializer;
import kotlinx.serialization.Serializable;

@Serializable(with=TimeZoneSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0012\u001a\u00020\u0011*\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0014\u001a\u00020\u0010*\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Lkotlinx/datetime/TimeZone;", "", "Ljava/time/ZoneId;", "zoneId", "<init>", "(Ljava/time/ZoneId;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/Instant;", "toInstant", "(Lkotlinx/datetime/LocalDateTime;)Lkotlinx/datetime/Instant;", "toLocalDateTime", "(Lkotlinx/datetime/Instant;)Lkotlinx/datetime/LocalDateTime;", "getId", "id", "Ljava/time/ZoneId;", "getZoneId$kotlinx_datetime", "()Ljava/time/ZoneId;", "Companion"})
public class TimeZone {
    public static final Companion Companion = new Companion(null);
    private final ZoneId zoneId;
    private static final FixedOffsetTimeZone UTC;

    /*
     * WARNING - void declaration
     */
    public TimeZone(ZoneId zoneId) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = var1_1;
    }

    public final ZoneId getZoneId$kotlinx_datetime() {
        return this.zoneId;
    }

    public final String getId() {
        String string = this.zoneId.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final LocalDateTime toLocalDateTime(Instant $this$toLocalDateTime) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        TimeZone timeZone = this;
        return TimeZoneKt__TimeZoneJvmKt.toLocalDateTime((Instant)var1_1, timeZone);
    }

    /*
     * WARNING - void declaration
     */
    public final Instant toInstant(LocalDateTime $this$toInstant) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"<this>");
        TimeZone timeZone = this;
        return TimeZoneKt__TimeZoneJvmKt.toInstant((LocalDateTime)var1_1, timeZone);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof TimeZone && Intrinsics.areEqual((Object)this.zoneId, (Object)((TimeZone)var1_1).zoneId);
    }

    public int hashCode() {
        return this.zoneId.hashCode();
    }

    public String toString() {
        String string = this.zoneId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"UTC");
        UtcOffset utcOffset = new UtcOffset(zoneOffset);
        Intrinsics.checkNotNullParameter((Object)utcOffset, (String)"<this>");
        UTC = new FixedOffsetTimeZone(utcOffset);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lkotlinx/datetime/TimeZone$Companion;", "", "<init>", "()V", "Lkotlinx/datetime/TimeZone;", "currentSystemDefault", "()Lkotlinx/datetime/TimeZone;", "", "zoneId", "of", "(Ljava/lang/String;)Lkotlinx/datetime/TimeZone;", "Ljava/time/ZoneId;", "ofZone$kotlinx_datetime", "(Ljava/time/ZoneId;)Lkotlinx/datetime/TimeZone;", "ofZone", "Lkotlinx/datetime/FixedOffsetTimeZone;", "UTC", "Lkotlinx/datetime/FixedOffsetTimeZone;", "getUTC", "()Lkotlinx/datetime/FixedOffsetTimeZone;", "", "getAvailableZoneIds", "()Ljava/util/Set;", "availableZoneIds"})
    public static final class Companion {
        private Companion() {
        }

        public final TimeZone currentSystemDefault() {
            ZoneId zoneId = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"systemDefault(...)");
            return kotlinx.datetime.TimeZone$Companion.ofZone$kotlinx_datetime(zoneId);
        }

        public final FixedOffsetTimeZone getUTC() {
            return UTC;
        }

        /*
         * WARNING - void declaration
         */
        public final TimeZone of(String zoneId) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            try {
                ZoneId zoneId2 = ZoneId.of((String)zoneId);
                Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(...)");
                zoneId = kotlinx.datetime.TimeZone$Companion.ofZone$kotlinx_datetime(zoneId2);
            }
            catch (Exception exception) {
                Exception e = exception;
                if (exception instanceof DateTimeException) {
                    throw new IllegalTimeZoneException(e);
                }
                throw var1_1;
            }
            return var1_1;
        }

        private static TimeZone ofZone$kotlinx_datetime(ZoneId zoneId) {
            ZoneId zoneId2;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            if (zoneId instanceof ZoneOffset) {
                return new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId));
            }
            if (TimeZoneKt__TimeZoneJvmKt.access$isFixedOffset(zoneId)) {
                ZoneId zoneId3 = zoneId.normalized();
                Intrinsics.checkNotNull((Object)zoneId3, (String)"null cannot be cast to non-null type java.time.ZoneOffset");
                return new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId3), zoneId);
            }
            return new TimeZone(zoneId2);
        }

        public static Set<String> getAvailableZoneIds() {
            Set<String> set = ZoneId.getAvailableZoneIds();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAvailableZoneIds(...)");
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

