/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.GUID;

public class ItemID
implements Serializable {
    private static final GUID mycomputer = new GUID("20d04fe0-3aea-1069-a2d8-08002b30309d");
    private int type;
    private int size;
    private String shortname;
    private String longname;
    private GUID clsid;
    private byte[] data;

    public ItemID() {
        this.shortname = "";
        this.longname = "";
    }

    /*
     * WARNING - void declaration
     */
    public ItemID(byte[] d) {
        void var1_1;
        this.data = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ItemID(ByteReader br, int maxSize2) throws IOException, ShellLinkException {
        int pos2 = br.getPosition();
        int endPos = pos2 + maxSize2;
        this.type = br.read();
        if (this.type == 47 || this.type == 35) {
            String pos2 = br.readString(maxSize2 - 1);
            ItemID maxSize2 = this;
            if (pos2 != null) {
                if (maxSize2.type == 50 || maxSize2.type == 49) {
                    String string;
                    if (pos2.contains("\\")) {
                        throw new ShellLinkException("wrong name");
                    }
                    maxSize2.longname = pos2;
                    if (ItemID.isLongFilename(pos2)) {
                        CharSequence charSequence = pos2;
                        int n = ((String)(charSequence = ((String)charSequence).replaceAll("\\.$|^\\.", ""))).lastIndexOf(46);
                        String string2 = n == -1 ? charSequence : ((String)charSequence).substring(0, n);
                        charSequence = n == -1 ? "" : ((String)charSequence).substring(n + 1);
                        charSequence = ((String)charSequence).replace(" ", "").replaceAll("[\\.\"\\/\\\\\\[\\]:;=,\\+]", "_");
                        charSequence = ((String)charSequence).substring(0, Math.min(3, ((String)charSequence).length()));
                        string2 = string2.replace(" ", "").replaceAll("[\\.\"\\/\\\\\\[\\]:;=,\\+]", "_");
                        string2 = string2.substring(0, Math.min(6, string2.length()));
                        charSequence = new StringBuilder(string2 + "~1" + (String)(((String)charSequence).isEmpty() ? "" : "." + (String)charSequence));
                        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
                        for (int i = 0; i < ((StringBuilder)charSequence).length(); ++i) {
                            if (charsetEncoder.canEncode(((StringBuilder)charSequence).charAt(i))) continue;
                            ((StringBuilder)charSequence).setCharAt(i, '_');
                        }
                        string = ((StringBuilder)charSequence).toString().toUpperCase();
                    } else {
                        string = maxSize2.shortname = pos2;
                    }
                }
                if (maxSize2.type == 47 || maxSize2.type == 35) {
                    if (Pattern.matches("\\w+:\\\\", pos2)) {
                        ItemID itemID = maxSize2;
                        itemID.shortname = itemID.longname = pos2;
                    } else if (Pattern.matches("\\w+:", pos2)) {
                        ItemID itemID = maxSize2;
                        itemID.shortname = itemID.longname = pos2 + "\\";
                    } else if (Pattern.matches("\\w+", pos2)) {
                        ItemID itemID = maxSize2;
                        itemID.shortname = itemID.longname = pos2 + ":\\";
                    } else {
                        throw new ShellLinkException("wrong name");
                    }
                }
            }
            br.seek(endPos - br.getPosition());
            return;
        }
        if (this.type == 54 || this.type == 53) {
            br.read();
            this.size = (int)br.read4bytes();
            br.read4bytes();
            br.read2bytes();
            this.longname = br.readUnicodeString(endPos - br.getPosition());
            this.shortname = br.readString(endPos - br.getPosition());
            br.seek(endPos - br.getPosition());
            return;
        }
        if (this.type == 50 || this.type == 49) {
            void var2_2;
            void var3_4;
            br.read();
            this.size = (int)br.read4bytes();
            br.read4bytes();
            br.read2bytes();
            this.shortname = br.readString(endPos - br.getPosition());
            if (ItemID.isLongFilename(this.shortname)) {
                int maxSize2;
                this.longname = this.shortname;
                this.shortname = br.readString(endPos - br.getPosition());
                br.seek(pos2 + maxSize2 - br.getPosition());
                return;
            }
            if (endPos - br.getPosition() <= 2) {
                this.longname = this.shortname;
                br.seek(endPos - br.getPosition());
                return;
            }
            if ((br.getPosition() - pos2 & 1) != 0) {
                br.read();
            }
            pos2 = br.getPosition();
            int extSize = (int)br.read2bytes();
            int extensionVersion = (int)br.read2bytes();
            br.read4bytes();
            br.read4bytes();
            br.read4bytes();
            switch (extensionVersion) {
                case 3: {
                    br.seek(4);
                    break;
                }
                case 7: {
                    br.seek(22);
                    break;
                }
                case 8: {
                    br.seek(26);
                    break;
                }
                case 9: {
                    br.seek(30);
                    break;
                }
                default: {
                    throw new ShellLinkException("Unknown extension version");
                }
            }
            this.longname = br.readUnicodeString(pos2 + extSize - br.getPosition());
            br.seek((int)(var3_4 + var2_2 - br.getPosition()));
            return;
        }
        if (this.type == 31) {
            void var1_1;
            br.read();
            this.clsid = new GUID((ByteReader)var1_1);
            if (!this.clsid.equals(mycomputer)) {
                throw new UnsupportedCLSIDException();
            }
        } else {
            throw new ShellLinkException("unsupported ItemID type");
        }
    }

    public final String getName() {
        if (this.longname != null && !this.longname.equals("")) {
            return this.longname;
        }
        return this.shortname;
    }

    public final int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isLongFilename(String filename) {
        void var1_2;
        String string;
        void var2_3;
        block5: {
            block4: {
                if (filename.charAt(0) == '.') break block4;
                String string2 = filename;
                if (string2.charAt(string2.length() - 1) != '.') break block5;
            }
            return true;
        }
        if (!filename.matches("^\\p{ASCII}+$")) {
            return true;
        }
        int dotIdx = filename.lastIndexOf(46);
        String baseName = dotIdx == -1 ? filename : filename.substring(0, dotIdx);
        String ext = dotIdx == -1 ? "" : filename.substring(dotIdx + 1);
        String wrongSymbolsPattern = ".*[\\.\"\\/\\\\\\[\\]:;=, ]+.*";
        return baseName.length() > 8 || ext.length() > 3 || var2_3.matches(wrongSymbolsPattern) || string.matches((String)var1_2);
    }
}

