/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import java.io.IOException;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.CNRLink;
import mslinks.data.LinkInfoFlags;
import mslinks.data.VolumeID;

public final class LinkInfo
implements Serializable {
    private LinkInfoFlags lif;
    private VolumeID vid;
    private String localBasePath;
    private CNRLink cnrlink;
    private String commonPathSuffix;

    public LinkInfo() {
        this.lif = new LinkInfoFlags(0);
    }

    /*
     * WARNING - void declaration
     */
    public LinkInfo(ByteReader data) throws IOException, ShellLinkException {
        void var1_1;
        void var3_3;
        void var2_2;
        int pos = data.getPosition();
        int size = (int)data.read4bytes();
        int hsize = (int)data.read4bytes();
        this.lif = new LinkInfoFlags(data);
        int vidoffset = (int)data.read4bytes();
        int lbpoffset = (int)data.read4bytes();
        int cnrloffset = (int)data.read4bytes();
        int cpsoffset = (int)data.read4bytes();
        int lbpoffset_u = 0;
        int cpfoffset_u = 0;
        if (hsize >= 36) {
            lbpoffset_u = (int)data.read4bytes();
            cpfoffset_u = (int)data.read4bytes();
        }
        if (this.lif.hasVolumeIDAndLocalBasePath()) {
            data.seek(pos + vidoffset - data.getPosition());
            this.vid = new VolumeID(data);
            data.seek(pos + lbpoffset - data.getPosition());
            this.localBasePath = data.readString(pos + size - data.getPosition());
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
            data.seek(pos + cnrloffset - data.getPosition());
            this.cnrlink = new CNRLink(data);
            data.seek(pos + cpsoffset - data.getPosition());
            this.commonPathSuffix = data.readString(pos + size - data.getPosition());
        }
        if (this.lif.hasVolumeIDAndLocalBasePath() && lbpoffset_u != 0) {
            data.seek(pos + lbpoffset_u - data.getPosition());
            this.localBasePath = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix() && cpfoffset_u != 0) {
            data.seek(pos + cpfoffset_u - data.getPosition());
            this.commonPathSuffix = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
        data.seek((int)(var2_2 + var3_3 - var1_1.getPosition()));
    }

    public final String getLocalBasePath() {
        return this.localBasePath;
    }

    public final CNRLink getCommonNetworkRelativeLink() {
        return this.cnrlink;
    }

    public final String getCommonPathSuffix() {
        return this.commonPathSuffix;
    }
}

