/*
 * Decompiled with CFR 0.152.
 */
package application.core.targets.discovery;

import application.core.icons.Icon;
import application.core.targets.DesktopTargetSpec;
import application.core.targets.LinkTarget;
import application.core.targets.discovery.DiscoveredTarget;
import application.core.targets.discovery.TargetDiscovery;
import application.core.targets.discovery.TargetDiscoveryResult;
import application.core.targets.discovery.WindowsTargetDiscoveryKt;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mslinks.ShellLink;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0005\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"Lapplication/core/targets/discovery/WindowsStartMenuTargetDiscovery;", "Lapplication/core/targets/discovery/TargetDiscovery;", "<init>", "()V", "Lapplication/core/targets/discovery/TargetDiscoveryResult;", "discoverTargets", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Ljava/io/File;", "findStartMenuRoots", "()Ljava/util/List;", "", "lnkFileNames", "Ljava/util/List;"})
@SourceDebugExtension(value={"SMAP\nWindowsTargetDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsTargetDiscovery.kt\napplication/core/targets/discovery/WindowsStartMenuTargetDiscovery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1863#2:180\n1864#2:184\n1317#3:181\n1318#3:183\n1#4:182\n*S KotlinDebug\n*F\n+ 1 WindowsTargetDiscovery.kt\napplication/core/targets/discovery/WindowsStartMenuTargetDiscovery\n*L\n124#1:180\n124#1:184\n127#1:181\n127#1:183\n*E\n"})
final class WindowsStartMenuTargetDiscovery
extends TargetDiscovery {
    private final List<String> lnkFileNames = CollectionsKt.listOf((Object)"Tor Browser");

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object discoverTargets(Continuation<? super TargetDiscoveryResult> $completion) {
        void var2_2;
        void var1_1;
        List targets = new ArrayList();
        Set icons = new LinkedHashSet();
        Object object = this.findStartMenuRoots();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (File)object2;
            object2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)object2)), arg_0 -> WindowsStartMenuTargetDiscovery.discoverTargets$lambda$5$lambda$0(this, arg_0));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                byte[] bytes;
                Object e = object2.next();
                File lnkFile = (File)e;
                ShellLink shellLink = new ShellLink(lnkFile);
                String string = shellLink.getName();
                if (string == null) {
                    string = FilesKt.getNameWithoutExtension((File)lnkFile);
                }
                String browserName = string;
                File executable = shared.system.files.FilesKt.getResolvedSymlink((File)new File(shellLink.resolveTarget()));
                WindowsTargetDiscoveryKt.access$getLogger$p().trace(() -> WindowsStartMenuTargetDiscovery.discoverTargets$lambda$5$lambda$4$lambda$1(browserName, executable));
                Icon icon = WindowsTargetDiscoveryKt.access$extractIconFrom(executable) != null ? new Icon(bytes, null, 2, null) : null;
                if (icon != null) {
                    Icon it;
                    it = it;
                    Boxing.boxBoolean((boolean)icons.add(it));
                }
                Icon icon2 = icon;
                String string2 = icon2 != null ? icon2.getHash() : null;
                String string3 = executable.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
                targets.add(new DiscoveredTarget(new LinkTarget(null, browserName, string2, false, true, new DesktopTargetSpec(string3, null, null, null, 14, null), 9, null), null, 2, null));
            }
        }
        return new TargetDiscoveryResult((List<DiscoveredTarget>)var1_1, (Set<Icon>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> findStartMenuRoots() {
        File appDataRoot;
        String appData;
        String string;
        File programDataRoot;
        String programData;
        List list;
        List $this$findStartMenuRoots_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        String startMenuRelativePath = "\\Microsoft\\Windows\\Start Menu\\Programs";
        String string2 = System.getenv("PROGRAMDATA");
        if (string2 == null) {
            string2 = programData = System.getenv("ProgramData");
        }
        if (string2 != null && (programDataRoot = new File(programData + "\\" + startMenuRelativePath)).isDirectory()) {
            $this$findStartMenuRoots_u24lambda_u246.add(programDataRoot);
        }
        if ((string = System.getenv("APPDATA")) == null) {
            string = appData = System.getenv("AppData");
        }
        if (string != null && (appDataRoot = new File(appData + "\\" + startMenuRelativePath)).isDirectory()) {
            void var3_3;
            void var2_2;
            var2_2.add(var3_3);
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean discoverTargets$lambda$5$lambda$0(WindowsStartMenuTargetDiscovery this$0, File it) {
        void var1_1;
        WindowsStartMenuTargetDiscovery windowsStartMenuTargetDiscovery;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"lnk") && windowsStartMenuTargetDiscovery.lnkFileNames.contains(FilesKt.getNameWithoutExtension((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static final Object discoverTargets$lambda$5$lambda$4$lambda$1(String $browserName, File $executable) {
        void var1_1;
        return "Found browser " + $browserName + " at " + (File)var1_1;
    }
}

