/*
 * Decompiled with CFR 0.152.
 */
package application.core.platform;

import application.core.platform.Platform;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import shared.data.MachineType;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;
import shared.system.process.DesktopSystemKt;

public final class DesktopPlatform
implements Platform {
    private final boolean isDebug;
    private final String applicationVersion;
    private final String name;
    private final Lazy machineName$delegate;
    private final MachineType machineType;

    /*
     * WARNING - void declaration
     */
    public DesktopPlatform(boolean isDebug, String applicationVersion) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)applicationVersion, (String)"applicationVersion");
        this.isDebug = var1_1;
        this.applicationVersion = var2_2;
        this.name = DesktopOSKt.getCurrentDesktopOS().name() + " - Java " + System.getProperty("java.version");
        this.machineName$delegate = LazyKt.lazy(() -> DesktopPlatform.machineName_delegate$lambda$0(this));
        this.machineType = MachineType.DESKTOP;
    }

    @Override
    public final boolean isDebug() {
        return this.isDebug;
    }

    @Override
    public final String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getMachineName() {
        Lazy lazy = this.machineName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public final MachineType getMachineType() {
        return this.machineType;
    }

    private static String unixHostname() {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "hostname";
        return (String)DesktopSystemKt.systemCommandLineOutputOf((String[])stringArray2, DesktopPlatform::unixHostname$lambda$1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyToClipboard(String text) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection((String)var1_1), null);
    }

    @Override
    public final void shareLink(String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        throw new IllegalStateException("Unsupported by desktop platform".toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void browseFileDirectory(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
            Desktop.getDesktop().browseFileDirectory(path.toFile());
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1: {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "xdg-open";
                stringArray2[1] = path.toString();
                Runtime.getRuntime().exec(stringArray2);
                return;
            }
            case 2: {
                String[] stringArray = new String[3];
                String[] stringArray3 = stringArray;
                stringArray[0] = "open";
                stringArray3[1] = "-R";
                stringArray3[2] = path.toString();
                Runtime.getRuntime().exec(stringArray3);
                return;
            }
            case 3: {
                void var1_1;
                String[] stringArray = new String[2];
                String[] stringArray4 = stringArray;
                stringArray[0] = "explorer.exe";
                stringArray4[1] = var1_1.toString();
                Runtime.getRuntime().exec(stringArray4);
                return;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final String machineName_delegate$lambda$0(DesktopPlatform this$0) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1: {
                string = DesktopPlatform.unixHostname();
                if (string != null) break;
                return "Linux";
            }
            case 2: {
                string = DesktopPlatform.unixHostname();
                if (string != null) break;
                return "Mac";
            }
            case 3: {
                string = System.getenv("COMPUTERNAME");
                if (string != null) break;
                return "Windows";
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String unixHostname$lambda$1(String output) {
        String string;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string));
        if (string2 != null) {
            return ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return null;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

