/*
 * Decompiled with CFR 0.152.
 */
package application.core.links;

import application.core.database.DbDateTimeMapperKt;
import application.core.database.sqldelight.generated.queries.LinksQueries;
import application.core.links.Link;
import application.core.links.LinkEvent;
import application.core.links.LinkEventPayload;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\n\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0011\u001a\u00020\u0010*\u00020\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lapplication/core/links/DbLinkEventsMapper;", "Lkotlin/Function4;", "", "Lapplication/core/links/LinkEvent;", "<init>", "()V", "id", "recordedAt", "payloadType", "payloadJson", "invoke", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lapplication/core/links/LinkEvent;", "Lapplication/core/database/sqldelight/generated/queries/LinksQueries;", "Lapplication/core/links/Link;", "link", "event", "", "insertEvent", "(Lapplication/core/database/sqldelight/generated/queries/LinksQueries;Lapplication/core/links/Link;Lapplication/core/links/LinkEvent;)V", "", "RECEIVED_FROM_REMOTE_PAYLOAD_TYPES", "Ljava/util/List;", "getRECEIVED_FROM_REMOTE_PAYLOAD_TYPES$app_core", "()Ljava/util/List;"})
@SourceDebugExtension(value={"SMAP\nLinksRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinksRepository.kt\napplication/core/links/DbLinkEventsMapper\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,293:1\n147#2:294\n147#2:295\n147#2:296\n147#2:297\n147#2:298\n113#3:299\n113#3:300\n113#3:301\n113#3:302\n113#3:303\n*S KotlinDebug\n*F\n+ 1 LinksRepository.kt\napplication/core/links/DbLinkEventsMapper\n*L\n192#1:294\n195#1:295\n204#1:296\n213#1:297\n216#1:298\n252#1:299\n253#1:300\n257#1:301\n258#1:302\n261#1:303\n*E\n"})
public final class DbLinkEventsMapper
implements Function4<String, String, String, String, LinkEvent> {
    public static final DbLinkEventsMapper INSTANCE = new DbLinkEventsMapper();
    private static final List<String> RECEIVED_FROM_REMOTE_PAYLOAD_TYPES;

    private DbLinkEventsMapper() {
    }

    public static List<String> getRECEIVED_FROM_REMOTE_PAYLOAD_TYPES$app_core() {
        return RECEIVED_FROM_REMOTE_PAYLOAD_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    public static LinkEvent invoke(String id, String recordedAt, String payloadType, String payloadJson) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)recordedAt, (String)"recordedAt");
        Intrinsics.checkNotNullParameter((Object)payloadType, (String)"payloadType");
        Intrinsics.checkNotNullParameter((Object)payloadJson, (String)"payloadJson");
        String string = id;
        LocalDateTime localDateTime = DbDateTimeMapperKt.toApplicationLocalDateTime$default$56e73b37((String)var1_1, null, 1);
        return new LinkEvent(string, localDateTime, switch (var2_2) {
            case "COPIED_TO_CLIPBOARD" -> LinkEventPayload.CopiedToClipboard.INSTANCE;
            case "DISPLAYED_QR_CODE" -> LinkEventPayload.DisplayedQrCode.INSTANCE;
            case "OPENED_IN_LOCAL_TARGET" -> {
                String this_$iv = (Json)Json.Default;
                this_$iv.getSerializersModule();
                yield (LinkEventPayload)this_$iv.decodeFromString((DeserializationStrategy)LinkEventPayload.OpenedInLocalTarget.Companion.serializer(), payloadJson);
            }
            case "OPENED_IN_LOCAL_TARGET_DIRECTLY" -> {
                String this_$iv = (Json)Json.Default;
                this_$iv.getSerializersModule();
                yield (LinkEventPayload)this_$iv.decodeFromString((DeserializationStrategy)LinkEventPayload.OpenedInLocalTargetDirectly.Companion.serializer(), payloadJson);
            }
            case "OPENED_LOCALLY" -> LinkEventPayload.OpenedLocally.INSTANCE;
            case "RECEIVED_FROM_REMOTE_INSTALLATION" -> LinkEventPayload.ReceivedFromRemoteInstallation.INSTANCE;
            case "RECEIVED_FROM_REMOTE_INSTALLATION_WITH_TARGET" -> {
                String this_$iv = (Json)Json.Default;
                this_$iv.getSerializersModule();
                yield (LinkEventPayload)this_$iv.decodeFromString((DeserializationStrategy)LinkEventPayload.ReceivedFromRemoteInstallationWithTarget.Companion.serializer(), payloadJson);
            }
            case "ADDED_TO_BOOKMARKS" -> LinkEventPayload.AddedToBookmarks.INSTANCE;
            case "REMOVED_FROM_BOOKMARKS" -> LinkEventPayload.RemovedFromBookmarks.INSTANCE;
            case "SENT_TO_REMOTE_INSTALLATION" -> {
                String this_$iv = (Json)Json.Default;
                this_$iv.getSerializersModule();
                yield (LinkEventPayload)this_$iv.decodeFromString((DeserializationStrategy)LinkEventPayload.SentToRemoteInstallation.Companion.serializer(), payloadJson);
            }
            case "SENT_TO_REMOTE_TARGET" -> {
                void var3_3;
                String var0;
                String this_$iv = (Json)Json.Default;
                var0.getSerializersModule();
                yield (LinkEventPayload)this_$iv.decodeFromString((DeserializationStrategy)LinkEventPayload.SentToRemoteTarget.Companion.serializer(), (String)var3_3);
            }
            case "SHARED_WITH_SYSTEM" -> LinkEventPayload.SharedWithSystem.INSTANCE;
            default -> LinkEventPayload.Unknown.INSTANCE;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void insertEvent(LinksQueries $this$insertEvent, Link link, LinkEvent event) {
        LinksQueries linksQueries;
        void value$iv;
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insertEvent), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string4 = event.getId();
        String string5 = DbDateTimeMapperKt.toSqliteText(event.getRecordedAt());
        string3 = ((Link)((Object)string3)).getId();
        Object object = event.getPayload();
        if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.CopiedToClipboard.INSTANCE)) {
            string2 = "COPIED_TO_CLIPBOARD";
        } else if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.DisplayedQrCode.INSTANCE)) {
            string2 = "DISPLAYED_QR_CODE";
        } else if (object instanceof LinkEventPayload.OpenedInLocalTarget) {
            string2 = "OPENED_IN_LOCAL_TARGET";
        } else if (object instanceof LinkEventPayload.OpenedInLocalTargetDirectly) {
            string2 = "OPENED_IN_LOCAL_TARGET_DIRECTLY";
        } else if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.OpenedLocally.INSTANCE)) {
            string2 = "OPENED_LOCALLY";
        } else if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.AddedToBookmarks.INSTANCE)) {
            string2 = "ADDED_TO_BOOKMARKS";
        } else if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.RemovedFromBookmarks.INSTANCE)) {
            string2 = "REMOVED_FROM_BOOKMARKS";
        } else if (object instanceof LinkEventPayload.SentToRemoteInstallation) {
            string2 = "SENT_TO_REMOTE_INSTALLATION";
        } else if (object instanceof LinkEventPayload.SentToRemoteTarget) {
            string2 = "SENT_TO_REMOTE_TARGET";
        } else if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.SharedWithSystem.INSTANCE)) {
            string2 = "SHARED_WITH_SYSTEM";
        } else if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.ReceivedFromRemoteInstallation.INSTANCE)) {
            string2 = "RECEIVED_FROM_REMOTE_INSTALLATION";
        } else if (object instanceof LinkEventPayload.ReceivedFromRemoteInstallationWithTarget) {
            string2 = "RECEIVED_FROM_REMOTE_INSTALLATION_WITH_TARGET";
        } else {
            if (Intrinsics.areEqual((Object)object, (Object)LinkEventPayload.Unknown.INSTANCE)) {
                throw new IllegalStateException("Inserting a link event with unknown payload is not allowed.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        String string6 = string2;
        LinkEventPayload payload = event.getPayload();
        if (Intrinsics.areEqual((Object)payload, (Object)LinkEventPayload.CopiedToClipboard.INSTANCE)) {
            string = "{}";
        } else if (Intrinsics.areEqual((Object)payload, (Object)LinkEventPayload.DisplayedQrCode.INSTANCE)) {
            string = "{}";
        } else if (payload instanceof LinkEventPayload.OpenedInLocalTarget) {
            object = (StringFormat)Json.Default;
            void v2 = $this$encodeToString$iv;
            v2.getSerializersModule();
            string = v2.encodeToString((SerializationStrategy)LinkEventPayload.OpenedInLocalTarget.Companion.serializer(), (Object)value$iv);
        } else if (value$iv instanceof LinkEventPayload.OpenedInLocalTargetDirectly) {
            StringFormat stringFormat = $this$encodeToString$iv = (StringFormat)Json.Default;
            stringFormat.getSerializersModule();
            string = stringFormat.encodeToString((SerializationStrategy)LinkEventPayload.OpenedInLocalTargetDirectly.Companion.serializer(), (Object)value$iv);
        } else if (Intrinsics.areEqual((Object)value$iv, (Object)LinkEventPayload.OpenedLocally.INSTANCE)) {
            string = "{}";
        } else if (Intrinsics.areEqual((Object)value$iv, (Object)LinkEventPayload.AddedToBookmarks.INSTANCE)) {
            string = "{}";
        } else if (Intrinsics.areEqual((Object)value$iv, (Object)LinkEventPayload.RemovedFromBookmarks.INSTANCE)) {
            string = "{}";
        } else if (value$iv instanceof LinkEventPayload.SentToRemoteInstallation) {
            StringFormat stringFormat = $this$encodeToString$iv = (StringFormat)Json.Default;
            stringFormat.getSerializersModule();
            string = stringFormat.encodeToString((SerializationStrategy)LinkEventPayload.SentToRemoteInstallation.Companion.serializer(), (Object)value$iv);
        } else if (value$iv instanceof LinkEventPayload.SentToRemoteTarget) {
            StringFormat stringFormat = $this$encodeToString$iv = (StringFormat)Json.Default;
            stringFormat.getSerializersModule();
            string = stringFormat.encodeToString((SerializationStrategy)LinkEventPayload.SentToRemoteTarget.Companion.serializer(), (Object)value$iv);
        } else if (Intrinsics.areEqual((Object)value$iv, (Object)LinkEventPayload.SharedWithSystem.INSTANCE)) {
            string = "{}";
        } else if (Intrinsics.areEqual((Object)value$iv, (Object)LinkEventPayload.ReceivedFromRemoteInstallation.INSTANCE)) {
            string = "{}";
        } else if (value$iv instanceof LinkEventPayload.ReceivedFromRemoteInstallationWithTarget) {
            StringFormat stringFormat = $this$encodeToString$iv = (StringFormat)Json.Default;
            stringFormat.getSerializersModule();
            string = stringFormat.encodeToString((SerializationStrategy)LinkEventPayload.ReceivedFromRemoteInstallationWithTarget.Companion.serializer(), (Object)var2_2);
        } else {
            if (Intrinsics.areEqual((Object)var2_2, (Object)LinkEventPayload.Unknown.INSTANCE)) {
                throw new IllegalStateException("Inserting a link event with unknown payload is not allowed.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        object = string;
        linksQueries.insertEvent(string4, string3, string5, string6, (String)object);
    }

    static {
        Object[] objectArray = new String[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "RECEIVED_FROM_REMOTE_INSTALLATION";
        objectArray2[1] = "RECEIVED_FROM_REMOTE_INSTALLATION_WITH_TARGET";
        RECEIVED_FROM_REMOTE_PAYLOAD_TYPES = CollectionsKt.listOf((Object[])objectArray2);
    }
}

