/*
 * Decompiled with CFR 0.152.
 */
package application.core.database.sqldelight;

import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import application.core.database.sqldelight.ApplicationDatabaseFactoryKt;
import application.core.database.sqldelight.generated.ApplicationDatabase;
import application.core.icons.DbIconMapper;
import application.core.rules.DbRuleMapper;
import application.core.targets.DbTargetMapper;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import shared.sqldelight.SqlDelightMigrationsKt;

@SourceDebugExtension(value={"SMAP\nApplicationDatabaseFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationDatabaseFactory.kt\napplication/core/database/sqldelight/ApplicationDatabaseFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1863#2,2:64\n*S KotlinDebug\n*F\n+ 1 ApplicationDatabaseFactory.kt\napplication/core/database/sqldelight/ApplicationDatabaseFactory\n*L\n57#1:64,2\n*E\n"})
public final class ApplicationDatabaseFactory {
    /*
     * WARNING - void declaration
     */
    public final ApplicationDatabase createDatabase(SqlDriver driver) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        SqlDelightMigrationsKt.migrateTo((SqlDriver)driver, ApplicationDatabase.Companion.getSchema(), (AfterVersion[])new AfterVersion[0]);
        ApplicationDatabase db = ApplicationDatabase.Companion.invoke(driver);
        try {
            ApplicationDatabase applicationDatabase = db;
            applicationDatabase.getLinksQueries().selectAllWithLastEvent().executeAsList();
            applicationDatabase.getTargetsQueries().selectAll(DbTargetMapper.INSTANCE).executeAsList();
            applicationDatabase.getRulesQueries().selectAll(DbRuleMapper.INSTANCE).executeAsList();
            applicationDatabase.getIconsQueries().selectAll(DbIconMapper.INSTANCE).executeAsList();
            applicationDatabase.getSentLinksQueries().selectAll().executeAsList();
        }
        catch (Exception ex) {
            void var1_1;
            void var3_4;
            ApplicationDatabaseFactoryKt.access$getLogger$p().warn((Throwable)var3_4, ApplicationDatabaseFactory::createDatabase$lambda$0);
            SqlDriver sqlDriver = driver;
            Object object = (List)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)sqlDriver, null, (String)"PRAGMA table_list;", ApplicationDatabaseFactory::dropTables$lambda$2, (int)0, null, (int)16, null).getValue();
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (String)object2;
                SqlDriver.DefaultImpls.execute$default((SqlDriver)sqlDriver, null, (String)("DROP TABLE \"" + object2 + "\""), (int)0, null, (int)8, null);
                ApplicationDatabaseFactoryKt.access$getLogger$p().warn(() -> ApplicationDatabaseFactory.dropTables$lambda$4$lambda$3(object2));
            }
            SqlDelightMigrationsKt.migrateTo((SqlDriver)var1_1, ApplicationDatabase.Companion.getSchema(), (AfterVersion[])new AfterVersion[0]);
        }
        return var2_2;
    }

    private static final Object createDatabase$lambda$0() {
        return "Database checks failed";
    }

    /*
     * WARNING - void declaration
     */
    private static final QueryResult dropTables$lambda$2(SqlCursor cursor) {
        List list;
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        List $this$dropTables_u24lambda_u242_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        while (((Boolean)cursor.next$5017d2a2().getValue()).booleanValue()) {
            void var3_3;
            String tableName = cursor.getString(1);
            if (tableName == null || StringsKt.startsWith$default((String)tableName, (String)"sqlite", (boolean)false, (int)2, null)) continue;
            $this$dropTables_u24lambda_u242_u24lambda_u241.add(var3_3);
        }
        return (QueryResult)QueryResult.Value.box-impl((Object)QueryResult.Value.constructor-impl((Object)CollectionsKt.build((List)list)));
    }

    private static final Object dropTables$lambda$4$lambda$3(String $tableName) {
        return "Dropped table '" + $tableName + "'";
    }
}

