/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.ObjectReader;
import io.sentry.SentryLevel;
import io.sentry.protocol.MetricSummary;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class MapObjectReader
implements ObjectReader {
    private final Deque<Map.Entry<String, Object>> stack = new ArrayDeque<Map.Entry<String, Object>>();

    /*
     * WARNING - void declaration
     */
    public MapObjectReader(Map<String, Object> root) {
        void var1_1;
        this.stack.addLast(new AbstractMap.SimpleEntry<Object, void>(null, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void nextUnknown(ILogger logger, Map<String, Object> unknown, String name) {
        try {
            Map<String, Object> map = unknown;
            unknown = this;
            map.put(name, ((MapObjectReader)unknown).nextValueOrNull());
            return;
        }
        catch (Exception exception) {
            void var3_4;
            void var2_3;
            void var1_1;
            var1_1.log(SentryLevel.ERROR, (Throwable)var2_3, "Error deserializing unknown key: %s", var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> List<T> nextListOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        try {
            MapObjectReader mapObjectReader = this;
            Object object = mapObjectReader.stack.removeLast();
            if (object == null) {
                throw new IOException("No more entries");
            }
            if ((object = object.getValue()) instanceof List) {
                mapObjectReader.stack.addLast(new AbstractMap.SimpleEntry<Object, JsonToken>(null, JsonToken.END_ARRAY));
                for (int i = ((List)object).size() - 1; i >= 0; --i) {
                    Object e = ((List)object).get(i);
                    mapObjectReader.stack.addLast(new AbstractMap.SimpleEntry(null, e));
                }
            } else {
                throw new IOException("Current token is not an object");
            }
            ArrayList<T> list = new ArrayList<T>();
            if (this.hasNext()) {
                do {
                    try {
                        list.add(deserializer.deserialize(this, logger));
                    }
                    catch (Exception e) {
                        logger.log(SentryLevel.WARNING, "Failed to deserialize object in list.", e);
                    }
                } while (this.peek() == JsonToken.BEGIN_OBJECT);
            }
            mapObjectReader = this;
            if (mapObjectReader.stack.size() > 1) {
                mapObjectReader.stack.removeLast();
            }
            return list;
        }
        catch (Exception e) {
            void var3_6;
            throw new IOException((Throwable)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Map<String, T> nextMapOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        try {
            this.beginObject();
            HashMap<String, T> map = new HashMap<String, T>();
            if (this.hasNext()) {
                do {
                    try {
                        String key = this.nextName();
                        map.put(key, deserializer.deserialize(this, logger));
                    }
                    catch (Exception e) {
                        logger.log(SentryLevel.WARNING, "Failed to deserialize object in map.", e);
                    }
                } while (this.peek() == JsonToken.BEGIN_OBJECT || this.peek() == JsonToken.NAME);
            }
            this.endObject();
            return map;
        }
        catch (Exception e) {
            void var3_4;
            throw new IOException((Throwable)var3_4);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    @Override
    public final Map nextMapOfListOrNull$6cb976c4(ILogger logger, MetricSummary.Deserializer deserializer) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        HashMap<String, List<MetricSummary>> result = new HashMap<String, List<MetricSummary>>();
        try {
            void var3_3;
            this.beginObject();
            if (this.hasNext()) {
                do {
                    String key = this.nextName();
                    List<MetricSummary> list = this.nextListOrNull(logger, deserializer);
                    if (list == null) continue;
                    result.put(key, list);
                } while (this.peek() == JsonToken.BEGIN_OBJECT || this.peek() == JsonToken.NAME);
            }
            this.endObject();
            return var3_3;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T nextOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws Exception {
        void var2_2;
        void var1_1;
        return this.nextValueOrNull((ILogger)var1_1, (JsonDeserializer<T>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Date nextDateOrNull(ILogger logger) throws IOException {
        void var1_1;
        Object object = this;
        object = (String)((MapObjectReader)object).nextValueOrNull();
        return ObjectReader.dateOrNull((String)object, (ILogger)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TimeZone nextTimeZoneOrNull(ILogger logger) throws IOException {
        logger = this;
        String timeZoneId = (String)((MapObjectReader)logger).nextValueOrNull();
        if (timeZoneId != null) {
            void var1_1;
            return TimeZone.getTimeZone((String)var1_1);
        }
        return null;
    }

    @Override
    public final Object nextObjectOrNull() throws IOException {
        return this.nextValueOrNull();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonToken peek() throws IOException {
        if (this.stack.isEmpty()) {
            return JsonToken.END_DOCUMENT;
        }
        Map.Entry<String, Object> currentEntry = this.stack.peekLast();
        if (currentEntry == null) {
            return JsonToken.END_DOCUMENT;
        }
        if (currentEntry.getKey() != null) {
            return JsonToken.NAME;
        }
        Object value = currentEntry.getValue();
        if (value instanceof Map) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (value instanceof List) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (value instanceof String) {
            return JsonToken.STRING;
        }
        if (value instanceof Number) {
            return JsonToken.NUMBER;
        }
        if (value instanceof Boolean) {
            return JsonToken.BOOLEAN;
        }
        if (value instanceof JsonToken) {
            void var1_1;
            return (JsonToken)var1_1;
        }
        return JsonToken.END_DOCUMENT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String nextName() throws IOException {
        Map.Entry<String, Object> currentEntry = this.stack.peekLast();
        if (currentEntry != null && currentEntry.getKey() != null) {
            void var1_1;
            return (String)var1_1.getKey();
        }
        throw new IOException("Expected a name but was " + (Object)((Object)this.peek()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void beginObject() throws IOException {
        Map.Entry<String, Object> currentEntry = this.stack.removeLast();
        if (currentEntry == null) {
            throw new IOException("No more entries");
        }
        Object value = currentEntry.getValue();
        if (value instanceof Map) {
            Iterator iterator;
            this.stack.addLast(new AbstractMap.SimpleEntry<Object, JsonToken>(null, JsonToken.END_OBJECT));
            for (Map.Entry entry : ((Map)((Object)iterator)).entrySet()) {
                void var2_2;
                this.stack.addLast((Map.Entry<String, Object>)var2_2);
            }
            return;
        }
        throw new IOException("Current token is not an object");
    }

    @Override
    public final void endObject() throws IOException {
        if (this.stack.size() > 1) {
            this.stack.removeLast();
        }
    }

    private boolean hasNext() throws IOException {
        return !this.stack.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int nextInt() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).intValue();
        }
        throw new IOException("Expected int");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Integer nextIntegerOrNull() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).intValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long nextLong() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).longValue();
        }
        throw new IOException("Expected long");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long nextLongOrNull() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).longValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String nextString() throws IOException {
        String value = (String)this.nextValueOrNull();
        if (value != null) {
            void var1_1;
            return var1_1;
        }
        throw new IOException("Expected string");
    }

    @Override
    public final String nextStringOrNull() throws IOException {
        return (String)this.nextValueOrNull();
    }

    @Override
    public final Boolean nextBooleanOrNull() throws IOException {
        return (Boolean)this.nextValueOrNull();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double nextDouble() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).doubleValue();
        }
        throw new IOException("Expected double");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Double nextDoubleOrNull() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).doubleValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Float nextFloatOrNull() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return Float.valueOf(((Number)var1_1).floatValue());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float nextFloat() throws IOException {
        Object value = this.nextValueOrNull();
        if (value instanceof Number) {
            void var1_1;
            return ((Number)var1_1).floatValue();
        }
        throw new IOException("Expected float");
    }

    private void nextNull() throws IOException {
        Object t = this.nextValueOrNull();
        if (t != null) {
            throw new IOException("Expected null but was " + (Object)((Object)this.peek()));
        }
    }

    @Override
    public final void setLenient(boolean lenient) {
    }

    @Override
    public final void skipValue() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    private <T> T nextValueOrNull() throws IOException {
        try {
            return this.nextValueOrNull(null, null);
        }
        catch (Exception e) {
            void var1_1;
            throw new IOException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T nextValueOrNull(ILogger logger, JsonDeserializer<T> deserializer) throws Exception {
        void var3_3;
        Map.Entry<String, Object> currentEntry = this.stack.peekLast();
        if (currentEntry == null) {
            return null;
        }
        Object value = currentEntry.getValue();
        if (deserializer != null && logger != null) {
            void var1_1;
            void var2_2;
            return var2_2.deserialize(this, (ILogger)var1_1);
        }
        this.stack.removeLast();
        return var3_3;
    }

    @Override
    public final void close() throws IOException {
        this.stack.clear();
    }
}

