/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.DataCategory;
import io.sentry.Hint;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.HintUtils;
import io.sentry.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RateLimiter {
    private final ICurrentDateProvider currentDateProvider;
    private final SentryOptions options;
    private final Map<DataCategory, Date> sentryRetryAfterLimit = new ConcurrentHashMap<DataCategory, Date>();

    /*
     * WARNING - void declaration
     */
    private RateLimiter(ICurrentDateProvider currentDateProvider, SentryOptions options) {
        void var2_2;
        void var1_1;
        this.currentDateProvider = var1_1;
        this.options = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public RateLimiter(SentryOptions options) {
        this(CurrentDateProvider.getInstance(), (SentryOptions)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final SentryEnvelope filter(SentryEnvelope envelope, Hint hint) {
        void var1_1;
        Object object;
        ArrayList<SentryEnvelopeItem> dropItems = null;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            DataCategory dataCategory;
            Object object2 = item.getHeader().getType().getItemType();
            object = this;
            switch (object2) {
                case "event": {
                    dataCategory = DataCategory.Error;
                    break;
                }
                case "session": {
                    dataCategory = DataCategory.Session;
                    break;
                }
                case "attachment": {
                    dataCategory = DataCategory.Attachment;
                    break;
                }
                case "profile": {
                    dataCategory = DataCategory.Profile;
                    break;
                }
                case "statsd": {
                    dataCategory = DataCategory.MetricBucket;
                    break;
                }
                case "transaction": {
                    dataCategory = DataCategory.Transaction;
                    break;
                }
                case "check_in": {
                    dataCategory = DataCategory.Monitor;
                    break;
                }
                default: {
                    dataCategory = DataCategory.Unknown;
                }
            }
            object2 = dataCategory;
            RateLimiter rateLimiter = object;
            object = object2;
            object2 = rateLimiter;
            Object object3 = new Date(((RateLimiter)object2).currentDateProvider.getCurrentTimeMillis());
            Date date = ((RateLimiter)object2).sentryRetryAfterLimit.get((Object)DataCategory.All);
            boolean bl = date != null && !((Date)object3).after(date) ? true : (!DataCategory.Unknown.equals(object) && (object = ((RateLimiter)object2).sentryRetryAfterLimit.get(object)) != null ? !((Date)object3).after((Date)object) : false);
            if (!bl) continue;
            if (dropItems == null) {
                dropItems = new ArrayList<SentryEnvelopeItem>();
            }
            dropItems.add(item);
            this.options.getClientReportRecorder().recordLostEnvelopeItem(DiscardReason.RATELIMIT_BACKOFF, item);
        }
        if (dropItems != null) {
            this.options.getLogger().log(SentryLevel.INFO, "%d items will be dropped due rate limiting.", dropItems.size());
            ArrayList<SentryEnvelopeItem> toSend = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                if (dropItems.contains(item)) continue;
                toSend.add(item);
            }
            if (toSend.isEmpty()) {
                void var2_2;
                this.options.getLogger().log(SentryLevel.INFO, "Envelope discarded due all items rate limited.", new Object[0]);
                boolean bl = false;
                object = var2_2;
                HintUtils.runIfHasType((Hint)object, SubmissionResult.class, result -> {});
                HintUtils.runIfHasType((Hint)object, Retryable.class, arg_0 -> RateLimiter.lambda$markHintWhenSendingFailed$1(false, arg_0));
                return null;
            }
            return new SentryEnvelope(envelope.getHeader(), toSend);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAnyRateLimitActive() {
        Date currentDate = new Date(this.currentDateProvider.getCurrentTimeMillis());
        for (DataCategory dataCategory : this.sentryRetryAfterLimit.keySet()) {
            void var3_3;
            Date dateCategory = this.sentryRetryAfterLimit.get((Object)dataCategory);
            if (dateCategory == null || currentDate.after((Date)var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRetryAfterLimits(String sentryRateLimitHeader, String retryAfterHeader2, int errorCode) {
        void var3_4;
        String[] stringArray;
        if (sentryRateLimitHeader != null) {
            for (String retryAfterHeader2 : sentryRateLimitHeader.split(",", -1)) {
                String limitNamespaces;
                String[] rateLimit = (retryAfterHeader2 = retryAfterHeader2.replace(" ", "")).split(":", -1);
                String string = limitNamespaces = rateLimit.length > 4 ? rateLimit[4] : null;
                if (rateLimit.length <= 0) continue;
                String string2 = rateLimit[0];
                long retryAfterMillis = RateLimiter.parseRetryAfterOrDefault(string2);
                if (rateLimit.length <= 1) continue;
                String allCategories = rateLimit[1];
                Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
                if (allCategories != null && !allCategories.isEmpty()) {
                    String[] stringArray2 = stringArray.split(";", -1);
                    stringArray = stringArray2;
                    stringArray = stringArray2;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String[] namespaces;
                        String catItem = stringArray[i];
                        DataCategory dataCategory = DataCategory.Unknown;
                        try {
                            String catItemCapitalized = StringUtils.camelCase(catItem);
                            if (catItemCapitalized != null) {
                                dataCategory = DataCategory.valueOf(catItemCapitalized);
                            } else {
                                this.options.getLogger().log(SentryLevel.ERROR, "Couldn't capitalize: %s", catItem);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.options.getLogger().log(SentryLevel.INFO, e, "Unknown category: %s", catItem);
                        }
                        if (DataCategory.Unknown.equals((Object)dataCategory)) continue;
                        if (DataCategory.MetricBucket.equals((Object)dataCategory) && limitNamespaces != null && !limitNamespaces.equals("") && (namespaces = limitNamespaces.split(";", -1)).length > 0) {
                            boolean bl;
                            block11: {
                                String string3 = "custom";
                                String[] stringArray3 = namespaces;
                                for (String string4 : namespaces) {
                                    if (!string3.equals(string4)) continue;
                                    bl = true;
                                    break block11;
                                }
                                bl = false;
                            }
                            if (!bl) continue;
                        }
                        this.applyRetryAfterOnlyIfLonger(dataCategory, date);
                    }
                    continue;
                }
                this.applyRetryAfterOnlyIfLonger(DataCategory.All, date);
            }
            return;
        }
        if (var3_4 == 429) {
            void var1_1;
            long retryAfterMillis = RateLimiter.parseRetryAfterOrDefault((String)stringArray);
            Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
            this.applyRetryAfterOnlyIfLonger(DataCategory.All, (Date)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyRetryAfterOnlyIfLonger(DataCategory dataCategory, Date date) {
        void var3_3;
        Date oldDate = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (oldDate == null || date.after((Date)var3_3)) {
            void var2_2;
            void var1_1;
            this.sentryRetryAfterLimit.put((DataCategory)var1_1, (Date)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static long parseRetryAfterOrDefault(String retryAfterHeader) {
        void var1_1;
        long retryAfterMillis = 60000L;
        if (retryAfterHeader != null) {
            try {
                String string;
                retryAfterMillis = (long)(Double.parseDouble(string) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return (long)var1_1;
    }

    private static /* synthetic */ void lambda$markHintWhenSendingFailed$1(boolean retry, Retryable retryable) {
    }
}

