/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.RequestDetails;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.transport.AuthenticatorWrapper;
import io.sentry.transport.ProxyAuthenticator;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.TransportResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

final class HttpConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Proxy proxy;
    private final RequestDetails requestDetails;
    private final SentryOptions options;
    private final RateLimiter rateLimiter;

    /*
     * WARNING - void declaration
     */
    public HttpConnection(SentryOptions options, RequestDetails requestDetails, RateLimiter rateLimiter) {
        this((SentryOptions)var1_1, (RequestDetails)var2_2, AuthenticatorWrapper.getInstance(), (RateLimiter)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HttpConnection(SentryOptions options, RequestDetails requestDetails, AuthenticatorWrapper authenticatorWrapper, RateLimiter rateLimiter) {
        this.requestDetails = requestDetails;
        this.options = options;
        this.rateLimiter = rateLimiter;
        this.proxy = this.resolveProxy(options.getProxy());
        if (this.proxy != null && options.getProxy() != null) {
            String proxyUser = options.getProxy().getUser();
            String proxyPassword = options.getProxy().getPass();
            if (proxyUser != null && proxyPassword != null) {
                void var1_1;
                void var2_2;
                AuthenticatorWrapper.setDefault$203cc410(new ProxyAuthenticator((String)var2_2, (String)var1_1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Proxy resolveProxy(SentryOptions.Proxy optionsProxy) {
        void var2_2;
        Proxy proxy = null;
        if (optionsProxy != null) {
            String port = optionsProxy.getPort();
            String host = optionsProxy.getHost();
            if (port != null && host != null) {
                try {
                    void var3_3;
                    Proxy.Type type = optionsProxy.getType() != null ? optionsProxy.getType() : Proxy.Type.HTTP;
                    InetSocketAddress proxyAddr = new InetSocketAddress(host, Integer.parseInt(port));
                    proxy = new Proxy(type, (SocketAddress)var3_3);
                }
                catch (NumberFormatException e) {
                    void var1_1;
                    this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to parse Sentry Proxy port: " + var1_1.getPort() + ". Proxy is ignored", new Object[0]);
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final TransportResult send(SentryEnvelope envelope) throws IOException {
        void var1_1;
        TransportResult result2;
        HttpConnection httpConnection = this;
        Object object = httpConnection;
        object = (HttpURLConnection)(httpConnection.proxy == null ? ((HttpConnection)object).requestDetails.getUrl().openConnection() : ((HttpConnection)object).requestDetails.getUrl().openConnection(((HttpConnection)object).proxy));
        for (Map.Entry<String, String> entry : httpConnection.requestDetails.getHeaders().entrySet()) {
            ((URLConnection)object).setRequestProperty(entry.getKey(), entry.getValue());
        }
        ((HttpURLConnection)object).setRequestMethod("POST");
        ((URLConnection)object).setDoOutput(true);
        ((URLConnection)object).setRequestProperty("Content-Encoding", "gzip");
        ((URLConnection)object).setRequestProperty("Content-Type", "application/x-sentry-envelope");
        ((URLConnection)object).setRequestProperty("Accept", "application/json");
        ((URLConnection)object).setRequestProperty("Connection", "close");
        ((URLConnection)object).setConnectTimeout(httpConnection.options.getConnectionTimeoutMillis());
        ((URLConnection)object).setReadTimeout(httpConnection.options.getReadTimeoutMillis());
        SSLSocketFactory sSLSocketFactory = httpConnection.options.getSslSocketFactory();
        if (object instanceof HttpsURLConnection && sSLSocketFactory != null) {
            ((HttpsURLConnection)object).setSSLSocketFactory(sSLSocketFactory);
        }
        ((URLConnection)object).connect();
        Object connection = object;
        try {
            try (OutputStream outputStream = ((URLConnection)connection).getOutputStream();
                 GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                this.options.getSerializer().serialize(envelope, gzip);
            }
            result2 = this.readAndLog((HttpURLConnection)connection);
        }
        catch (Throwable e) {
            try {
                void var3_7;
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_7, "An exception occurred while submitting the envelope to the Sentry server.", new Object[0]);
                result2 = this.readAndLog((HttpURLConnection)connection);
            }
            catch (Throwable result2) {
                this.readAndLog((HttpURLConnection)((Object)httpConnection));
                throw result2;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TransportResult readAndLog(HttpURLConnection connection) {
        TransportResult.SuccessTransportResult successTransportResult;
        block6: {
            int responseCode;
            int n = responseCode = connection.getResponseCode();
            Object object = connection;
            HttpConnection httpConnection = this;
            String string = ((URLConnection)object).getHeaderField("Retry-After");
            object = ((URLConnection)object).getHeaderField("X-Sentry-Rate-Limits");
            httpConnection.rateLimiter.updateRetryAfterLimits((String)object, string, n);
            int n2 = responseCode;
            if (n2 == 200) break block6;
            this.options.getLogger().log(SentryLevel.ERROR, "Request failed, API returned %s", responseCode);
            if (this.options.isDebug()) {
                void var3_9;
                String errorMessage = HttpConnection.getErrorMessageFromStream(connection);
                this.options.getLogger().log(SentryLevel.ERROR, "%s", var3_9);
            }
            TransportResult.ErrorTransportResult errorTransportResult = TransportResult.error$68316446(responseCode);
            HttpConnection.closeAndDisconnect(connection);
            return errorTransportResult;
        }
        try {
            this.options.getLogger().log(SentryLevel.DEBUG, "Envelope sent successfully.", new Object[0]);
            successTransportResult = TransportResult.SuccessTransportResult.INSTANCE;
        }
        catch (IOException e) {
            try {
                void var2_3;
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var2_3, "Error reading and logging the response stream", new Object[0]);
            }
            catch (Throwable throwable) {
                void var1_1;
                HttpConnection.closeAndDisconnect((HttpURLConnection)var1_1);
                throw throwable;
            }
            HttpConnection.closeAndDisconnect(connection);
            return TransportResult.error$68316446(-1);
        }
        HttpConnection.closeAndDisconnect(connection);
        return successTransportResult;
    }

    private static void closeAndDisconnect(HttpURLConnection connection) {
        try {
            connection.getInputStream().close();
            connection.disconnect();
            return;
        }
        catch (IOException iOException) {
            connection.disconnect();
            return;
        }
        catch (Throwable throwable) {
            HttpURLConnection httpURLConnection;
            httpURLConnection.disconnect();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static String getErrorMessageFromStream(HttpURLConnection connection) {
        String string;
        InputStream errorStream;
        block15: {
            String line;
            errorStream = connection.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                void var3_7;
                if (!first) {
                    sb.append("\n");
                }
                sb.append((String)var3_7);
                first = false;
            }
            string = ((StringBuilder)((Object)string)).toString();
            reader.close();
            if (errorStream == null) break block15;
            errorStream.close();
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            void var1_1;
                            var1_1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (errorStream != null) {
                            try {
                                InputStream inputStream;
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    return "Failed to obtain error message while analyzing send failure.";
                }
            }
        }
    }
}

