/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.protocol.SentryPackage;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class SdkVersion
implements JsonSerializable {
    private String name;
    private String version;
    private Set<SentryPackage> deserializedPackages;
    private Set<String> deserializedIntegrations;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SdkVersion(String name, String version) {
        void var2_2;
        void var1_1;
        this.name = (String)Objects.requireNonNull(var1_1, "name is required.");
        this.version = (String)Objects.requireNonNull(var2_2, "version is required.");
    }

    /*
     * WARNING - void declaration
     */
    public final void setVersion(String version) {
        void var1_1;
        this.version = (String)Objects.requireNonNull(var1_1, "version is required.");
    }

    /*
     * WARNING - void declaration
     */
    public final void setName(String name) {
        void var1_1;
        this.name = (String)Objects.requireNonNull(var1_1, "name is required.");
    }

    /*
     * WARNING - void declaration
     */
    public static void addPackage(String name, String version) {
        void var1_1;
        String string;
        SentryIntegrationPackageStorage.getInstance().addPackage(string, (String)var1_1);
    }

    public final Set<SentryPackage> getPackageSet() {
        if (this.deserializedPackages != null) {
            return this.deserializedPackages;
        }
        return SentryIntegrationPackageStorage.getInstance().getPackages();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkVersion that = (SdkVersion)o;
        return this.name.equals(that.name) && this.version.equals(var1_1.version);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.name, this.version};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        Set<String> integrations;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("name").value$7c2ed8b3(this.name);
        writer.name$7c2ed8b3("version").value$7c2ed8b3(this.version);
        Set<SentryPackage> packages = this.getPackageSet();
        SdkVersion sdkVersion = this;
        Set<String> set = integrations = sdkVersion.deserializedIntegrations != null ? sdkVersion.deserializedIntegrations : SentryIntegrationPackageStorage.getInstance().getIntegrations();
        if (!packages.isEmpty()) {
            Iterator<String> iterator;
            writer.name$7c2ed8b3("packages").value$74e4a76(logger, iterator);
        }
        if (!integrations.isEmpty()) {
            writer.name$7c2ed8b3("integrations").value$74e4a76(logger, integrations);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key).value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Set access$002(SdkVersion x0, Set x1) {
        void var1_1;
        x0.deserializedPackages = var1_1;
        return x0.deserializedPackages;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Set access$102(SdkVersion x0, Set x1) {
        void var1_1;
        x0.deserializedIntegrations = var1_1;
        return x0.deserializedIntegrations;
    }

    public static final class Deserializer
    implements JsonDeserializer<SdkVersion> {
    }
}

