/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public final class Request
implements JsonSerializable {
    private String url;
    private String method;
    private String queryString;
    private Object data;
    private String cookies;
    private Map<String, String> headers;
    private Map<String, String> env;
    private Long bodySize;
    private Map<String, String> other;
    private String fragment;
    private String apiTarget;
    private Map<String, Object> unknown;

    public Request() {
    }

    /*
     * WARNING - void declaration
     */
    public Request(Request request) {
        void var1_1;
        this.url = request.url;
        this.cookies = request.cookies;
        this.method = request.method;
        this.queryString = request.queryString;
        this.headers = CollectionUtils.newConcurrentHashMap(request.headers);
        this.env = CollectionUtils.newConcurrentHashMap(request.env);
        this.other = CollectionUtils.newConcurrentHashMap(request.other);
        this.unknown = CollectionUtils.newConcurrentHashMap(request.unknown);
        this.data = request.data;
        this.fragment = request.fragment;
        this.bodySize = request.bodySize;
        this.apiTarget = var1_1.apiTarget;
    }

    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.url, request.url) && Objects.equals(this.method, request.method) && Objects.equals(this.queryString, request.queryString) && Objects.equals(this.cookies, request.cookies) && Objects.equals(this.headers, request.headers) && Objects.equals(this.env, request.env) && Objects.equals(this.bodySize, request.bodySize) && Objects.equals(this.fragment, request.fragment) && Objects.equals(this.apiTarget, var1_1.apiTarget);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.url, this.method, this.queryString, this.cookies, this.headers, this.env, this.bodySize, this.fragment, this.apiTarget};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        if (this.url != null) {
            writer.name$7c2ed8b3("url").value$7c2ed8b3(this.url);
        }
        if (this.method != null) {
            writer.name$7c2ed8b3("method").value$7c2ed8b3(this.method);
        }
        if (this.queryString != null) {
            writer.name$7c2ed8b3("query_string").value$7c2ed8b3(this.queryString);
        }
        if (this.data != null) {
            writer.name$7c2ed8b3("data").value$74e4a76(logger, this.data);
        }
        if (this.cookies != null) {
            writer.name$7c2ed8b3("cookies").value$7c2ed8b3(this.cookies);
        }
        if (this.headers != null) {
            writer.name$7c2ed8b3("headers").value$74e4a76(logger, this.headers);
        }
        if (this.env != null) {
            writer.name$7c2ed8b3("env").value$74e4a76(logger, this.env);
        }
        if (this.other != null) {
            writer.name$7c2ed8b3("other").value$74e4a76(logger, this.other);
        }
        if (this.fragment != null) {
            writer.name$7c2ed8b3("fragment").value$74e4a76(logger, this.fragment);
        }
        if (this.bodySize != null) {
            writer.name$7c2ed8b3("body_size").value$74e4a76(logger, this.bodySize);
        }
        if (this.apiTarget != null) {
            writer.name$7c2ed8b3("api_target").value$74e4a76(logger, this.apiTarget);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(Request x0, String x1) {
        void var1_1;
        x0.url = var1_1;
        return x0.url;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(Request x0, String x1) {
        void var1_1;
        x0.method = var1_1;
        return x0.method;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(Request x0, String x1) {
        void var1_1;
        x0.queryString = var1_1;
        return x0.queryString;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$302(Request x0, Object x1) {
        void var1_1;
        x0.data = var1_1;
        return x0.data;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(Request x0, String x1) {
        void var1_1;
        x0.cookies = var1_1;
        return x0.cookies;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$502(Request x0, Map x1) {
        void var1_1;
        x0.headers = var1_1;
        return x0.headers;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$602(Request x0, Map x1) {
        void var1_1;
        x0.env = var1_1;
        return x0.env;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$702(Request x0, Map x1) {
        void var1_1;
        x0.other = var1_1;
        return x0.other;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$802(Request x0, String x1) {
        void var1_1;
        x0.fragment = var1_1;
        return x0.fragment;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$902(Request x0, Long x1) {
        void var1_1;
        x0.bodySize = var1_1;
        return x0.bodySize;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1002(Request x0, String x1) {
        void var1_1;
        x0.apiTarget = var1_1;
        return x0.apiTarget;
    }

    public static final class Deserializer
    implements JsonDeserializer<Request> {
    }
}

