/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class Device
implements JsonSerializable {
    private String name;
    private String manufacturer;
    private String brand;
    private String family;
    private String model;
    private String modelId;
    private String[] archs;
    private Float batteryLevel;
    private Boolean charging;
    private Boolean online;
    private DeviceOrientation orientation;
    private Boolean simulator;
    private Long memorySize;
    private Long freeMemory;
    private Long usableMemory;
    private Boolean lowMemory;
    private Long storageSize;
    private Long freeStorage;
    private Long externalStorageSize;
    private Long externalFreeStorage;
    private Integer screenWidthPixels;
    private Integer screenHeightPixels;
    private Float screenDensity;
    private Integer screenDpi;
    private Date bootTime;
    private TimeZone timezone;
    private String id;
    @Deprecated
    private String language;
    private String locale;
    private String connectionType;
    private Float batteryTemperature;
    private Integer processorCount;
    private Double processorFrequency;
    private String cpuDescription;
    private Map<String, Object> unknown;

    public Device() {
    }

    /*
     * WARNING - void declaration
     */
    Device(Device device) {
        void var1_1;
        void var2_2;
        this.name = device.name;
        this.manufacturer = device.manufacturer;
        this.brand = device.brand;
        this.family = device.family;
        this.model = device.model;
        this.modelId = device.modelId;
        this.charging = device.charging;
        this.online = device.online;
        this.orientation = device.orientation;
        this.simulator = device.simulator;
        this.memorySize = device.memorySize;
        this.freeMemory = device.freeMemory;
        this.usableMemory = device.usableMemory;
        this.lowMemory = device.lowMemory;
        this.storageSize = device.storageSize;
        this.freeStorage = device.freeStorage;
        this.externalStorageSize = device.externalStorageSize;
        this.externalFreeStorage = device.externalFreeStorage;
        this.screenWidthPixels = device.screenWidthPixels;
        this.screenHeightPixels = device.screenHeightPixels;
        this.screenDensity = device.screenDensity;
        this.screenDpi = device.screenDpi;
        this.bootTime = device.bootTime;
        this.id = device.id;
        this.language = device.language;
        this.connectionType = device.connectionType;
        this.batteryTemperature = device.batteryTemperature;
        this.batteryLevel = device.batteryLevel;
        String[] archsRef = device.archs;
        this.archs = archsRef != null ? (String[])archsRef.clone() : null;
        this.locale = device.locale;
        TimeZone timezoneRef = device.timezone;
        this.timezone = timezoneRef != null ? (TimeZone)var2_2.clone() : null;
        this.processorCount = device.processorCount;
        this.processorFrequency = device.processorFrequency;
        this.cpuDescription = device.cpuDescription;
        this.unknown = CollectionUtils.newConcurrentHashMap(var1_1.unknown);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.name, device.name) && Objects.equals(this.manufacturer, device.manufacturer) && Objects.equals(this.brand, device.brand) && Objects.equals(this.family, device.family) && Objects.equals(this.model, device.model) && Objects.equals(this.modelId, device.modelId) && Arrays.equals(this.archs, device.archs) && Objects.equals(this.batteryLevel, device.batteryLevel) && Objects.equals(this.charging, device.charging) && Objects.equals(this.online, device.online) && this.orientation == device.orientation && Objects.equals(this.simulator, device.simulator) && Objects.equals(this.memorySize, device.memorySize) && Objects.equals(this.freeMemory, device.freeMemory) && Objects.equals(this.usableMemory, device.usableMemory) && Objects.equals(this.lowMemory, device.lowMemory) && Objects.equals(this.storageSize, device.storageSize) && Objects.equals(this.freeStorage, device.freeStorage) && Objects.equals(this.externalStorageSize, device.externalStorageSize) && Objects.equals(this.externalFreeStorage, device.externalFreeStorage) && Objects.equals(this.screenWidthPixels, device.screenWidthPixels) && Objects.equals(this.screenHeightPixels, device.screenHeightPixels) && Objects.equals(this.screenDensity, device.screenDensity) && Objects.equals(this.screenDpi, device.screenDpi) && Objects.equals(this.bootTime, device.bootTime) && Objects.equals(this.id, device.id) && Objects.equals(this.language, device.language) && Objects.equals(this.locale, device.locale) && Objects.equals(this.connectionType, device.connectionType) && Objects.equals(this.batteryTemperature, device.batteryTemperature) && Objects.equals(this.processorCount, device.processorCount) && Objects.equals(this.processorFrequency, device.processorFrequency) && Objects.equals(this.cpuDescription, var1_1.cpuDescription);
    }

    public final int hashCode() {
        int n;
        Object[] objectArray = new Object[]{this.name, this.manufacturer, this.brand, this.family, this.model, this.modelId, this.batteryLevel, this.charging, this.online, this.orientation, this.simulator, this.memorySize, this.freeMemory, this.usableMemory, this.lowMemory, this.storageSize, this.freeStorage, this.externalStorageSize, this.externalFreeStorage, this.screenWidthPixels, this.screenHeightPixels, this.screenDensity, this.screenDpi, this.bootTime, this.timezone, this.id, this.language, this.locale, this.connectionType, this.batteryTemperature, this.processorCount, this.processorFrequency, this.cpuDescription};
        int result = Arrays.hashCode(objectArray);
        n = 31 * n + Arrays.hashCode(this.archs);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        if (this.name != null) {
            writer.name$7c2ed8b3("name").value$7c2ed8b3(this.name);
        }
        if (this.manufacturer != null) {
            writer.name$7c2ed8b3("manufacturer").value$7c2ed8b3(this.manufacturer);
        }
        if (this.brand != null) {
            writer.name$7c2ed8b3("brand").value$7c2ed8b3(this.brand);
        }
        if (this.family != null) {
            writer.name$7c2ed8b3("family").value$7c2ed8b3(this.family);
        }
        if (this.model != null) {
            writer.name$7c2ed8b3("model").value$7c2ed8b3(this.model);
        }
        if (this.modelId != null) {
            writer.name$7c2ed8b3("model_id").value$7c2ed8b3(this.modelId);
        }
        if (this.archs != null) {
            writer.name$7c2ed8b3("archs").value$74e4a76(logger, this.archs);
        }
        if (this.batteryLevel != null) {
            writer.name$7c2ed8b3("battery_level").value$35a3737b(this.batteryLevel);
        }
        if (this.charging != null) {
            writer.name$7c2ed8b3("charging").value$64a46b74(this.charging);
        }
        if (this.online != null) {
            writer.name$7c2ed8b3("online").value$64a46b74(this.online);
        }
        if (this.orientation != null) {
            writer.name$7c2ed8b3("orientation").value$74e4a76(logger, this.orientation);
        }
        if (this.simulator != null) {
            writer.name$7c2ed8b3("simulator").value$64a46b74(this.simulator);
        }
        if (this.memorySize != null) {
            writer.name$7c2ed8b3("memory_size").value$35a3737b(this.memorySize);
        }
        if (this.freeMemory != null) {
            writer.name$7c2ed8b3("free_memory").value$35a3737b(this.freeMemory);
        }
        if (this.usableMemory != null) {
            writer.name$7c2ed8b3("usable_memory").value$35a3737b(this.usableMemory);
        }
        if (this.lowMemory != null) {
            writer.name$7c2ed8b3("low_memory").value$64a46b74(this.lowMemory);
        }
        if (this.storageSize != null) {
            writer.name$7c2ed8b3("storage_size").value$35a3737b(this.storageSize);
        }
        if (this.freeStorage != null) {
            writer.name$7c2ed8b3("free_storage").value$35a3737b(this.freeStorage);
        }
        if (this.externalStorageSize != null) {
            writer.name$7c2ed8b3("external_storage_size").value$35a3737b(this.externalStorageSize);
        }
        if (this.externalFreeStorage != null) {
            writer.name$7c2ed8b3("external_free_storage").value$35a3737b(this.externalFreeStorage);
        }
        if (this.screenWidthPixels != null) {
            writer.name$7c2ed8b3("screen_width_pixels").value$35a3737b(this.screenWidthPixels);
        }
        if (this.screenHeightPixels != null) {
            writer.name$7c2ed8b3("screen_height_pixels").value$35a3737b(this.screenHeightPixels);
        }
        if (this.screenDensity != null) {
            writer.name$7c2ed8b3("screen_density").value$35a3737b(this.screenDensity);
        }
        if (this.screenDpi != null) {
            writer.name$7c2ed8b3("screen_dpi").value$35a3737b(this.screenDpi);
        }
        if (this.bootTime != null) {
            writer.name$7c2ed8b3("boot_time").value$74e4a76(logger, this.bootTime);
        }
        if (this.timezone != null) {
            writer.name$7c2ed8b3("timezone").value$74e4a76(logger, this.timezone);
        }
        if (this.id != null) {
            writer.name$7c2ed8b3("id").value$7c2ed8b3(this.id);
        }
        if (this.language != null) {
            writer.name$7c2ed8b3("language").value$7c2ed8b3(this.language);
        }
        if (this.connectionType != null) {
            writer.name$7c2ed8b3("connection_type").value$7c2ed8b3(this.connectionType);
        }
        if (this.batteryTemperature != null) {
            writer.name$7c2ed8b3("battery_temperature").value$35a3737b(this.batteryTemperature);
        }
        if (this.locale != null) {
            writer.name$7c2ed8b3("locale").value$7c2ed8b3(this.locale);
        }
        if (this.processorCount != null) {
            writer.name$7c2ed8b3("processor_count").value$35a3737b(this.processorCount);
        }
        if (this.processorFrequency != null) {
            writer.name$7c2ed8b3("processor_frequency").value$35a3737b(this.processorFrequency);
        }
        if (this.cpuDescription != null) {
            writer.name$7c2ed8b3("cpu_description").value$7c2ed8b3(this.cpuDescription);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key).value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(Device x0, String x1) {
        void var1_1;
        x0.name = var1_1;
        return x0.name;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(Device x0, String x1) {
        void var1_1;
        x0.manufacturer = var1_1;
        return x0.manufacturer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(Device x0, String x1) {
        void var1_1;
        x0.brand = var1_1;
        return x0.brand;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(Device x0, String x1) {
        void var1_1;
        x0.family = var1_1;
        return x0.family;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(Device x0, String x1) {
        void var1_1;
        x0.model = var1_1;
        return x0.model;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(Device x0, String x1) {
        void var1_1;
        x0.modelId = var1_1;
        return x0.modelId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String[] access$602(Device x0, String[] x1) {
        void var1_1;
        x0.archs = var1_1;
        return x0.archs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Float access$702(Device x0, Float x1) {
        void var1_1;
        x0.batteryLevel = var1_1;
        return x0.batteryLevel;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Boolean access$802(Device x0, Boolean x1) {
        void var1_1;
        x0.charging = var1_1;
        return x0.charging;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Boolean access$902(Device x0, Boolean x1) {
        void var1_1;
        x0.online = var1_1;
        return x0.online;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ DeviceOrientation access$1002(Device x0, DeviceOrientation x1) {
        void var1_1;
        x0.orientation = var1_1;
        return x0.orientation;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Boolean access$1102(Device x0, Boolean x1) {
        void var1_1;
        x0.simulator = var1_1;
        return x0.simulator;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1202(Device x0, Long x1) {
        void var1_1;
        x0.memorySize = var1_1;
        return x0.memorySize;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1302(Device x0, Long x1) {
        void var1_1;
        x0.freeMemory = var1_1;
        return x0.freeMemory;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1402(Device x0, Long x1) {
        void var1_1;
        x0.usableMemory = var1_1;
        return x0.usableMemory;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Boolean access$1502(Device x0, Boolean x1) {
        void var1_1;
        x0.lowMemory = var1_1;
        return x0.lowMemory;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1602(Device x0, Long x1) {
        void var1_1;
        x0.storageSize = var1_1;
        return x0.storageSize;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1702(Device x0, Long x1) {
        void var1_1;
        x0.freeStorage = var1_1;
        return x0.freeStorage;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1802(Device x0, Long x1) {
        void var1_1;
        x0.externalStorageSize = var1_1;
        return x0.externalStorageSize;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Long access$1902(Device x0, Long x1) {
        void var1_1;
        x0.externalFreeStorage = var1_1;
        return x0.externalFreeStorage;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Integer access$2002(Device x0, Integer x1) {
        void var1_1;
        x0.screenWidthPixels = var1_1;
        return x0.screenWidthPixels;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Integer access$2102(Device x0, Integer x1) {
        void var1_1;
        x0.screenHeightPixels = var1_1;
        return x0.screenHeightPixels;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Float access$2202(Device x0, Float x1) {
        void var1_1;
        x0.screenDensity = var1_1;
        return x0.screenDensity;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Integer access$2302(Device x0, Integer x1) {
        void var1_1;
        x0.screenDpi = var1_1;
        return x0.screenDpi;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Date access$2402(Device x0, Date x1) {
        void var1_1;
        x0.bootTime = var1_1;
        return x0.bootTime;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ TimeZone access$2502(Device x0, TimeZone x1) {
        void var1_1;
        x0.timezone = var1_1;
        return x0.timezone;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2602(Device x0, String x1) {
        void var1_1;
        x0.id = var1_1;
        return x0.id;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2702(Device x0, String x1) {
        void var1_1;
        x0.language = var1_1;
        return x0.language;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2802(Device x0, String x1) {
        void var1_1;
        x0.connectionType = var1_1;
        return x0.connectionType;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Float access$2902(Device x0, Float x1) {
        void var1_1;
        x0.batteryTemperature = var1_1;
        return x0.batteryTemperature;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$3002(Device x0, String x1) {
        void var1_1;
        x0.locale = var1_1;
        return x0.locale;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Integer access$3102(Device x0, Integer x1) {
        void var1_1;
        x0.processorCount = var1_1;
        return x0.processorCount;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Double access$3202(Device x0, Double x1) {
        void var1_1;
        x0.processorFrequency = var1_1;
        return x0.processorFrequency;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$3302(Device x0, String x1) {
        void var1_1;
        x0.cpuDescription = var1_1;
        return x0.cpuDescription;
    }

    public static enum DeviceOrientation implements JsonSerializable
    {
        PORTRAIT,
        LANDSCAPE;


        @Override
        public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
            writer.value$7c2ed8b3(this.toString().toLowerCase(Locale.ROOT));
        }

        public static final class Deserializer
        implements JsonDeserializer<DeviceOrientation> {
        }
    }

    public static final class Deserializer
    implements JsonDeserializer<Device> {
        /*
         * WARNING - void declaration
         */
        public static Device deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            ObjectReader objectReader;
            void var3_3;
            reader.beginObject();
            Device device = new Device();
            ConcurrentHashMap<String, Object> unknown = null;
            block72: while (reader.peek() == JsonToken.NAME) {
                void var4_4;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "name": {
                        Device.access$002(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "manufacturer": {
                        Device.access$102(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "brand": {
                        Device.access$202(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "family": {
                        Device.access$302(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "model": {
                        Device.access$402(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "model_id": {
                        Device.access$502(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "archs": {
                        List archsList = (List)reader.nextObjectOrNull();
                        if (archsList == null) continue block72;
                        String[] archsArray = new String[archsList.size()];
                        archsList.toArray(archsArray);
                        Device.access$602(device, archsArray);
                        continue block72;
                    }
                    case "battery_level": {
                        Device.access$702(device, reader.nextFloatOrNull());
                        continue block72;
                    }
                    case "charging": {
                        Device.access$802(device, reader.nextBooleanOrNull());
                        continue block72;
                    }
                    case "online": {
                        Device.access$902(device, reader.nextBooleanOrNull());
                        continue block72;
                    }
                    case "orientation": {
                        Device.access$1002(device, reader.nextOrNull(logger, new DeviceOrientation.Deserializer()));
                        continue block72;
                    }
                    case "simulator": {
                        Device.access$1102(device, reader.nextBooleanOrNull());
                        continue block72;
                    }
                    case "memory_size": {
                        Device.access$1202(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "free_memory": {
                        Device.access$1302(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "usable_memory": {
                        Device.access$1402(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "low_memory": {
                        Device.access$1502(device, reader.nextBooleanOrNull());
                        continue block72;
                    }
                    case "storage_size": {
                        Device.access$1602(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "free_storage": {
                        Device.access$1702(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "external_storage_size": {
                        Device.access$1802(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "external_free_storage": {
                        Device.access$1902(device, reader.nextLongOrNull());
                        continue block72;
                    }
                    case "screen_width_pixels": {
                        Device.access$2002(device, reader.nextIntegerOrNull());
                        continue block72;
                    }
                    case "screen_height_pixels": {
                        Device.access$2102(device, reader.nextIntegerOrNull());
                        continue block72;
                    }
                    case "screen_density": {
                        Device.access$2202(device, reader.nextFloatOrNull());
                        continue block72;
                    }
                    case "screen_dpi": {
                        Device.access$2302(device, reader.nextIntegerOrNull());
                        continue block72;
                    }
                    case "boot_time": {
                        if (reader.peek() != JsonToken.STRING) continue block72;
                        Device.access$2402(device, reader.nextDateOrNull(logger));
                        continue block72;
                    }
                    case "timezone": {
                        Device.access$2502(device, reader.nextTimeZoneOrNull(logger));
                        continue block72;
                    }
                    case "id": {
                        Device.access$2602(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "language": {
                        Device.access$2702(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "connection_type": {
                        Device.access$2802(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "battery_temperature": {
                        Device.access$2902(device, reader.nextFloatOrNull());
                        continue block72;
                    }
                    case "locale": {
                        Device.access$3002(device, reader.nextStringOrNull());
                        continue block72;
                    }
                    case "processor_count": {
                        Device.access$3102(device, reader.nextIntegerOrNull());
                        continue block72;
                    }
                    case "processor_frequency": {
                        Device.access$3202(device, reader.nextDoubleOrNull());
                        continue block72;
                    }
                    case "cpu_description": {
                        Device.access$3302(device, reader.nextStringOrNull());
                        continue block72;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)var4_4);
            }
            device.setUnknown((Map<String, Object>)var3_3);
            objectReader.endObject();
            return var2_2;
        }
    }
}

