/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SpanContext;
import io.sentry.protocol.App;
import io.sentry.protocol.Browser;
import io.sentry.protocol.Device;
import io.sentry.protocol.Gpu;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.Response;
import io.sentry.protocol.SentryRuntime;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Contexts
extends ConcurrentHashMap<String, Object>
implements JsonSerializable {
    private final Object responseLock = new Object();

    public Contexts() {
    }

    /*
     * WARNING - void declaration
     */
    public Contexts(Contexts contexts) {
        Iterator iterator;
        for (Map.Entry entry : ((ConcurrentHashMap)((Object)iterator)).entrySet()) {
            void var3_3;
            void var2_2;
            if (entry == null) continue;
            Object value = entry.getValue();
            if ("app".equals(entry.getKey()) && value instanceof App) {
                this.setApp(new App((App)value));
                continue;
            }
            if ("browser".equals(entry.getKey()) && value instanceof Browser) {
                this.setBrowser(new Browser((Browser)value));
                continue;
            }
            if ("device".equals(entry.getKey()) && value instanceof Device) {
                this.setDevice(new Device((Device)value));
                continue;
            }
            if ("os".equals(entry.getKey()) && value instanceof OperatingSystem) {
                this.setOperatingSystem(new OperatingSystem((OperatingSystem)value));
                continue;
            }
            if ("runtime".equals(entry.getKey()) && value instanceof SentryRuntime) {
                this.setRuntime(new SentryRuntime((SentryRuntime)value));
                continue;
            }
            if ("gpu".equals(entry.getKey()) && value instanceof Gpu) {
                this.setGpu(new Gpu((Gpu)value));
                continue;
            }
            if ("trace".equals(entry.getKey()) && value instanceof SpanContext) {
                this.setTrace(new SpanContext((SpanContext)value));
                continue;
            }
            if ("response".equals(entry.getKey()) && value instanceof Response) {
                this.setResponse(new Response((Response)value));
                continue;
            }
            this.put((String)var2_2.getKey(), var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T toContextType(String key, Class<T> clazz) {
        Object item = this.get(key);
        if (clazz.isInstance(item)) {
            void var1_1;
            void var2_2;
            return var2_2.cast(var1_1);
        }
        return null;
    }

    public final SpanContext getTrace() {
        return this.toContextType("trace", SpanContext.class);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrace(SpanContext traceContext) {
        void var1_1;
        Objects.requireNonNull(traceContext, "traceContext is required");
        this.put("trace", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setApp(App app) {
        void var1_1;
        this.put("app", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBrowser(Browser browser) {
        void var1_1;
        this.put("browser", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setDevice(Device device) {
        void var1_1;
        this.put("device", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setOperatingSystem(OperatingSystem operatingSystem) {
        void var1_1;
        this.put("os", var1_1);
    }

    public final SentryRuntime getRuntime() {
        return this.toContextType("runtime", SentryRuntime.class);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRuntime(SentryRuntime runtime) {
        void var1_1;
        this.put("runtime", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setGpu(Gpu gpu) {
        void var1_1;
        this.put("gpu", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setResponse(Response response) {
        Object object = this.responseLock;
        synchronized (object) {
            void var1_1;
            this.put("response", var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        Iterator iterator;
        writer.beginObject$4f1a06e9();
        ArrayList sortedKeys = Collections.list(this.keys());
        Collections.sort(sortedKeys);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = this.get(key);
            if (value == null) continue;
            writer.name$7c2ed8b3(key).value$74e4a76(logger, value);
        }
        var1_1.endObject$4f1a06e9();
    }

    public static final class Deserializer
    implements JsonDeserializer<Contexts> {
        /*
         * WARNING - void declaration
         */
        public static Contexts deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            ObjectReader objectReader;
            Contexts contexts = new Contexts();
            reader.beginObject();
            block20: while (reader.peek() == JsonToken.NAME) {
                void var3_3;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "app": {
                        new App.Deserializer();
                        contexts.setApp(App.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "browser": {
                        new Browser.Deserializer();
                        contexts.setBrowser(Browser.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "device": {
                        new Device.Deserializer();
                        contexts.setDevice(Device.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "gpu": {
                        new Gpu.Deserializer();
                        contexts.setGpu(Gpu.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "os": {
                        new OperatingSystem.Deserializer();
                        contexts.setOperatingSystem(OperatingSystem.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "runtime": {
                        new SentryRuntime.Deserializer();
                        contexts.setRuntime(SentryRuntime.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "trace": {
                        new SpanContext.Deserializer();
                        contexts.setTrace(SpanContext.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                    case "response": {
                        new Response.Deserializer();
                        contexts.setResponse(Response.Deserializer.deserialize(reader, logger));
                        continue block20;
                    }
                }
                Object object = reader.nextObjectOrNull();
                if (object == null) continue;
                contexts.put(var3_3, object);
            }
            objectReader.endObject();
            return var2_2;
        }
    }
}

