/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.ISerializer;
import io.sentry.SentryCrashLastRunState;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.CacheStrategy;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.SessionEnd;
import io.sentry.hints.SessionStart;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.internal.bind.util.ISO8601Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class EnvelopeCache
extends CacheStrategy
implements IEnvelopeCache {
    private final CountDownLatch previousSessionLatch;
    private final Map<SentryEnvelope, String> fileNameMap = new WeakHashMap<SentryEnvelope, String>();

    /*
     * WARNING - void declaration
     */
    public static IEnvelopeCache create(SentryOptions options) {
        void var2_2;
        void var1_1;
        SentryOptions sentryOptions;
        String cacheDirPath = options.getCacheDirPath();
        int maxCacheItems = options.getMaxCacheItems();
        if (cacheDirPath == null) {
            options.getLogger().log(SentryLevel.WARNING, "cacheDirPath is null, returning NoOpEnvelopeCache", new Object[0]);
            return NoOpEnvelopeCache.getInstance();
        }
        return new EnvelopeCache(sentryOptions, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private EnvelopeCache(SentryOptions options, String cacheDirPath, int maxCacheItems) {
        super((SentryOptions)var1_1, (String)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.previousSessionLatch = new CountDownLatch(1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void store(SentryEnvelope envelope, Hint hint) {
        block55: {
            block60: {
                Objects.requireNonNull(envelope, "Envelope is required.");
                v0 = this;
                v0.rotateCacheIfNeeded(v0.allEnvelopeFiles());
                var5_3 = this.directory.getAbsolutePath();
                currentSessionFile = new File((String)var5_3, "session.json");
                previousSessionFile = EnvelopeCache.getPreviousSessionFile(this.directory.getAbsolutePath());
                if (HintUtils.hasType(hint, SessionEnd.class) && !currentSessionFile.delete()) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Current envelope doesn't exist.", new Object[0]);
                }
                if (!HintUtils.hasType(hint, AbnormalExit.class)) break block55;
                var6_9 = hint;
                var5_3 = this;
                var7_12 = var6_9.get("sentry:typeCheckHint");
                if (!(var7_12 instanceof AbnormalExit)) break block55;
                var8_16 = EnvelopeCache.getPreviousSessionFile(var5_3.directory.getAbsolutePath());
                if (!var8_16.exists()) break block60;
                var5_3.options.getLogger().log(SentryLevel.WARNING, "Previous session is not ended, we'd need to end it.", new Object[0]);
                try {
                    var9_19 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)var8_16), EnvelopeCache.UTF_8));
                    try {
                        var10_23 = ((ISerializer)var5_3.serializer.getValue()).deserialize((Reader)var9_19, Session.class);
                        if (var10_23 == null) break block55;
                        var7_12 = (AbnormalExit)var7_12;
                        var6_9 = var7_12.timestamp();
                        var11_27 = null;
                        if (var6_9 == null) ** GOTO lbl-1000
                        var11_27 = DateUtils.getDateTime(var6_9.longValue());
                        var6_9 = var10_23.getStarted();
                        if (var6_9 == null || var11_27.before((Date)var6_9)) {
                            var5_3.options.getLogger().log(SentryLevel.WARNING, "Abnormal exit happened before previous session start, not ending the session.", new Object[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var6_9 = var7_12.mechanism();
                            var10_23.update(Session.State.Abnormal, null, true, (String)var6_9);
                            var10_23.end(var11_27);
                            super.writeSessionToDisk((File)var8_16, (Session)var10_23);
                        }
                        break block55;
                    }
                    finally {
                        var9_19.close();
                    }
                }
                catch (Throwable var9_20) {
                    var5_3.options.getLogger().log(SentryLevel.ERROR, "Error processing previous session.", var9_20);
                }
                break block55;
            }
            var5_3.options.getLogger().log(SentryLevel.DEBUG, "No previous session file to end.", new Object[0]);
        }
        if (HintUtils.hasType(hint, SessionStart.class)) {
            if (currentSessionFile.exists()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Current session is not ended, we'd need to end it.", new Object[0]);
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(currentSessionFile), EnvelopeCache.UTF_8));
                    try {
                        session = ((ISerializer)this.serializer.getValue()).deserialize(reader, Session.class);
                        if (session != null) {
                            this.writeSessionToDisk(previousSessionFile, session);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error processing session.", e);
                }
            }
            var7_12 = envelope;
            var6_9 = var3_6;
            e = this;
            var8_16 = var7_12.getItems();
            if (var8_16.iterator().hasNext()) {
                var9_19 = (SentryEnvelopeItem)var8_16.iterator().next();
                if (SentryItemType.Session.equals(var9_19.getHeader().getType())) {
                    try {
                        var10_23 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(var9_19.getData()), EnvelopeCache.UTF_8));
                        try {
                            var7_12 = ((ISerializer)e.serializer.getValue()).deserialize((Reader)var10_23, Session.class);
                            if (var7_12 == null) {
                                e.options.getLogger().log(SentryLevel.ERROR, "Item of type %s returned null by the parser.", new Object[]{var9_19.getHeader().getType()});
                            } else {
                                e.writeSessionToDisk((File)var6_9, (Session)var7_12);
                            }
                        }
                        finally {
                            var10_23.close();
                        }
                    }
                    catch (Throwable var10_25) {
                        e.options.getLogger().log(SentryLevel.ERROR, "Item failed to process.", var10_25);
                    }
                } else {
                    e.options.getLogger().log(SentryLevel.INFO, "Current envelope has a different envelope type %s", new Object[]{var9_19.getHeader().getType()});
                }
            } else {
                e.options.getLogger().log(SentryLevel.INFO, "Current envelope %s is empty", new Object[]{var6_9.getAbsolutePath()});
            }
            crashedLastRun = false;
            var6_9 = new File(this.options.getCacheDirPath(), ".sentry-native/last_crash");
            if (var6_9.exists()) {
                crashedLastRun = true;
            }
            if (!crashedLastRun && (javaCrashMarkerFile = new File(this.options.getCacheDirPath(), "last_crash")).exists()) {
                this.options.getLogger().log(SentryLevel.INFO, "Crash marker file exists, crashedLastRun will return true.", new Object[0]);
                crashedLastRun = true;
                if (!javaCrashMarkerFile.delete()) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete the crash marker file. %s.", new Object[]{javaCrashMarkerFile.getAbsolutePath()});
                }
            }
            SentryCrashLastRunState.getInstance().setCrashedLastRun(crashedLastRun);
            crashedLastRun = this;
            crashedLastRun.previousSessionLatch.countDown();
        }
        if ((envelopeFile = this.getEnvelopeFile(envelope)).exists()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Not adding Envelope to offline storage because it already exists: %s", new Object[]{envelopeFile.getAbsolutePath()});
            return;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Adding Envelope to offline storage: %s", new Object[]{envelopeFile.getAbsolutePath()});
        var7_12 = var1_1;
        var6_9 = envelopeFile;
        var5_3 = this;
        if (var6_9.exists()) {
            var5_3.options.getLogger().log(SentryLevel.DEBUG, "Overwriting envelope to offline storage: %s", new Object[]{var6_9.getAbsolutePath()});
            if (!var6_9.delete()) {
                var5_3.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", new Object[]{var6_9.getAbsolutePath()});
            }
        }
        try {
            var8_16 = new FileOutputStream((File)var6_9);
            try {
                ((ISerializer)var5_3.serializer.getValue()).serialize((SentryEnvelope)var7_12, (OutputStream)var8_16);
            }
            finally {
                var8_16.close();
            }
        }
        catch (Throwable var8_17) {
            var5_3.options.getLogger().log(SentryLevel.ERROR, var8_17, "Error writing Envelope %s to offline storage", new Object[]{var6_9.getAbsolutePath()});
        }
        if (HintUtils.hasType((Hint)var2_2, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
            var5_3 = this;
            var6_9 = new File(var5_3.options.getCacheDirPath(), "last_crash");
            try {
                var7_12 = new FileOutputStream((File)var6_9);
                try {
                    var6_9 = DateUtils.getCurrentDateTime();
                    var8_16 = ISO8601Utils.format((Date)var6_9, true);
                    var7_12.write(var8_16.getBytes(EnvelopeCache.UTF_8));
                    var7_12.flush();
                }
                finally {
                    var7_12.close();
                }
            }
            catch (Throwable var7_15) {
                var5_3.options.getLogger().log(SentryLevel.ERROR, "Error writing the crash marker file to the disk", var7_15);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSessionToDisk(File file, Session session) {
        if (file.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Overwriting session to offline storage: %s", session.getSessionId());
            if (!file.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete: %s", file.getAbsolutePath());
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));
            try {
                ((ISerializer)this.serializer.getValue()).serialize(session, writer);
            }
            catch (Throwable throwable) {
                try {
                    void var3_4;
                    var3_4.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ((Writer)writer).close();
        }
        catch (Throwable e) {
            void var2_3;
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var1_2, "Error writing Session to offline storage: %s", var2_3.getSessionId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void discard(SentryEnvelope envelope) {
        Objects.requireNonNull(envelope, "Envelope is required.");
        File envelopeFile = this.getEnvelopeFile(envelope);
        if (envelopeFile.exists()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Discarding envelope from cache: %s", envelopeFile.getAbsolutePath());
            if (!envelopeFile.delete()) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete envelope: %s", envelopeFile.getAbsolutePath());
                return;
            }
        } else {
            void var1_1;
            this.options.getLogger().log(SentryLevel.DEBUG, "Envelope was not cached: %s", var1_1.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized File getEnvelopeFile(SentryEnvelope envelope) {
        void var2_2;
        String fileName;
        if (this.fileNameMap.containsKey(envelope)) {
            fileName = this.fileNameMap.get(envelope);
        } else {
            void var1_1;
            fileName = UUID.randomUUID() + ".envelope";
            this.fileNameMap.put((SentryEnvelope)var1_1, fileName);
        }
        return new File(this.directory.getAbsolutePath(), (String)var2_2);
    }

    public static File getPreviousSessionFile(String cacheDirPath) {
        String string;
        return new File(string, "previous_session.json");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<SentryEnvelope> iterator() {
        void var2_2;
        void var1_1;
        File[] allCachedEnvelopes = this.allEnvelopeFiles();
        ArrayList<SentryEnvelope> ret = new ArrayList<SentryEnvelope>(allCachedEnvelopes.length);
        for (void file : var1_1) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((File)file));){
                ret.add(((ISerializer)this.serializer.getValue()).deserializeEnvelope(is));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Envelope file '%s' disappeared while converting all cached files to envelopes.", file.getAbsolutePath());
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.ERROR, String.format("Error while reading cached envelope from file %s", file.getAbsolutePath()), e);
            }
        }
        return var2_2.iterator();
    }

    /*
     * WARNING - void declaration
     */
    private File[] allEnvelopeFiles() {
        File[] files;
        if (this.isDirectoryValid() && (files = this.directory.listFiles((__, fileName) -> fileName.endsWith(".envelope"))) != null) {
            void var1_1;
            return var1_1;
        }
        return new File[0];
    }

    public final boolean waitPreviousSessionFlush() {
        try {
            return this.previousSessionLatch.await(this.options.getSessionFlushTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.options.getLogger().log(SentryLevel.DEBUG, "Timed out waiting for previous session to flush.", new Object[0]);
            return false;
        }
    }
}

