/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.ISerializer;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.clientreport.DiscardReason;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

abstract class CacheStrategy {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected SentryOptions options;
    protected final LazyEvaluator<ISerializer> serializer = new LazyEvaluator<ISerializer>(() -> this.options.getSerializer());
    protected final File directory;
    private final int maxSize;

    /*
     * WARNING - void declaration
     */
    CacheStrategy(SentryOptions options, String directoryPath, int maxSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(directoryPath, "Directory is required.");
        this.options = (SentryOptions)Objects.requireNonNull(var1_1, "SentryOptions is required.");
        this.directory = new File((String)var2_2);
        this.maxSize = var3_3;
    }

    protected final boolean isDirectoryValid() {
        if (!(this.directory.isDirectory() && this.directory.canWrite() && this.directory.canRead())) {
            this.options.getLogger().log(SentryLevel.ERROR, "The directory for caching files is inaccessible.: %s", this.directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    protected final void rotateCacheIfNeeded(File[] files) {
        int length = files.length;
        if (length >= this.maxSize) {
            this.options.getLogger().log(SentryLevel.WARNING, "Cache folder if full (respecting maxSize). Rotating files", new Object[0]);
            int totalToBeDeleted = length - this.maxSize + 1;
            Object object = files;
            if (files.length > 1) {
                Arrays.sort(object, (f1, f2) -> {
                    void var1_1;
                    return Long.compare(f1.lastModified(), var1_1.lastModified());
                });
            }
            File[] notDeletedFiles = Arrays.copyOfRange(files, totalToBeDeleted, length);
            for (int i = 0; i < totalToBeDeleted; ++i) {
                File file = files[i];
                File[] fileArray = notDeletedFiles;
                Object object2 = file;
                object = this;
                if ((object2 = ((CacheStrategy)object).readEnvelope((File)object2)) != null && CacheStrategy.isValidEnvelope((SentryEnvelope)object2)) {
                    Object object3;
                    Object object4;
                    block13: {
                        ((CacheStrategy)object).options.getClientReportRecorder().recordLostEnvelope(DiscardReason.CACHE_OVERFLOW, (SentryEnvelope)object2);
                        object4 = object2;
                        object2 = object;
                        object4 = ((SentryEnvelope)object4).getItems().iterator();
                        while (object4.hasNext()) {
                            SentryEnvelopeItem sentryEnvelopeItem = object4.next();
                            if (!CacheStrategy.isSessionType(sentryEnvelopeItem)) continue;
                            object3 = super.readSession(sentryEnvelopeItem);
                            break block13;
                        }
                        object3 = object2 = null;
                    }
                    if (object3 != null && CacheStrategy.isValidSession((Session)object2) && (object4 = ((Session)object2).getInit()) != null && ((Boolean)object4).booleanValue()) {
                        int n = fileArray.length;
                        block4: for (int j = 0; j < n; ++j) {
                            Object object5;
                            File file2 = fileArray[j];
                            SentryEnvelope sentryEnvelope = super.readEnvelope(file2);
                            if (sentryEnvelope == null || !CacheStrategy.isValidEnvelope(sentryEnvelope)) continue;
                            SentryEnvelopeItem sentryEnvelopeItem = null;
                            Iterator<SentryEnvelopeItem> iterator = sentryEnvelope.getItems().iterator();
                            while (iterator.hasNext()) {
                                Session session;
                                object5 = iterator.next();
                                if (!CacheStrategy.isSessionType((SentryEnvelopeItem)object5) || (session = super.readSession((SentryEnvelopeItem)object5)) == null || !CacheStrategy.isValidSession(session)) continue;
                                Boolean bl = session.getInit();
                                if (bl != null && bl.booleanValue()) {
                                    ((CacheStrategy)object).options.getLogger().log(SentryLevel.ERROR, "Session %s has 2 times the init flag.", ((Session)object2).getSessionId());
                                    break block4;
                                }
                                if (((Session)object2).getSessionId() == null || !((Session)object2).getSessionId().equals(session.getSessionId())) continue;
                                session.setInitAsTrue();
                                try {
                                    sentryEnvelopeItem = SentryEnvelopeItem.fromSession(((CacheStrategy)object).serializer.getValue(), session);
                                    iterator.remove();
                                }
                                catch (IOException iOException) {
                                    ((CacheStrategy)object).options.getLogger().log(SentryLevel.ERROR, iOException, "Failed to create new envelope item for the session %s", ((Session)object2).getSessionId());
                                }
                                break;
                            }
                            if (sentryEnvelopeItem == null) continue;
                            SentryEnvelopeItem sentryEnvelopeItem2 = sentryEnvelopeItem;
                            object2 = sentryEnvelope;
                            ArrayList<SentryEnvelopeItem> arrayList = new ArrayList<SentryEnvelopeItem>();
                            for (SentryEnvelopeItem sentryEnvelopeItem3 : ((SentryEnvelope)object2).getItems()) {
                                arrayList.add(sentryEnvelopeItem3);
                            }
                            arrayList.add(sentryEnvelopeItem2);
                            object5 = new SentryEnvelope(((SentryEnvelope)object2).getHeader(), arrayList);
                            long l = file2.lastModified();
                            if (!file2.delete()) {
                                ((CacheStrategy)object).options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", file2.getAbsolutePath());
                            }
                            super.saveNewEnvelope((SentryEnvelope)object5, file2, l);
                            break;
                        }
                    }
                }
                if (file.delete()) continue;
                this.options.getLogger().log(SentryLevel.WARNING, "File can't be deleted: %s", file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelope readEnvelope(File file) {
        SentryEnvelope sentryEnvelope;
        BufferedInputStream inputStream2 = new BufferedInputStream(new FileInputStream(file));
        try {
            sentryEnvelope = this.serializer.getValue().deserializeEnvelope(inputStream2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (Throwable inputStream2) {
                    throwable.addSuppressed(inputStream2);
                }
                throw throwable;
            }
            catch (IOException e) {
                void var1_3;
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the envelope.", (Throwable)var1_3);
                return null;
            }
        }
        ((InputStream)inputStream2).close();
        return sentryEnvelope;
    }

    private static boolean isValidSession(Session session) {
        Object object;
        if (!session.getStatus().equals((Object)Session.State.Ok)) {
            return false;
        }
        return (object = ((Session)object).getSessionId()) != null;
    }

    private static boolean isSessionType(SentryEnvelopeItem item) {
        SentryEnvelopeItem sentryEnvelopeItem;
        if (item == null) {
            return false;
        }
        return sentryEnvelopeItem.getHeader().getType().equals(SentryItemType.Session);
    }

    /*
     * WARNING - void declaration
     */
    private Session readSession(SentryEnvelopeItem item) {
        Session session;
        BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));
        try {
            session = this.serializer.getValue().deserialize(reader2, Session.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader2).close();
                }
                catch (Throwable reader2) {
                    throwable.addSuppressed(reader2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                void var1_3;
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to deserialize the session.", (Throwable)var1_3);
                return null;
            }
        }
        ((Reader)reader2).close();
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private void saveNewEnvelope(SentryEnvelope envelope, File file, long timestamp) {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            void var3_5;
            void var2_3;
            void var1_1;
            this.serializer.getValue().serialize((SentryEnvelope)var1_1, outputStream);
            var2_3.setLastModified((long)var3_5);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to serialize the new envelope to the disk.", e);
        }
    }

    private static boolean isValidEnvelope(SentryEnvelope envelope) {
        return envelope.getItems().iterator().hasNext();
    }
}

