/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SamplingContext;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.util.Objects;
import io.sentry.util.Random;

final class TracesSampler {
    private static final Double DEFAULT_TRACES_SAMPLE_RATE = 1.0;
    private final SentryOptions options;
    private final Random random;

    /*
     * WARNING - void declaration
     */
    public TracesSampler(SentryOptions options) {
        this((SentryOptions)Objects.requireNonNull(var1_1, "options are required"), new Random());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TracesSampler(SentryOptions options, Random random) {
        void var2_2;
        void var1_1;
        this.options = var1_1;
        this.random = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final TracesSamplingDecision sample(SamplingContext samplingContext) {
        TracesSamplingDecision parentSamplingDecision;
        TracesSamplingDecision samplingContextSamplingDecision = samplingContext.getTransactionContext().getSamplingDecision();
        if (samplingContextSamplingDecision != null) {
            return samplingContextSamplingDecision;
        }
        Double profilesSampleRate = null;
        if (this.options.getProfilesSampler() != null) {
            try {
                profilesSampleRate = this.options.getProfilesSampler().sample$7bdd8675();
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ProfilesSamplerCallback' callback.", t);
            }
        }
        if (profilesSampleRate == null) {
            profilesSampleRate = this.options.getProfilesSampleRate();
        }
        Boolean profilesSampled = profilesSampleRate != null && this.sample(profilesSampleRate);
        if (this.options.getTracesSampler() != null) {
            Double samplerResult = null;
            try {
                samplerResult = this.options.getTracesSampler().sample$7bdd8675();
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'TracesSamplerCallback' callback.", t);
            }
            if (samplerResult != null) {
                return new TracesSamplingDecision(this.sample(samplerResult), samplerResult, profilesSampled, profilesSampleRate);
            }
        }
        if ((parentSamplingDecision = samplingContext.getTransactionContext().getParentSamplingDecision()) != null) {
            return parentSamplingDecision;
        }
        Double tracesSampleRateFromOptions = this.options.getTracesSampleRate();
        Boolean isEnableTracing = this.options.getEnableTracing();
        Double defaultSampleRate = Boolean.TRUE.equals(isEnableTracing) ? DEFAULT_TRACES_SAMPLE_RATE : null;
        Double tracesSampleRateOrDefault = tracesSampleRateFromOptions == null ? defaultSampleRate : tracesSampleRateFromOptions;
        Double downsampleFactor = Math.pow(2.0, this.options.getBackpressureMonitor().getDownsampleFactor());
        Double downsampledTracesSampleRate = tracesSampleRateOrDefault == null ? null : Double.valueOf(tracesSampleRateOrDefault / downsampleFactor);
        if (downsampledTracesSampleRate != null) {
            void var2_2;
            void var3_4;
            void var1_1;
            return new TracesSamplingDecision(this.sample(downsampledTracesSampleRate), (Double)var1_1, (Boolean)var3_4, (Double)var2_2);
        }
        return new TracesSamplingDecision(Boolean.FALSE, null, Boolean.FALSE, null);
    }

    private boolean sample(Double aDouble) {
        return !(aDouble < this.random.nextDouble());
    }
}

