/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.IScope;
import io.sentry.ISentryClient;
import io.sentry.Scope;
import io.sentry.SentryClient;
import io.sentry.SentryOptions;
import io.sentry.util.Objects;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

final class Stack {
    private final Deque<StackItem> items = new LinkedBlockingDeque<StackItem>();
    private final ILogger logger;

    /*
     * WARNING - void declaration
     */
    public Stack(ILogger logger, StackItem rootStackItem) {
        void var2_2;
        void var1_1;
        this.logger = (ILogger)Objects.requireNonNull(var1_1, "logger is required");
        this.items.push((StackItem)Objects.requireNonNull(var2_2, "rootStackItem is required"));
    }

    public Stack(Stack stack) {
        this(stack.logger, new StackItem(stack.items.getLast()));
        Iterator<StackItem> iterator = stack.items.descendingIterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            StackItem stackItem = new StackItem(iterator.next());
            Stack stack2 = this;
            stack2.items.push(stackItem);
        }
    }

    final StackItem peek() {
        return this.items.peek();
    }

    static final class StackItem {
        private final SentryOptions options;
        private volatile ISentryClient client;
        private volatile IScope scope;

        /*
         * WARNING - void declaration
         */
        StackItem(SentryOptions options, SentryClient client, Scope scope) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.client = (ISentryClient)Objects.requireNonNull(var2_2, "ISentryClient is required.");
            this.scope = (IScope)Objects.requireNonNull(var3_3, "Scope is required.");
            this.options = (SentryOptions)Objects.requireNonNull(var1_1, "Options is required");
        }

        /*
         * WARNING - void declaration
         */
        StackItem(StackItem item) {
            void var1_1;
            this.options = item.options;
            this.client = item.client;
            this.scope = var1_1.scope.clone$314c5022();
        }

        public final ISentryClient getClient() {
            return this.client;
        }

        public final IScope getScope() {
            return this.scope;
        }
    }
}

