/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;

public final class ShutdownHookIntegration
implements Integration,
Closeable {
    private final Runtime runtime;
    private Thread thread;

    /*
     * WARNING - void declaration
     */
    private ShutdownHookIntegration(Runtime runtime) {
        void var1_1;
        this.runtime = (Runtime)Objects.requireNonNull(var1_1, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void register$32abd998(HubAdapter hub, SentryOptions options) {
        void var2_2;
        Objects.requireNonNull(hub, "Hub is required");
        Objects.requireNonNull(options, "SentryOptions is required");
        if (options.isEnableShutdownHook()) {
            void var1_1;
            this.thread = new Thread(() -> ShutdownHookIntegration.lambda$register$0((IHub)var1_1, options));
            ShutdownHookIntegration.handleShutdownInProgress(() -> {
                String string;
                this.runtime.addShutdownHook(this.thread);
                ((SentryOptions)((Object)string)).getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
                string = "ShutdownHook";
                SentryIntegrationPackageStorage.getInstance().addIntegration(string);
            });
            return;
        }
        var2_2.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
    }

    @Override
    public final void close() throws IOException {
        if (this.thread != null) {
            ShutdownHookIntegration.handleShutdownInProgress(() -> this.runtime.removeShutdownHook(this.thread));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void handleShutdownInProgress(Runnable runnable) {
        try {
            runnable.run();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            void var1_1;
            IllegalStateException e = illegalStateException;
            String message = illegalStateException.getMessage();
            if (message == null || !message.equals("Shutdown in progress") && !var1_1.equals("VM already shutting down")) {
                IllegalStateException illegalStateException2;
                throw illegalStateException2;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$register$0(IHub hub, SentryOptions options) {
        void var1_1;
        hub.flush(var1_1.getFlushTimeoutMillis());
    }
}

