/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryEvent;
import io.sentry.Session;
import io.sentry.clientreport.ClientReport;
import io.sentry.protocol.SentryTransaction;
import java.io.IOException;

public enum SentryItemType implements JsonSerializable
{
    Session("session"),
    Event("event"),
    UserFeedback("user_report"),
    Attachment("attachment"),
    Transaction("transaction"),
    Profile("profile"),
    ClientReport("client_report"),
    ReplayEvent("replay_event"),
    ReplayRecording("replay_recording"),
    ReplayVideo("replay_video"),
    CheckIn("check_in"),
    Statsd("statsd"),
    Feedback("feedback"),
    Unknown("__unknown__");

    private final String itemType;

    public static SentryItemType resolve(Object item) {
        Object object;
        if (item instanceof SentryEvent) {
            return Event;
        }
        if (item instanceof SentryTransaction) {
            return Transaction;
        }
        if (item instanceof Session) {
            return Session;
        }
        if (object instanceof ClientReport) {
            return ClientReport;
        }
        return Attachment;
    }

    /*
     * WARNING - void declaration
     */
    private SentryItemType(String itemType) {
        void var3_3;
        this.itemType = var3_3;
    }

    public final String getItemType() {
        return this.itemType;
    }

    public static SentryItemType valueOfLabel(String itemType) {
        for (SentryItemType sentryItemType : (SentryItemType[])$VALUES.clone()) {
            if (!sentryItemType.itemType.equals(itemType)) continue;
            return sentryItemType;
        }
        return Unknown;
    }

    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        writer.value$7c2ed8b3(this.itemType);
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryItemType> {
    }
}

