/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.TraceContext;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.internal.bind.util.ISO8601Utils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public final class SentryEnvelopeHeader
implements JsonSerializable {
    private final SentryId eventId;
    private final SdkVersion sdkVersion;
    private final TraceContext traceContext;
    private Date sentAt;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentryEnvelopeHeader(SentryId eventId, SdkVersion sdkVersion) {
        this((SentryId)var1_1, (SdkVersion)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SentryEnvelopeHeader(SentryId eventId, SdkVersion sdkVersion, TraceContext traceContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.eventId = var1_1;
        this.sdkVersion = var2_2;
        this.traceContext = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelopeHeader(SentryId eventId) {
        this((SentryId)var1_1, null);
        void var1_1;
    }

    public SentryEnvelopeHeader() {
        this(new SentryId());
    }

    public final SentryId getEventId() {
        return this.eventId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSentAt(Date sentAt) {
        void var1_1;
        this.sentAt = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        if (this.eventId != null) {
            writer.name$7c2ed8b3("event_id").value$74e4a76(logger, this.eventId);
        }
        if (this.sdkVersion != null) {
            writer.name$7c2ed8b3("sdk").value$74e4a76(logger, this.sdkVersion);
        }
        if (this.traceContext != null) {
            writer.name$7c2ed8b3("trace").value$74e4a76(logger, this.traceContext);
        }
        if (this.sentAt != null) {
            Date date = this.sentAt;
            writer.name$7c2ed8b3("sent_at").value$74e4a76(logger, ISO8601Utils.format(date, true));
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeHeader> {
    }
}

