/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ExternalOptions;
import io.sentry.Hint;
import io.sentry.Hub;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.IOptionsObserver;
import io.sentry.ISentryExecutorService;
import io.sentry.Integration;
import io.sentry.JavaMemoryCollector;
import io.sentry.NoOpHub;
import io.sentry.NoOpLogger;
import io.sentry.PreviousSessionFinalizer;
import io.sentry.SamplingContext;
import io.sentry.SentryAppStartProfilingOptions;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SystemOutLogger;
import io.sentry.TracesSampler;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.backpressure.BackpressureMonitor;
import io.sentry.cache.EnvelopeCache;
import io.sentry.config.PropertiesProviderFactory;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import io.sentry.internal.modules.CompositeModulesLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.ManifestModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.internal.modules.ResourcesModulesLoader;
import io.sentry.protocol.SentryId;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.DebugMetaPropertiesApplier;
import io.sentry.util.FileUtils;
import io.sentry.util.Platform;
import io.sentry.util.thread.IMainThreadChecker;
import io.sentry.util.thread.MainThreadChecker;
import io.sentry.util.thread.NoOpMainThreadChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class Sentry {
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    private static volatile IHub mainHub = NoOpHub.getInstance();
    private static volatile boolean globalHubMode = false;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final long classCreationTimestamp = System.currentTimeMillis();

    /*
     * WARNING - void declaration
     */
    public static IHub getCurrentHub() {
        void var0;
        if (globalHubMode) {
            return mainHub;
        }
        IHub hub = currentHub.get();
        if (hub == null || hub instanceof NoOpHub) {
            hub = mainHub.clone();
            currentHub.set(hub);
        }
        return var0;
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init(OptionsConfiguration<SentryOptions> optionsConfiguration) {
        boolean bl = false;
        OptionsConfiguration<SentryOptions> optionsConfiguration2 = optionsConfiguration;
        SentryOptions sentryOptions = new SentryOptions();
        Sentry.applyOptionsConfiguration(optionsConfiguration2, sentryOptions);
        Sentry.init(sentryOptions, false);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends SentryOptions> void applyOptionsConfiguration(OptionsConfiguration<T> optionsConfiguration, T options) {
        try {
            optionsConfiguration.configure(options);
            return;
        }
        catch (Throwable t) {
            void var0_1;
            void var1_2;
            var1_2.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", (Throwable)var0_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void init(SentryOptions options, boolean globalHubMode) {
        SentryOptions sentryOptions;
        void var1_1;
        if (Sentry.isEnabled()) {
            options.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
        }
        if (!Sentry.initConfigurations(options)) {
            return;
        }
        try {
            options.getExecutorService().submit(() -> {
                SentryOptions sentryOptions = options;
                sentryOptions.getSerializer();
                sentryOptions.getParsedDsn();
                sentryOptions.getEnvelopeReader();
                sentryOptions.getDateProvider();
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            options.getLogger().log(SentryLevel.DEBUG, "Failed to call the executor. Lazy fields will not be loaded. Did you call Sentry.close()?", rejectedExecutionException);
        }
        options.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubMode));
        Sentry.globalHubMode = var1_1;
        IHub object2 = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        object2.close(true);
        if (options.getExecutorService().isClosed()) {
            options.setExecutorService$7056313d(new SentryExecutorService());
        }
        for (Integration throwable : options.getIntegrations()) {
            throwable.register$32abd998(HubAdapter.getInstance(), options);
        }
        Object object3 = options;
        try {
            ((SentryOptions)object3).getExecutorService().submit(() -> Sentry.lambda$notifyOptionsObservers$4((SentryOptions)object3));
        }
        catch (Throwable throwable) {
            ((SentryOptions)object3).getLogger().log(SentryLevel.DEBUG, "Failed to notify options observers.", throwable);
        }
        HubAdapter hubAdapter = HubAdapter.getInstance();
        object3 = options;
        try {
            ((SentryOptions)object3).getExecutorService().submit(new PreviousSessionFinalizer((SentryOptions)object3, hubAdapter));
        }
        catch (Throwable throwable) {
            ((SentryOptions)object3).getLogger().log(SentryLevel.DEBUG, "Failed to finalize previous session.", throwable);
        }
        SentryOptions sentryOptions2 = sentryOptions;
        ISentryExecutorService iSentryExecutorService = sentryOptions2.getExecutorService();
        object3 = sentryOptions2;
        try {
            iSentryExecutorService.submit(() -> Sentry.lambda$handleAppStartProfilingConfig$3((SentryOptions)object3));
            return;
        }
        catch (Throwable throwable) {
            ((SentryOptions)object3).getLogger().log(SentryLevel.ERROR, "Failed to call the executor. App start profiling config will not be changed. Did you call Sentry.close()?", throwable);
            return;
        }
    }

    private static boolean initConfigurations(SentryOptions options) {
        IMainThreadChecker iMainThreadChecker;
        if (options.isEnableExternalConfiguration()) {
            options.merge(ExternalOptions.from(PropertiesProviderFactory.create$2ec98a84(), options.getLogger()));
        }
        String dsn = options.getDsn();
        if (!options.isEnabled() || dsn != null && dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        if (dsn == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string or set enabled to false in SentryOptions to disable SDK.");
        }
        options.getParsedDsn();
        Object logger = options.getLogger();
        if (options.isDebug() && logger instanceof NoOpLogger) {
            options.setLogger$1c54ab9a(new SystemOutLogger());
            logger = options.getLogger();
        }
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        Object object = options;
        object = ((SentryOptions)object).getCacheDirPath();
        String outboxPath = object == null ? null : new File((String)object, "outbox").getAbsolutePath();
        if (outboxPath != null) {
            logger = new File((String)object);
            ((File)logger).mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        Object cacheDirPath = options.getCacheDirPath();
        if (cacheDirPath != null) {
            cacheDirPath = new File((String)cacheDirPath);
            ((File)cacheDirPath).mkdirs();
            cacheDirPath = options.getEnvelopeDiskCache();
            if (cacheDirPath instanceof NoOpEnvelopeCache) {
                SentryOptions sentryOptions = options;
                sentryOptions.setEnvelopeDiskCache(EnvelopeCache.create(sentryOptions));
            }
        }
        String profilingTracesDirPath = options.getProfilingTracesDirPath();
        if (options.isProfilingEnabled() && profilingTracesDirPath != null) {
            File profilingTracesDir = new File(profilingTracesDirPath);
            profilingTracesDir.mkdirs();
            try {
                options.getExecutorService().submit(() -> {
                    File[] fileArray;
                    File[] oldTracesDirContent = profilingTracesDir.listFiles();
                    if (oldTracesDirContent == null) {
                        return;
                    }
                    for (File f : fileArray) {
                        void var3_3;
                        if (f.lastModified() >= classCreationTimestamp - TimeUnit.MINUTES.toMillis(5L)) continue;
                        FileUtils.deleteRecursively((File)var3_3);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Old profiles will not be deleted. Did you call Sentry.close()?", e);
            }
        }
        IModulesLoader modulesLoader = options.getModulesLoader();
        if (!options.isSendModules()) {
            options.setModulesLoader(NoOpModulesLoader.getInstance());
        } else if (modulesLoader instanceof NoOpModulesLoader) {
            options.setModulesLoader(new CompositeModulesLoader(Arrays.asList(new ManifestModulesLoader(options.getLogger()), new ResourcesModulesLoader(options.getLogger())), options.getLogger()));
        }
        if (options.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options.setDebugMetaLoader$36e8bc88(new ResourcesDebugMetaLoader(options.getLogger()));
        }
        List<Properties> propertiesList = options.getDebugMetaLoader().loadDebugMeta();
        DebugMetaPropertiesApplier.applyToOptions(options, (List<Properties>)((Object)iMainThreadChecker));
        iMainThreadChecker = options.getMainThreadChecker();
        if (iMainThreadChecker instanceof NoOpMainThreadChecker) {
            options.setMainThreadChecker$28b81ffc(MainThreadChecker.getInstance());
        }
        if (options.getPerformanceCollectors().isEmpty()) {
            options.addPerformanceCollector$71cb9fb3(new JavaMemoryCollector());
        }
        if (options.isEnableBackpressureHandling() && Platform.isJvm()) {
            SentryOptions sentryOptions;
            options.setBackpressureMonitor$434665d5(new BackpressureMonitor(options, HubAdapter.getInstance()));
            sentryOptions.getBackpressureMonitor().start();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void close() {
        void var0;
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        currentHub.remove();
        var0.close(false);
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureEvent(SentryEvent event, Hint hint) {
        void var1_1;
        SentryEvent sentryEvent;
        return Sentry.getCurrentHub().captureEvent(sentryEvent, (Hint)var1_1);
    }

    public static SentryId captureException(Throwable throwable) {
        Throwable throwable2;
        return Sentry.getCurrentHub().captureException(throwable2);
    }

    /*
     * WARNING - void declaration
     */
    public static SentryId captureException(Throwable throwable, Hint hint) {
        void var1_1;
        Throwable throwable2;
        return Sentry.getCurrentHub().captureException(throwable2, (Hint)var1_1);
    }

    public static boolean isHealthy() {
        return Sentry.getCurrentHub().isHealthy();
    }

    public static void flush(long timeoutMillis) {
        long l;
        Sentry.getCurrentHub().flush(l);
    }

    private static /* synthetic */ void lambda$notifyOptionsObservers$4(SentryOptions options) {
        Iterator<IOptionsObserver> iterator = options.getOptionsObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            options.getRelease();
            options.getProguardUuid();
            options.getSdkVersion();
            options.getDist();
            options.getEnvironment();
            options.getTags();
            options.getExperimental().getSessionReplay().getOnErrorSampleRate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$handleAppStartProfilingConfig$3(SentryOptions options) {
        String cacheDirPath = options.getCacheDirPathWithoutDsn();
        if (cacheDirPath != null) {
            File appStartProfilingConfigFile = new File(cacheDirPath, "app_start_profiling_config");
            try {
                FileOutputStream outputStream;
                block14: {
                    FileUtils.deleteRecursively(appStartProfilingConfigFile);
                    if (!options.isEnableAppStartProfiling()) {
                        return;
                    }
                    if (!options.isTracingEnabled()) {
                        options.getLogger().log(SentryLevel.INFO, "Tracing is disabled and app start profiling will not start.", new Object[0]);
                        return;
                    }
                    if (appStartProfilingConfigFile.createNewFile()) {
                        SentryOptions sentryOptions = options;
                        Object object = new TransactionContext("app.launch", "profile");
                        ((TransactionContext)object).setForNextAppStart(true);
                        object = new SamplingContext((TransactionContext)object, null);
                        TracesSamplingDecision appStartSamplingDecision = new TracesSampler(sentryOptions).sample((SamplingContext)object);
                        SentryAppStartProfilingOptions appStartProfilingOptions2 = new SentryAppStartProfilingOptions(options, appStartSamplingDecision);
                        outputStream = new FileOutputStream(appStartProfilingConfigFile);
                        try {
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));
                            try {
                                options.getSerializer().serialize(appStartProfilingOptions2, writer);
                            }
                            catch (Throwable appStartProfilingOptions2) {
                                try {
                                    ((Writer)object).close();
                                }
                                catch (Throwable throwable) {
                                    appStartProfilingOptions2.addSuppressed(throwable);
                                }
                                throw appStartProfilingOptions2;
                            }
                            ((Writer)writer).close();
                            break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                void var1_1;
                                var1_1.close();
                            }
                            catch (Throwable appStartProfilingOptions2) {
                                throwable.addSuppressed(appStartProfilingOptions2);
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                ((OutputStream)outputStream).close();
            }
            catch (Throwable e) {
                void var2_5;
                SentryOptions sentryOptions;
                sentryOptions.getLogger().log(SentryLevel.ERROR, "Unable to create app start profiling config file. ", (Throwable)var2_5);
            }
        }
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(T var1);
    }
}

