/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Attachment;
import io.sentry.Breadcrumb;
import io.sentry.CircularFifoQueue;
import io.sentry.EventProcessor;
import io.sentry.IScope;
import io.sentry.IScopeObserver;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.PropagationContext;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.Span;
import io.sentry.SynchronizedQueue;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Request;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Scope
implements IScope {
    private SentryLevel level;
    private ITransaction transaction;
    private String transactionName;
    private User user;
    private String screen;
    private Request request;
    private List<String> fingerprint = new ArrayList<String>();
    private final Queue<Breadcrumb> breadcrumbs;
    private Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private Map<String, Object> extra = new ConcurrentHashMap<String, Object>();
    private List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    private final SentryOptions options;
    private volatile Session session;
    private final Object sessionLock = new Object();
    private final Object transactionLock = new Object();
    private final Object propagationContextLock = new Object();
    private Contexts contexts = new Contexts();
    private List<Attachment> attachments = new CopyOnWriteArrayList<Attachment>();
    private PropagationContext propagationContext;
    private SentryId replayId = SentryId.EMPTY_ID;

    /*
     * WARNING - void declaration
     */
    public Scope(SentryOptions options) {
        void var1_1;
        this.options = (SentryOptions)Objects.requireNonNull(var1_1, "SentryOptions is required.");
        this.breadcrumbs = Scope.createBreadcrumbsList$44aca1ce((int)this.options.getMaxBreadcrumbs());
        this.propagationContext = new PropagationContext();
    }

    /*
     * WARNING - void declaration
     */
    private Scope(Scope scope) {
        void var1_1;
        void var3_3;
        this.transaction = scope.transaction;
        this.transactionName = scope.transactionName;
        this.session = scope.session;
        this.options = scope.options;
        this.level = scope.level;
        User userRef = scope.user;
        this.user = userRef != null ? new User(userRef) : null;
        this.screen = scope.screen;
        this.replayId = scope.replayId;
        Request requestRef = scope.request;
        this.request = requestRef != null ? new Request(requestRef) : null;
        this.fingerprint = new ArrayList<String>(scope.fingerprint);
        this.eventProcessors = new CopyOnWriteArrayList<EventProcessor>(scope.eventProcessors);
        Breadcrumb[] breadcrumbsRef = scope.breadcrumbs.toArray(new Breadcrumb[0]);
        SynchronizedQueue breadcrumbsClone = Scope.createBreadcrumbsList$44aca1ce((int)scope.options.getMaxBreadcrumbs());
        for (Breadcrumb breadcrumb : breadcrumbsRef) {
            Breadcrumb breadcrumbClone = new Breadcrumb(breadcrumb);
            breadcrumbsClone.add(breadcrumbClone);
        }
        this.breadcrumbs = var3_3;
        Map<String, String> tagsRef = scope.tags;
        ConcurrentHashMap<String, String> tagsClone = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : tagsRef.entrySet()) {
            if (entry == null) continue;
            tagsClone.put(entry.getKey(), entry.getValue());
        }
        this.tags = tagsClone;
        Map<String, Object> extraRef = scope.extra;
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> item : extraRef.entrySet()) {
            void var2_2;
            if (item == null) continue;
            concurrentHashMap.put(item.getKey(), var2_2.getValue());
        }
        this.extra = concurrentHashMap;
        this.contexts = new Contexts(scope.contexts);
        this.attachments = new CopyOnWriteArrayList<Attachment>(scope.attachments);
        this.propagationContext = new PropagationContext(var1_1.propagationContext);
    }

    @Override
    public final SentryLevel getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getTransactionName() {
        ITransaction tx = this.transaction;
        if (tx != null) {
            void var1_1;
            return var1_1.getName();
        }
        return this.transactionName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ISpan getSpan() {
        void var1_1;
        Span span;
        ITransaction tx = this.transaction;
        if (tx != null && (span = tx.getLatestActiveSpan()) != null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    @Override
    public final User getUser() {
        return this.user;
    }

    @Override
    public final SentryId getReplayId() {
        return this.replayId;
    }

    @Override
    public final Request getRequest() {
        return this.request;
    }

    @Override
    public final List<String> getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public final Queue<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public final void clearTransaction() {
        Iterator<IScopeObserver> iterator = this.transactionLock;
        synchronized (iterator) {
            this.transaction = null;
        }
        this.transactionName = null;
        iterator = this.options.getScopeObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    @Override
    public final ITransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public final void clear() {
        this.level = null;
        this.user = null;
        this.request = null;
        this.screen = null;
        this.fingerprint.clear();
        Scope scope = this;
        scope.breadcrumbs.clear();
        Iterator<IScopeObserver> iterator = scope.options.getScopeObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            Queue<Breadcrumb> cfr_ignored_0 = scope.breadcrumbs;
        }
        this.tags.clear();
        this.extra.clear();
        this.eventProcessors.clear();
        this.clearTransaction();
        scope = this;
        scope.attachments.clear();
    }

    @Override
    public final Map<String, String> getTags() {
        return CollectionUtils.newConcurrentHashMap(this.tags);
    }

    @Override
    public final Map<String, Object> getExtras() {
        return this.extra;
    }

    @Override
    public final Contexts getContexts() {
        return this.contexts;
    }

    @Override
    public final List<Attachment> getAttachments() {
        return new CopyOnWriteArrayList<Attachment>(this.attachments);
    }

    private static Queue<Breadcrumb> createBreadcrumbsList$44aca1ce(int maxBreadcrumb) {
        int n;
        return SynchronizedQueue.synchronizedQueue$1b208cca(new CircularFifoQueue(n));
    }

    @Override
    public final List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Session withSession(IWithSession sessionCallback) {
        void var2_3;
        Session cloneSession = null;
        Object object = this.sessionLock;
        synchronized (object) {
            void var1_1;
            var1_1.accept(this.session);
            if (this.session != null) {
                cloneSession = this.session.clone();
            }
        }
        return var2_3;
    }

    @Override
    public final PropagationContext getPropagationContext() {
        return this.propagationContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PropagationContext withPropagationContext(IWithPropagationContext callback) {
        Object object = this.propagationContextLock;
        synchronized (object) {
            void var1_1;
            var1_1.accept(this.propagationContext);
            return new PropagationContext(this.propagationContext);
        }
    }

    @Override
    public final Scope clone$314c5022() {
        return new Scope(this);
    }

    static interface IWithSession {
        public void accept(Session var1);
    }

    public static interface IWithPropagationContext {
        public void accept(PropagationContext var1);
    }
}

