/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.NoOpTransaction;
import io.sentry.ObjectWriter;
import io.sentry.ProfilingTransactionData;
import io.sentry.profilemeasurements.ProfileMeasurement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;

public final class ProfilingTraceData
implements JsonSerializable {
    private final File traceFile;
    private final Callable<List<Integer>> deviceCpuFrequenciesReader;
    private int androidApiLevel;
    private String deviceLocale;
    private String deviceManufacturer;
    private String deviceModel;
    private String deviceOsBuildNumber;
    private String deviceOsName;
    private String deviceOsVersion;
    private boolean deviceIsEmulator;
    private String cpuArchitecture;
    private List<Integer> deviceCpuFrequencies = new ArrayList<Integer>();
    private String devicePhysicalMemoryBytes;
    private String platform;
    private String buildId;
    private List<ProfilingTransactionData> transactions;
    private String transactionName;
    private String durationNs;
    private String versionCode;
    private String release;
    private String transactionId;
    private String traceId;
    private String profileId;
    private String environment;
    private String truncationReason;
    private Date timestamp;
    private final Map<String, ProfileMeasurement> measurementsMap;
    private String sampledProfile = null;
    private Map<String, Object> unknown;

    private ProfilingTraceData() {
        this(new File("dummy"), NoOpTransaction.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    private ProfilingTraceData(File traceFile, NoOpTransaction transaction) {
        this((File)var1_1, DateUtils.getCurrentDateTime(), new ArrayList<ProfilingTransactionData>(), transaction.getName(), transaction.getEventId().toString(), var2_2.getSpanContext().getTraceId().toString(), "0", 0, "", () -> new ArrayList(), null, null, null, null, null, null, null, null, "normal", new HashMap<String, ProfileMeasurement>());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ProfilingTraceData(File traceFile, Date profileStartTimestamp, List<ProfilingTransactionData> transactions, String transactionName, String transactionId, String traceId, String durationNanos, int sdkInt, String cpuArchitecture, Callable<List<Integer>> deviceCpuFrequenciesReader, String deviceManufacturer, String deviceModel, String deviceOsVersion, Boolean deviceIsEmulator, String devicePhysicalMemoryBytes, String buildId, String release, String environment, String truncationReason, Map<String, ProfileMeasurement> measurementsMap) {
        void var3_3;
        void var2_2;
        ProfilingTraceData profilingTraceData;
        this.traceFile = profilingTraceData;
        this.timestamp = var2_2;
        this.cpuArchitecture = cpuArchitecture;
        this.deviceCpuFrequenciesReader = deviceCpuFrequenciesReader;
        this.androidApiLevel = 0;
        this.deviceLocale = Locale.getDefault().toString();
        this.deviceManufacturer = "";
        this.deviceModel = "";
        this.deviceOsVersion = "";
        this.deviceIsEmulator = false;
        this.devicePhysicalMemoryBytes = "0";
        this.deviceOsBuildNumber = "";
        this.deviceOsName = "android";
        this.platform = "android";
        this.buildId = "";
        this.transactions = var3_3;
        this.transactionName = transactionName.isEmpty() ? "unknown" : transactionName;
        this.durationNs = durationNanos;
        this.versionCode = "";
        this.release = "";
        this.transactionId = transactionId;
        this.traceId = traceId;
        this.profileId = UUID.randomUUID().toString();
        this.environment = "production";
        this.truncationReason = truncationReason;
        profilingTraceData = this;
        if (!(profilingTraceData.truncationReason.equals("normal") || profilingTraceData.truncationReason.equals("timeout") || profilingTraceData.truncationReason.equals("backgrounded"))) {
            this.truncationReason = "normal";
        }
        this.measurementsMap = measurementsMap;
    }

    public final File getTraceFile() {
        return this.traceFile;
    }

    public final String getProfileId() {
        return this.profileId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSampledProfile(String sampledProfile) {
        void var1_1;
        this.sampledProfile = var1_1;
    }

    public final void readDeviceCpuFrequencies() {
        try {
            this.deviceCpuFrequencies = this.deviceCpuFrequenciesReader.call();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        writer.name$7c2ed8b3("android_api_level").value$74e4a76(logger, this.androidApiLevel);
        writer.name$7c2ed8b3("device_locale").value$74e4a76(logger, this.deviceLocale);
        writer.name$7c2ed8b3("device_manufacturer").value$7c2ed8b3(this.deviceManufacturer);
        writer.name$7c2ed8b3("device_model").value$7c2ed8b3(this.deviceModel);
        writer.name$7c2ed8b3("device_os_build_number").value$7c2ed8b3(this.deviceOsBuildNumber);
        writer.name$7c2ed8b3("device_os_name").value$7c2ed8b3(this.deviceOsName);
        writer.name$7c2ed8b3("device_os_version").value$7c2ed8b3(this.deviceOsVersion);
        writer.name$7c2ed8b3("device_is_emulator").value$202d34d(this.deviceIsEmulator);
        writer.name$7c2ed8b3("architecture").value$74e4a76(logger, this.cpuArchitecture);
        writer.name$7c2ed8b3("device_cpu_frequencies").value$74e4a76(logger, this.deviceCpuFrequencies);
        writer.name$7c2ed8b3("device_physical_memory_bytes").value$7c2ed8b3(this.devicePhysicalMemoryBytes);
        writer.name$7c2ed8b3("platform").value$7c2ed8b3(this.platform);
        writer.name$7c2ed8b3("build_id").value$7c2ed8b3(this.buildId);
        writer.name$7c2ed8b3("transaction_name").value$7c2ed8b3(this.transactionName);
        writer.name$7c2ed8b3("duration_ns").value$7c2ed8b3(this.durationNs);
        writer.name$7c2ed8b3("version_name").value$7c2ed8b3(this.release);
        writer.name$7c2ed8b3("version_code").value$7c2ed8b3(this.versionCode);
        if (!this.transactions.isEmpty()) {
            writer.name$7c2ed8b3("transactions").value$74e4a76(logger, this.transactions);
        }
        writer.name$7c2ed8b3("transaction_id").value$7c2ed8b3(this.transactionId);
        writer.name$7c2ed8b3("trace_id").value$7c2ed8b3(this.traceId);
        writer.name$7c2ed8b3("profile_id").value$7c2ed8b3(this.profileId);
        writer.name$7c2ed8b3("environment").value$7c2ed8b3(this.environment);
        writer.name$7c2ed8b3("truncation_reason").value$7c2ed8b3(this.truncationReason);
        if (this.sampledProfile != null) {
            writer.name$7c2ed8b3("sampled_profile").value$7c2ed8b3(this.sampledProfile);
        }
        writer.name$7c2ed8b3("measurements").value$74e4a76(logger, this.measurementsMap);
        writer.name$7c2ed8b3("timestamp").value$74e4a76(logger, this.timestamp);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name$7c2ed8b3(key);
                writer.value$74e4a76(logger, value);
            }
        }
        var1_1.endObject$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /* synthetic */ ProfilingTraceData(byte by) {
        this();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$102(ProfilingTraceData x0, int x1) {
        void var1_1;
        x0.androidApiLevel = var1_1;
        return x0.androidApiLevel;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceLocale = var1_1;
        return x0.deviceLocale;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceManufacturer = var1_1;
        return x0.deviceManufacturer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceModel = var1_1;
        return x0.deviceModel;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceOsBuildNumber = var1_1;
        return x0.deviceOsBuildNumber;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$602(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceOsName = var1_1;
        return x0.deviceOsName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$702(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.deviceOsVersion = var1_1;
        return x0.deviceOsVersion;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$802(ProfilingTraceData x0, boolean x1) {
        void var1_1;
        x0.deviceIsEmulator = var1_1;
        return x0.deviceIsEmulator;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$902(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.cpuArchitecture = var1_1;
        return x0.cpuArchitecture;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$1002(ProfilingTraceData x0, List x1) {
        void var1_1;
        x0.deviceCpuFrequencies = var1_1;
        return x0.deviceCpuFrequencies;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1102(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.devicePhysicalMemoryBytes = var1_1;
        return x0.devicePhysicalMemoryBytes;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1202(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.platform = var1_1;
        return x0.platform;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1302(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.buildId = var1_1;
        return x0.buildId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1402(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.transactionName = var1_1;
        return x0.transactionName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1502(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.durationNs = var1_1;
        return x0.durationNs;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1602(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.versionCode = var1_1;
        return x0.versionCode;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1702(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.release = var1_1;
        return x0.release;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1902(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.transactionId = var1_1;
        return x0.transactionId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2002(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.traceId = var1_1;
        return x0.traceId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2102(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.profileId = var1_1;
        return x0.profileId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2202(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.environment = var1_1;
        return x0.environment;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2302(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.truncationReason = var1_1;
        return x0.truncationReason;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Date access$2502(ProfilingTraceData x0, Date x1) {
        void var1_1;
        x0.timestamp = var1_1;
        return x0.timestamp;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2602(ProfilingTraceData x0, String x1) {
        void var1_1;
        x0.sampledProfile = var1_1;
        return x0.sampledProfile;
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfilingTraceData> {
    }
}

