/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonReflectionObjectSerializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.util.JsonSerializationUtils;
import io.sentry.vendor.gson.internal.bind.util.ISO8601Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class JsonObjectSerializer {
    public final JsonReflectionObjectSerializer jsonReflectionObjectSerializer;

    /*
     * WARNING - void declaration
     */
    public JsonObjectSerializer(int maxDepth) {
        void var1_1;
        this.jsonReflectionObjectSerializer = new JsonReflectionObjectSerializer((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(ObjectWriter writer, ILogger logger, Object object22) throws IOException {
        Object object22;
        if (object22 == null) {
            writer.nullValue$4f1a06e9();
            return;
        }
        if (object22 instanceof Character) {
            writer.value$7c2ed8b3(Character.toString(((Character)object22).charValue()));
            return;
        }
        if (object22 instanceof String) {
            writer.value$7c2ed8b3((String)object22);
            return;
        }
        if (object22 instanceof Boolean) {
            writer.value$202d34d((Boolean)object22);
            return;
        }
        if (object22 instanceof Number) {
            writer.value$35a3737b((Number)object22);
            return;
        }
        if (object22 instanceof Date) {
            object22 = (Date)object22;
            try {
                writer.value$7c2ed8b3(ISO8601Utils.format((Date)object22, true));
            }
            catch (Exception object22) {
                logger.log(SentryLevel.ERROR, "Error when serializing Date", object22);
                writer.nullValue$4f1a06e9();
                return;
            }
        } else if (object22 instanceof TimeZone) {
            object22 = (TimeZone)object22;
            try {
                writer.value$7c2ed8b3(((TimeZone)object22).getID());
            }
            catch (Exception object22) {
                logger.log(SentryLevel.ERROR, "Error when serializing TimeZone", object22);
                writer.nullValue$4f1a06e9();
                return;
            }
        } else {
            if (object22 instanceof JsonSerializable) {
                ((JsonSerializable)object22).serialize(writer, logger);
                return;
            }
            if (object22 instanceof Collection) {
                this.serializeCollection(writer, logger, (Collection)object22);
                return;
            }
            if (object22.getClass().isArray()) {
                this.serializeCollection(writer, logger, Arrays.asList((Object[])object22));
                return;
            }
            if (object22 instanceof Map) {
                this.serializeMap(writer, logger, (Map)object22);
                return;
            }
            if (object22 instanceof Locale) {
                writer.value$7c2ed8b3(object22.toString());
                return;
            }
            if (object22 instanceof AtomicIntegerArray) {
                this.serializeCollection(writer, logger, JsonSerializationUtils.atomicIntegerArrayToList((AtomicIntegerArray)object22));
                return;
            }
            if (object22 instanceof AtomicBoolean) {
                writer.value$202d34d(((AtomicBoolean)object22).get());
                return;
            }
            if (object22 instanceof URI) {
                writer.value$7c2ed8b3(object22.toString());
                return;
            }
            if (object22 instanceof InetAddress) {
                writer.value$7c2ed8b3(object22.toString());
                return;
            }
            if (object22 instanceof UUID) {
                writer.value$7c2ed8b3(object22.toString());
                return;
            }
            if (object22 instanceof Currency) {
                writer.value$7c2ed8b3(object22.toString());
                return;
            }
            if (object22 instanceof Calendar) {
                this.serializeMap(writer, logger, JsonSerializationUtils.calendarToMap((Calendar)object22));
                return;
            }
            if (object22.getClass().isEnum()) {
                writer.value$7c2ed8b3(object22.toString());
                return;
            }
            try {
                Object serializableObject = this.jsonReflectionObjectSerializer.serialize(object22, logger);
                this.serialize(writer, logger, serializableObject);
                return;
            }
            catch (Exception exception) {
                void var1_1;
                void var3_6;
                void var2_2;
                var2_2.log(SentryLevel.ERROR, "Failed serializing unknown object.", (Throwable)var3_6);
                var1_1.value$7c2ed8b3("[OBJECT]");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void serializeCollection(ObjectWriter writer, ILogger logger, Collection<?> collection) throws IOException {
        void var1_1;
        Iterator iterator;
        writer.beginArray$4f1a06e9();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.serialize(writer, logger, object);
        }
        var1_1.endArray$4f1a06e9();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeMap(ObjectWriter writer, ILogger logger, Map<?, ?> map) throws IOException {
        void var1_1;
        writer.beginObject$4f1a06e9();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) continue;
            writer.name$7c2ed8b3((String)key);
            this.serialize(writer, logger, map.get(key));
        }
        var1_1.endObject$4f1a06e9();
    }
}

