/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.JsonObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class JsonObjectDeserializer {
    private final ArrayList<Token> tokens = new ArrayList();

    /*
     * WARNING - void declaration
     */
    public final Object deserialize(JsonObjectReader reader) throws IOException {
        this.parse(reader);
        Token root = this.getCurrentToken();
        if (root != null) {
            void var1_1;
            return var1_1.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void parse(JsonObjectReader reader) throws IOException {
        void var2_2;
        do {
            boolean done = false;
            switch (reader.peek()) {
                case BEGIN_ARRAY: {
                    reader.beginArray();
                    this.pushCurrentToken(new TokenArray(0));
                    break;
                }
                case END_ARRAY: {
                    reader.endArray();
                    done = this.handleArrayOrMapEnd();
                    break;
                }
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    this.pushCurrentToken(new TokenMap(0));
                    break;
                }
                case END_OBJECT: {
                    reader.endObject();
                    done = this.handleArrayOrMapEnd();
                    break;
                }
                case NAME: {
                    this.pushCurrentToken(new TokenName(reader.nextName()));
                    break;
                }
                case STRING: {
                    done = this.handlePrimitive(() -> reader.nextString());
                    break;
                }
                case NUMBER: {
                    JsonObjectDeserializer jsonObjectDeserializer = this;
                    done = jsonObjectDeserializer.handlePrimitive(() -> JsonObjectDeserializer.nextNumber(reader));
                    break;
                }
                case BOOLEAN: {
                    done = this.handlePrimitive(() -> reader.nextBoolean());
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    done = this.handlePrimitive(() -> null);
                    break;
                }
                case END_DOCUMENT: {
                    done = true;
                }
            }
        } while (var2_2 == false);
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleArrayOrMapEnd() {
        if (this.hasOneToken()) {
            return true;
        }
        Token arrayOrMapToken = this.getCurrentToken();
        this.popCurrentToken();
        if (this.getCurrentToken() instanceof TokenName) {
            TokenName tokenName = (TokenName)this.getCurrentToken();
            this.popCurrentToken();
            TokenMap tokenMap = (TokenMap)this.getCurrentToken();
            if (tokenName != null && arrayOrMapToken != null && tokenMap != null) {
                void var3_4;
                var3_4.value.put(tokenName.value, arrayOrMapToken.getValue());
            }
        } else if (this.getCurrentToken() instanceof TokenArray) {
            TokenArray tokenArray = (TokenArray)this.getCurrentToken();
            if (arrayOrMapToken != null && tokenArray != null) {
                void var1_1;
                void var2_3;
                var2_3.value.add(var1_1.getValue());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handlePrimitive(NextValue callback) throws IOException {
        Object primitive = callback.nextValue();
        if (this.getCurrentToken() == null && primitive != null) {
            this.pushCurrentToken(new TokenPrimitive(primitive));
            return true;
        }
        if (this.getCurrentToken() instanceof TokenName) {
            void var2_2;
            TokenName tokenNameNumber = (TokenName)this.getCurrentToken();
            this.popCurrentToken();
            TokenMap tokenMap = (TokenMap)this.getCurrentToken();
            tokenMap.value.put(var2_2.value, primitive);
        } else if (this.getCurrentToken() instanceof TokenArray) {
            void var1_1;
            TokenArray tokenArray = (TokenArray)this.getCurrentToken();
            tokenArray.value.add(var1_1);
        }
        return false;
    }

    private static Object nextNumber(JsonObjectReader reader) throws IOException {
        try {
            return reader.nextInt();
        }
        catch (Exception exception) {
            try {
                return reader.nextDouble();
            }
            catch (Exception exception2) {
                JsonObjectReader jsonObjectReader;
                return jsonObjectReader.nextLong();
            }
        }
    }

    private Token getCurrentToken() {
        if (this.tokens.isEmpty()) {
            return null;
        }
        return this.tokens.get(this.tokens.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private void pushCurrentToken(Token token) {
        void var1_1;
        this.tokens.add((Token)var1_1);
    }

    private void popCurrentToken() {
        if (this.tokens.isEmpty()) {
            return;
        }
        this.tokens.remove(this.tokens.size() - 1);
    }

    private boolean hasOneToken() {
        return this.tokens.size() == 1;
    }

    private static interface Token {
        public Object getValue();
    }

    private static final class TokenArray
    implements Token {
        final ArrayList<Object> value = new ArrayList();

        private TokenArray() {
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        /* synthetic */ TokenArray(byte by) {
            this();
        }
    }

    private static final class TokenMap
    implements Token {
        final HashMap<String, Object> value = new HashMap();

        private TokenMap() {
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        /* synthetic */ TokenMap(byte by) {
            this();
        }
    }

    private static final class TokenName
    implements Token {
        final String value;

        /*
         * WARNING - void declaration
         */
        TokenName(String value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }
    }

    private static interface NextValue {
        public Object nextValue() throws IOException;
    }

    private static final class TokenPrimitive
    implements Token {
        final Object value;

        /*
         * WARNING - void declaration
         */
        TokenPrimitive(Object value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }
    }
}

