/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.IEnvelopeReader;
import io.sentry.ISerializer;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEnvelopeItemHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public final class EnvelopeReader
implements IEnvelopeReader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ISerializer serializer;

    /*
     * WARNING - void declaration
     */
    public EnvelopeReader(ISerializer serializer) {
        void var1_1;
        this.serializer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEnvelope read(InputStream stream) throws IOException {
        byte[] buffer = new byte[1024];
        int streamOffset = 0;
        int envelopeEndHeaderOffset = -1;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            void var3_13;
            void var1_1;
            int currentLength;
            while ((currentLength = stream.read(buffer)) > 0) {
                for (int i = 0; envelopeEndHeaderOffset == -1 && i < currentLength; ++i) {
                    if (buffer[i] != 10) continue;
                    envelopeEndHeaderOffset = streamOffset + i;
                    break;
                }
                outputStream.write(buffer, 0, currentLength);
                streamOffset += currentLength;
            }
            byte[] envelopeBytes = outputStream.toByteArray();
            if (envelopeBytes.length == 0) {
                throw new IllegalArgumentException("Empty stream.");
            }
            if (envelopeEndHeaderOffset == -1) {
                throw new IllegalArgumentException("Envelope contains no header.");
            }
            SentryEnvelopeHeader header = this.deserializeEnvelopeHeader(envelopeBytes, 0, envelopeEndHeaderOffset);
            if (header == null) {
                throw new IllegalArgumentException("Envelope header is null.");
            }
            int itemHeaderStartOffset = envelopeEndHeaderOffset + 1;
            ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
            while (true) {
                void var2_4;
                int lineBreakIndex = -1;
                for (int i = itemHeaderStartOffset; i < envelopeBytes.length; ++i) {
                    if (envelopeBytes[i] != 10) continue;
                    lineBreakIndex = i;
                    break;
                }
                if (lineBreakIndex == -1) {
                    throw new IllegalArgumentException("Invalid envelope. Item at index '" + items.size() + "'. has no header delimiter.");
                }
                SentryEnvelopeItemHeader itemHeader = this.deserializeEnvelopeItemHeader(envelopeBytes, itemHeaderStartOffset, lineBreakIndex - itemHeaderStartOffset);
                if (itemHeader == null || itemHeader.getLength() <= 0) {
                    throw new IllegalArgumentException("Item header at index '" + items.size() + "' is null or empty.");
                }
                int payloadEndOffsetExclusive = lineBreakIndex + itemHeader.getLength() + 1;
                if (payloadEndOffsetExclusive > envelopeBytes.length) {
                    throw new IllegalArgumentException("Invalid length for item at index '" + items.size() + "'. Item is '" + payloadEndOffsetExclusive + "' bytes. There are '" + envelopeBytes.length + "' in the buffer.");
                }
                byte[] envelopeItemBytes = Arrays.copyOfRange(envelopeBytes, lineBreakIndex + 1, payloadEndOffsetExclusive);
                SentryEnvelopeItem item = new SentryEnvelopeItem(itemHeader, envelopeItemBytes);
                items.add(item);
                if (payloadEndOffsetExclusive == envelopeBytes.length) break;
                if (payloadEndOffsetExclusive + 1 == envelopeBytes.length) {
                    if (envelopeBytes[payloadEndOffsetExclusive] == 10) break;
                    throw new IllegalArgumentException("Envelope has invalid data following an item.");
                }
                ++var2_4;
            }
            SentryEnvelope sentryEnvelope = new SentryEnvelope((SentryEnvelopeHeader)var1_1, (Iterable<SentryEnvelopeItem>)var3_13);
            return sentryEnvelope;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelopeHeader deserializeEnvelopeHeader(byte[] buffer, int offset, int length) {
        void var3_6;
        String json = new String(buffer, 0, (int)var3_6, UTF_8);
        StringReader reader = new StringReader(json);
        try {
            SentryEnvelopeHeader sentryEnvelopeHeader = this.serializer.deserialize(reader, SentryEnvelopeHeader.class);
            reader.close();
            return sentryEnvelopeHeader;
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SentryEnvelopeItemHeader deserializeEnvelopeItemHeader(byte[] buffer, int offset, int length) {
        void var3_6;
        void var2_3;
        String json = new String(buffer, (int)var2_3, (int)var3_6, UTF_8);
        StringReader reader = new StringReader(json);
        try {
            SentryEnvelopeItemHeader sentryEnvelopeItemHeader = this.serializer.deserialize(reader, SentryEnvelopeItemHeader.class);
            reader.close();
            return sentryEnvelopeItemHeader;
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

