/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.VarArgsChecker;
import com.sun.jna.WString;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 256;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 63;
    private static final int MASK_CC = 63;
    public static final int THROW_LAST_ERROR = 64;
    public static final int USE_VARARGS = 255;
    private static final int USE_VARARGS_SHIFT = 7;
    static final Integer INTEGER_TRUE = -1;
    static final Integer INTEGER_FALSE = 0;
    private NativeLibrary library;
    private final String functionName;
    final String encoding;
    final int callFlags;
    final Map<String, ?> options;
    static final String OPTION_INVOKING_METHOD = "invoking-method";
    private static final VarArgsChecker IS_VARARGS = VarArgsChecker.create();

    /*
     * WARNING - void declaration
     */
    public static Function getFunction(String libraryName, String functionName) {
        void var1_1;
        return NativeLibrary.getInstance(libraryName).getFunction((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Function getFunction(String libraryName, String functionName, int callFlags) {
        void var2_2;
        void var1_1;
        return NativeLibrary.getInstance(libraryName).getFunction((String)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Function getFunction(String libraryName, String functionName, int callFlags, String encoding) {
        void var3_3;
        void var2_2;
        void var1_1;
        return NativeLibrary.getInstance(libraryName).getFunction((String)var1_1, (int)var2_2, (String)var3_3);
    }

    public static Function getFunction(Pointer p) {
        return Function.getFunction(p, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Function getFunction(Pointer p, int callFlags) {
        void var1_1;
        return Function.getFunction(p, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Function getFunction(Pointer p, int callFlags, String encoding) {
        void var2_2;
        void var1_1;
        Pointer pointer;
        return new Function(pointer, (int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Function(NativeLibrary library, String functionName, int callFlags, String encoding) {
        void var3_4;
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionName == null) {
            throw new NullPointerException("Function name must not be null");
        }
        this.library = library;
        this.functionName = functionName;
        this.callFlags = var3_4;
        this.options = library.getOptions();
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
        try {
            this.peer = library.getSymbolAddress(functionName);
            return;
        }
        catch (UnsatisfiedLinkError e) {
            void var1_2;
            void var2_3;
            throw new UnsatisfiedLinkError("Error looking up function '" + (String)var2_3 + "': " + var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    Function(Pointer functionAddress, int callFlags, String encoding) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionAddress == null || functionAddress.peer == 0L) {
            throw new NullPointerException("Function address may not be null");
        }
        this.functionName = functionAddress.toString();
        this.callFlags = var2_2;
        this.peer = var1_1.peer;
        this.options = Collections.EMPTY_MAP;
        this.encoding = encoding != null ? var3_3 : Native.getDefaultStringEncoding();
    }

    /*
     * WARNING - void declaration
     */
    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        if ((convention & 0x3F) != convention) {
            void var1_1;
            throw new IllegalArgumentException("Unrecognized calling convention: " + (int)var1_1);
        }
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callFlags & 0x3F;
    }

    /*
     * WARNING - void declaration
     */
    public Object invoke(Class<?> returnType, Object[] inArgs) {
        void var2_2;
        void var1_1;
        return this.invoke((Class<?>)var1_1, (Object[])var2_2, this.options);
    }

    /*
     * WARNING - void declaration
     */
    public Object invoke(Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
        void var3_3;
        void var2_2;
        void var1_1;
        Method invokingMethod = (Method)options.get(OPTION_INVOKING_METHOD);
        Class<?>[] paramTypes = invokingMethod != null ? invokingMethod.getParameterTypes() : null;
        return this.invoke(invokingMethod, paramTypes, (Class<?>)var1_1, (Object[])var2_2, (Map<String, ?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    Object invoke(Method invokingMethod, Class<?>[] paramTypes, Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
        void var2_3;
        Object[] args = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 256) {
                throw new UnsupportedOperationException("Maximum argument count is 256");
            }
            args = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args, 0, args.length);
        }
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        boolean allowObjects = Boolean.TRUE.equals(options.get("allow-objects"));
        boolean isVarArgs = args.length > 0 && invokingMethod != null ? Function.isVarArgs(invokingMethod) : false;
        int fixedArgs = args.length > 0 && invokingMethod != null ? Function.fixedArgs(invokingMethod) : 0;
        for (int i = 0; i < args.length; ++i) {
            Class<?> paramType = invokingMethod != null ? (isVarArgs && i >= paramTypes.length - 1 ? paramTypes[paramTypes.length - 1].getComponentType() : paramTypes[i]) : null;
            args[i] = this.convertArgument(args, i, invokingMethod, mapper, allowObjects, paramType);
        }
        Class<?> nativeReturnType = returnType;
        FromNativeConverter resultConverter = null;
        if (NativeMapped.class.isAssignableFrom(returnType)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(returnType);
            resultConverter = tc;
            nativeReturnType = tc.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType)) != null) {
            nativeReturnType = resultConverter.nativeType();
        }
        Object result = this.invoke(args, nativeReturnType, allowObjects, fixedArgs);
        if (resultConverter != null) {
            FunctionResultContext context = invokingMethod != null ? new MethodResultContext(returnType, this, inArgs, invokingMethod) : new FunctionResultContext(returnType, this, inArgs);
            result = resultConverter.fromNative(result, context);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                void var3_4;
                Object inArg = inArgs[i];
                if (inArg == null) continue;
                if (inArg instanceof Structure) {
                    if (inArg instanceof Structure.ByValue) continue;
                    ((Structure)inArg).autoRead();
                    continue;
                }
                if (args[i] instanceof PostCallRead) {
                    ((PostCallRead)args[i]).read();
                    if (!(args[i] instanceof PointerArray)) continue;
                    PointerArray array = (PointerArray)args[i];
                    if (!Structure.ByReference[].class.isAssignableFrom(inArg.getClass())) continue;
                    Class<?> type = inArg.getClass().getComponentType();
                    Structure[] ss = (Structure[])inArg;
                    for (int si = 0; si < ss.length; ++si) {
                        Pointer p = ((Pointer)array).getPointer(Native.POINTER_SIZE * si);
                        ss[si] = Structure.updateStructureByReference(type, ss[si], p);
                    }
                    continue;
                }
                if (!Structure[].class.isAssignableFrom(var3_4.getClass())) continue;
                Structure.autoRead((Structure[])var3_4);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    Object invoke(Object[] args, Class<?> returnType, boolean allowObjects) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.invoke((Object[])var1_1, (Class<?>)var2_2, (boolean)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    Object invoke(Object[] args, Class<?> returnType, boolean allowObjects, int fixedArgs) {
        Object s;
        Object result = null;
        int callFlags = this.callFlags | (fixedArgs & 0xFF) << 7;
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            Function function = this;
            Native.invokeVoid(function, function.peer, callFlags, args);
            result = null;
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            Function function = this;
            result = Function.valueOf(Native.invokeInt(function, function.peer, callFlags, args) != 0);
        } else if (returnType == Byte.TYPE || returnType == Byte.class) {
            Function function = this;
            result = (byte)Native.invokeInt(function, function.peer, callFlags, args);
        } else if (returnType == Short.TYPE || returnType == Short.class) {
            Function function = this;
            result = (short)Native.invokeInt(function, function.peer, callFlags, args);
        } else if (returnType == Character.TYPE || returnType == Character.class) {
            Function function = this;
            result = Character.valueOf((char)Native.invokeInt(function, function.peer, callFlags, args));
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            Function function = this;
            result = Native.invokeInt(function, function.peer, callFlags, args);
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            Function function = this;
            result = Native.invokeLong(function, function.peer, callFlags, args);
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            Function function = this;
            result = Float.valueOf(Native.invokeFloat(function, function.peer, callFlags, args));
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            Function function = this;
            result = Native.invokeDouble(function, function.peer, callFlags, args);
        } else if (returnType == String.class) {
            result = this.invokeString(callFlags, args, false);
        } else if (returnType == WString.class) {
            s = this.invokeString(callFlags, args, true);
            if (s != null) {
                result = new WString((String)s);
            }
        } else {
            void var3_3;
            void var1_1;
            void var2_2;
            String[] arr;
            Pointer p;
            if (Pointer.class.isAssignableFrom(returnType)) {
                return this.invokePointer(callFlags, (Object[])s);
            }
            if (Structure.class.isAssignableFrom(returnType)) {
                if (Structure.ByValue.class.isAssignableFrom(returnType)) {
                    Function function = this;
                    s = Native.invokeStructure(function, function.peer, callFlags, (Object[])s, Structure.newInstance(returnType));
                    ((Structure)s).autoRead();
                    result = s;
                } else {
                    result = this.invokePointer(callFlags, (Object[])s);
                    if (result != null) {
                        s = Structure.newInstance(returnType, (Pointer)result);
                        ((Structure)s).conditionalAutoRead();
                        result = s;
                    }
                }
            } else if (Callback.class.isAssignableFrom(returnType)) {
                result = this.invokePointer(callFlags, (Object[])s);
                if (result != null) {
                    result = CallbackReference.getCallback(returnType, (Pointer)result);
                }
            } else if (returnType == String[].class) {
                p = this.invokePointer(callFlags, (Object[])s);
                if (p != null) {
                    result = p.getStringArray(0L, this.encoding);
                }
            } else if (returnType == WString[].class) {
                if ((p = this.invokePointer(callFlags, (Object[])p)) != null) {
                    arr = p.getWideStringArray(0L);
                    WString[] warr = new WString[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        warr[i] = new WString(arr[i]);
                    }
                    result = var2_2;
                }
            } else if (var2_2 == Pointer[].class) {
                p = this.invokePointer(callFlags, arr);
                if (p != null) {
                    result = var1_1.getPointerArray(0L);
                }
            } else if (var3_3 != false) {
                Function function = this;
                result = Native.invokeObject(function, function.peer, callFlags, (Object[])var1_1);
                if (result != null && !var2_2.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Return type " + var2_2 + " does not match result " + result.getClass());
                }
            } else {
                throw new IllegalArgumentException("Unsupported return type " + var2_2 + " in function " + this.getName());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Pointer invokePointer(int callFlags, Object[] args) {
        void var3_3;
        void var2_2;
        void var1_1;
        Function function = this;
        long ptr = Native.invokePointer(function, function.peer, (int)var1_1, (Object[])var2_2);
        if (ptr == 0L) {
            return null;
        }
        return new Pointer((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Object convertArgument(Object[] args, int index, Method invokingMethod, TypeMapper mapper, boolean allowObjects, Class<?> expectedType) {
        Object arg = args[index];
        if (arg != null) {
            Class<?> type = arg.getClass();
            ToNativeConverter converter = null;
            if (NativeMapped.class.isAssignableFrom(type)) {
                converter = NativeMappedConverter.getInstance(type);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type);
            }
            if (converter != null) {
                FunctionParameterContext context;
                context = invokingMethod != null ? new MethodParameterContext(this, args, index, invokingMethod) : new FunctionParameterContext(this, (Object[])context, index);
                arg = converter.toNative(arg, context);
            }
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.autoWrite();
            if (struct instanceof Structure.ByValue) {
                Class<?> ptype = struct.getClass();
                if (invokingMethod != null) {
                    Class<?>[] ptypes = invokingMethod.getParameterTypes();
                    if (IS_VARARGS.isVarArgs(invokingMethod) && index >= ptypes.length - 1) {
                        Class<?> etype = ptypes[ptypes.length - 1].getComponentType();
                        if (etype != Object.class) {
                            ptype = etype;
                        }
                    } else {
                        ptype = ptypes[index];
                    }
                }
                if (Structure.ByValue.class.isAssignableFrom(ptype)) {
                    return struct;
                }
            }
            return struct.getPointer();
        }
        if (arg instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg);
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, this.encoding).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof Boolean) {
            if (Boolean.TRUE.equals(arg)) {
                return INTEGER_TRUE;
            }
            return INTEGER_FALSE;
        }
        if (String[].class == argClass) {
            return new StringArray((String[])arg, this.encoding);
        }
        if (WString[].class == argClass) {
            return new StringArray((WString[])arg);
        }
        if (Pointer[].class == argClass) {
            return new PointerArray((Pointer[])arg);
        }
        if (NativeMapped[].class.isAssignableFrom(argClass)) {
            return new NativeMappedArray((NativeMapped[])arg);
        }
        if (Structure[].class.isAssignableFrom(argClass)) {
            Structure[] ss = (Structure[])arg;
            Class<?> type = argClass.getComponentType();
            boolean byRef = Structure.ByReference.class.isAssignableFrom(type);
            if (expectedType != null && !Structure.ByReference[].class.isAssignableFrom(expectedType)) {
                if (byRef) {
                    throw new IllegalArgumentException("Function " + this.getName() + " declared Structure[] at parameter " + index + " but array of " + type + " was passed");
                }
                for (int i = 0; i < ss.length; ++i) {
                    if (!(ss[i] instanceof Structure.ByReference)) continue;
                    throw new IllegalArgumentException("Function " + this.getName() + " declared Structure[] at parameter " + index + " but element " + i + " is of Structure.ByReference type");
                }
            }
            if (byRef) {
                void var3_4;
                Structure.autoWrite(ss);
                Pointer[] pointers = new Pointer[ss.length + 1];
                for (int i = 0; i < ss.length; ++i) {
                    pointers[i] = ss[i] != null ? ss[i].getPointer() : null;
                }
                return new PointerArray((Pointer[])var3_4);
            }
            if (ss.length == 0) {
                throw new IllegalArgumentException("Structure array must have non-zero length");
            }
            if (ss[0] == null) {
                void var1_1;
                ((Structure)Structure.newInstance(var1_1)).toArray(ss);
                return ss[0].getPointer();
            }
            Structure.autoWrite(ss);
            return ss[0].getPointer();
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + argClass.getComponentType());
        }
        if (allowObjects) {
            return arg;
        }
        if (!Native.isSupportedNativeType(arg.getClass())) {
            void var2_3;
            throw new IllegalArgumentException("Unsupported argument type " + arg.getClass().getName() + " at parameter " + (int)var2_3 + " of function " + this.getName());
        }
        return arg;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPrimitiveArray(Class<?> argClass) {
        void var1_1;
        return argClass.isArray() && var1_1.getComponentType().isPrimitive();
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(Object[] args) {
        void var1_1;
        this.invoke(Void.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String invokeString(int callFlags, Object[] args, boolean wide) {
        void var2_3;
        Pointer ptr = this.invokePointer(callFlags, args);
        String s = null;
        if (ptr != null) {
            void var1_2;
            void var3_4;
            s = var3_4 != false ? ptr.getWideString(0L) : var1_2.getString(0L, this.encoding);
        }
        return var2_3;
    }

    @Override
    public String toString() {
        if (this.library != null) {
            return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
        }
        return "native function@0x" + Long.toHexString(this.peer);
    }

    /*
     * WARNING - void declaration
     */
    public Object invokeObject(Object[] args) {
        void var1_1;
        return this.invoke(Object.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Pointer invokePointer(Object[] args) {
        void var1_1;
        return (Pointer)this.invoke(Pointer.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String invokeString(Object[] args, boolean wide) {
        void var2_2;
        Object o = this.invoke(var2_2 != false ? WString.class : String.class, args);
        if (o != null) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int invokeInt(Object[] args) {
        void var1_1;
        return (Integer)this.invoke(Integer.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long invokeLong(Object[] args) {
        void var1_1;
        return (Long)this.invoke(Long.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public float invokeFloat(Object[] args) {
        void var1_1;
        return ((Float)this.invoke(Float.class, (Object[])var1_1)).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    public double invokeDouble(Object[] args) {
        void var1_1;
        return (Double)this.invoke(Double.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void invokeVoid(Object[] args) {
        void var1_1;
        this.invoke(Void.class, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            void var1_1;
            Function other = (Function)o;
            return other.callFlags == this.callFlags && other.options.equals(this.options) && var1_1.peer == this.peer;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.callFlags + this.options.hashCode() + super.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    static Object[] concatenateVarArgs(Object[] inArgs) {
        Object[] objectArray;
        Object lastArg;
        Class<?> argType;
        if (inArgs != null && inArgs.length > 0 && (argType = (lastArg = inArgs[inArgs.length - 1]) != null ? lastArg.getClass() : null) != null && argType.isArray()) {
            void var2_4;
            void var1_1;
            Object[] varArgs = (Object[])lastArg;
            for (int i = 0; i < varArgs.length; ++i) {
                if (!(varArgs[i] instanceof Float)) continue;
                varArgs[i] = (double)((Float)varArgs[i]).floatValue();
            }
            Object[] fullArgs = new Object[inArgs.length + varArgs.length];
            System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
            System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, ((void)var1_1).length);
            fullArgs[fullArgs.length - 1] = null;
            inArgs = var2_4;
        }
        return objectArray;
    }

    static boolean isVarArgs(Method m) {
        Method method;
        return IS_VARARGS.isVarArgs(method);
    }

    static int fixedArgs(Method m) {
        Method method;
        return IS_VARARGS.fixedArgs(method);
    }

    static Boolean valueOf(boolean b) {
        if (b) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static interface PostCallRead {
        public void read();
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private final Pointer[] original;

        /*
         * WARNING - void declaration
         */
        public PointerArray(Pointer[] arg) {
            super(Native.POINTER_SIZE * (arg.length + 1));
            void var1_1;
            this.original = arg;
            for (int i = 0; i < arg.length; ++i) {
                ((Pointer)this).setPointer(i * Native.POINTER_SIZE, arg[i]);
            }
            ((Pointer)this).setPointer(Native.POINTER_SIZE * ((void)var1_1).length, null);
        }

        @Override
        public void read() {
            ((Pointer)this).read(0L, this.original, 0, this.original.length);
        }
    }

    private static class NativeMappedArray
    extends Memory
    implements PostCallRead {
        private final NativeMapped[] original;

        /*
         * WARNING - void declaration
         */
        public NativeMappedArray(NativeMapped[] arg) {
            super(Native.getNativeSize(arg.getClass(), arg));
            void var1_1;
            this.original = var1_1;
            this.setValue(0L, this.original, this.original.getClass());
        }

        @Override
        public void read() {
            this.getValue(0L, this.original.getClass(), this.original);
        }
    }
}

