/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.LongSparseArrayKt;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001a\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010\u0017\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010#R\u001e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'"}, d2={"Landroidx/collection/LongSparseArray;", "E", "", "", "initialCapacity", "<init>", "(I)V", "", "key", "get", "(J)Ljava/lang/Object;", "", "isEmpty", "()Z", "index", "keyAt", "(I)J", "value", "", "put", "(JLjava/lang/Object;)V", "remove", "(J)V", "size", "()I", "", "toString", "()Ljava/lang/String;", "valueAt", "(I)Ljava/lang/Object;", "garbage", "Z", "", "keys", "[J", "I", "", "", "values", "[Ljava/lang/Object;"})
@SourceDebugExtension(value={"SMAP\nLongSparseArray.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongSparseArray.jvm.kt\nandroidx/collection/LongSparseArray\n+ 2 LongSparseArray.kt\nandroidx/collection/LongSparseArrayKt\n*L\n1#1,255:1\n243#2:256\n256#2,6:257\n248#2,14:263\n267#2,8:277\n267#2,8:285\n278#2,9:293\n291#2,5:302\n299#2,8:307\n315#2,9:315\n349#2,12:324\n328#2,18:336\n363#2,26:354\n392#2,5:380\n400#2,5:385\n409#2,2:390\n328#2,18:392\n412#2:410\n416#2:411\n420#2,6:412\n328#2,18:418\n427#2:436\n432#2,6:437\n328#2,18:443\n441#2:461\n446#2,6:462\n328#2,18:468\n453#2,2:486\n458#2,2:488\n328#2,18:490\n461#2:508\n466#2,2:509\n328#2,18:511\n469#2,6:529\n479#2:535\n484#2:536\n489#2,8:537\n500#2,6:545\n328#2,18:551\n507#2,10:569\n520#2,21:579\n*S KotlinDebug\n*F\n+ 1 LongSparseArray.jvm.kt\nandroidx/collection/LongSparseArray\n*L\n93#1:256\n93#1:257,6\n100#1:263,14\n106#1:277,8\n111#1:285,8\n120#1:293,9\n125#1:302,5\n134#1:307,8\n145#1:315,9\n151#1:324,12\n151#1:336,18\n151#1:354,26\n157#1:380,5\n168#1:385,5\n173#1:390,2\n173#1:392,18\n173#1:410\n180#1:411\n192#1:412,6\n192#1:418,18\n192#1:436\n204#1:437,6\n204#1:443,18\n204#1:461\n212#1:462,6\n212#1:468,18\n212#1:486,2\n219#1:488,2\n219#1:490,18\n219#1:508\n228#1:509,2\n228#1:511,18\n228#1:529,6\n231#1:535\n234#1:536\n239#1:537,8\n245#1:545,6\n245#1:551,18\n245#1:569,10\n253#1:579,21\n*E\n"})
public class LongSparseArray<E>
implements Cloneable {
    @JvmField
    public /* synthetic */ boolean garbage;
    @JvmField
    public /* synthetic */ long[] keys;
    @JvmField
    public /* synthetic */ Object[] values;
    @JvmField
    public /* synthetic */ int size;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public LongSparseArray(int initialCapacity) {
        void var1_1;
        if (initialCapacity == 0) {
            this.keys = ContainerHelpersKt.EMPTY_LONGS;
            this.values = ContainerHelpersKt.EMPTY_OBJECTS;
            return;
        }
        int idealCapacity = ContainerHelpersKt.idealLongArraySize(initialCapacity);
        this.keys = new long[idealCapacity];
        this.values = new Object[var1_1];
    }

    public /* synthetic */ LongSparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    public final E get(long key) {
        void var1_2;
        LongSparseArray longSparseArray;
        LongSparseArray $this$commonGetInternal$iv$iv = longSparseArray = this;
        int i$iv$iv = ContainerHelpersKt.binarySearch(longSparseArray.keys, $this$commonGetInternal$iv$iv.size, key);
        if (i$iv$iv < 0 || $this$commonGetInternal$iv$iv.values[i$iv$iv] == LongSparseArrayKt.access$getDELETED$p()) {
            return null;
        }
        return (E)longSparseArray.values[var1_2];
    }

    public final void remove(long key) {
        LongSparseArray $this$commonRemove$iv = this;
        int i$iv = ContainerHelpersKt.binarySearch($this$commonRemove$iv.keys, $this$commonRemove$iv.size, key);
        if (i$iv >= 0 && $this$commonRemove$iv.values[i$iv] != LongSparseArrayKt.access$getDELETED$p()) {
            $this$commonRemove$iv.values[var1_2] = LongSparseArrayKt.access$getDELETED$p();
            var3_3.garbage = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void put(long key, E value) {
        void var3_2;
        void var1_1;
        int n;
        LongSparseArray $this$commonPut$iv = this;
        int index$iv = ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        if (index$iv >= 0) {
            $this$commonPut$iv.values[index$iv] = value;
            return;
        }
        if ((index$iv ^= 0xFFFFFFFF) < $this$commonPut$iv.size && $this$commonPut$iv.values[index$iv] == LongSparseArrayKt.access$getDELETED$p()) {
            $this$commonPut$iv.keys[index$iv] = key;
            $this$commonPut$iv.values[index$iv] = value;
            return;
        }
        if ($this$commonPut$iv.garbage && $this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonPut$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            $this$commonGc$iv$iv.size = newSize$iv$iv;
            n = ~ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        }
        if ($this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
            int newSize$iv = ContainerHelpersKt.idealLongArraySize($this$commonPut$iv.size + 1);
            long[] lArray = Arrays.copyOf($this$commonPut$iv.keys, newSize$iv);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, newSize)");
            $this$commonPut$iv.keys = lArray;
            Object[] objectArray = Arrays.copyOf($this$commonPut$iv.values, newSize$iv);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            $this$commonPut$iv.values = objectArray;
        }
        if ($this$commonPut$iv.size - n != 0) {
            ArraysKt.copyInto((long[])$this$commonPut$iv.keys, (long[])$this$commonPut$iv.keys, (int)(n + true), (int)n, (int)$this$commonPut$iv.size);
            ArraysKt.copyInto((Object[])$this$commonPut$iv.values, (Object[])$this$commonPut$iv.values, (int)(n + true), (int)n, (int)$this$commonPut$iv.size);
        }
        $this$commonPut$iv.keys[n] = var1_1;
        $this$commonPut$iv.values[n] = var3_2;
        int n2 = $this$commonPut$iv.size;
        $this$commonPut$iv.size = n2 + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void var1_1;
        LongSparseArray $this$commonSize$iv = this;
        if ($this$commonSize$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonSize$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            var2_2.size = newSize$iv$iv;
        }
        return var1_1.size;
    }

    public final boolean isEmpty() {
        LongSparseArray longSparseArray = this;
        return longSparseArray.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final long keyAt(int index2) {
        void var1_1;
        void var2_3;
        LongSparseArray $this$commonKeyAt$iv = this;
        if (!(index2 >= 0 ? index2 < $this$commonKeyAt$iv.size : false)) {
            String index2 = "Expected index to be within 0..size()-1, but was " + index2;
            throw new IllegalArgumentException(index2.toString());
        }
        if ($this$commonKeyAt$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonKeyAt$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            var3_4.size = newSize$iv$iv;
        }
        return var2_3.keys[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final E valueAt(int index2) {
        void var1_1;
        void var2_3;
        LongSparseArray $this$commonValueAt$iv = this;
        if (!(index2 >= 0 ? index2 < $this$commonValueAt$iv.size : false)) {
            String index2 = "Expected index to be within 0..size()-1, but was " + index2;
            throw new IllegalArgumentException(index2.toString());
        }
        if ($this$commonValueAt$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonValueAt$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            var3_4.size = newSize$iv$iv;
        }
        return (E)var2_3.values[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var3_4;
        StringBuilder stringBuilder;
        LongSparseArray $this$commonToString$iv = this;
        if ($this$commonToString$iv.size() <= 0) {
            return "{}";
        }
        int n = $this$commonToString$iv.size * 28;
        StringBuilder $this$commonToString_u24lambda_u245$iv = stringBuilder = new StringBuilder(n);
        stringBuilder.append('{');
        int n2 = $this$commonToString$iv.size;
        for (int i$iv = 0; i$iv < n2; ++i$iv) {
            if (i$iv > 0) {
                $this$commonToString_u24lambda_u245$iv.append(", ");
            }
            long key$iv = $this$commonToString$iv.keyAt(i$iv);
            $this$commonToString_u24lambda_u245$iv.append(key$iv);
            $this$commonToString_u24lambda_u245$iv.append('=');
            E value$iv = $this$commonToString$iv.valueAt(i$iv);
            if (value$iv != $this$commonToString_u24lambda_u245$iv) {
                $this$commonToString_u24lambda_u245$iv.append(value$iv);
                continue;
            }
            $this$commonToString_u24lambda_u245$iv.append("(this Map)");
        }
        var3_4.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @JvmOverloads
    public LongSparseArray() {
        this(0, 1, null);
    }
}

