/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections;

import io.ktor.util.collections.ConcurrentMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u001a\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\b\b\u0000\u0010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004"}, d2={"", "Key", "", "ConcurrentSet", "()Ljava/util/Set;"})
public final class ConcurrentSetKt {
    public static final <Key> Set<Key> ConcurrentSet() {
        return new Set<Key>(){
            private final ConcurrentMap<Key, Unit> delegate;
            {
                this.delegate = new ConcurrentMap<Key, Value>(0, 1, null);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean add(Key element) {
                void var1_1;
                Intrinsics.checkNotNullParameter(element, (String)"element");
                if (this.delegate.containsKey(element)) {
                    return false;
                }
                ((Map)this.delegate).put(var1_1, Unit.INSTANCE);
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean addAll(Collection<? extends Key> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Iterable $this$all$iv = elements;
                if (!((Collection)$this$all$iv).isEmpty()) {
                    Iterator<T> iterator2;
                    iterator2 = iterator2.iterator();
                    while (iterator2.hasNext()) {
                        void var2_2;
                        T it = iterator2.next();
                        if (this.add(var2_2)) continue;
                        return false;
                    }
                }
                return true;
            }

            public final void clear() {
                this.delegate.clear();
            }

            public final Iterator<Key> iterator() {
                return this.delegate.keySet().iterator();
            }

            /*
             * WARNING - void declaration
             */
            public final boolean remove(Object element) {
                void var1_1;
                if (element == null) {
                    return false;
                }
                return this.delegate.remove(var1_1) != null;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean removeAll(Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Iterable $this$all$iv = elements;
                if (!((Collection)$this$all$iv).isEmpty()) {
                    Iterator<T> iterator2;
                    iterator2 = iterator2.iterator();
                    while (iterator2.hasNext()) {
                        void var2_2;
                        T it = iterator2.next();
                        if (this.remove(var2_2)) continue;
                        return false;
                    }
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean retainAll(Collection<? extends Object> elements) {
                void var2_2;
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Set removeList = new LinkedHashSet<E>();
                for (Key key : this.delegate.keySet()) {
                    if (elements.contains(key)) continue;
                    removeList.add(key);
                }
                return this.removeAll((Collection)var2_2);
            }

            public final int getSize() {
                return this.delegate.size();
            }

            /*
             * WARNING - void declaration
             */
            public final boolean contains(Object element) {
                void var1_1;
                if (element == null) {
                    return false;
                }
                return this.delegate.containsKey(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean containsAll(Collection<? extends Object> elements) {
                void var1_1;
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return var1_1.containsAll((Collection)this.delegate.keySet());
            }

            public final boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            /*
             * WARNING - void declaration
             */
            public final <T> T[] toArray(T[] array) {
                void var1_1;
                Intrinsics.checkNotNullParameter(array, (String)"array");
                return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
            }

            public final Object[] toArray() {
                return CollectionToArray.toArray((Collection)this);
            }
        };
    }
}

