/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.pool;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.pool.ObjectPool;

public final class ConcurrentQueueObjectPool<O>
implements ObjectPool<O> {
    private final AtomicInteger count;
    private final Queue<O> queue;
    private final ObjectPool.ObjectSupplier<O> supplier;
    private final int maxCapacity;
    private final ObjectPool.ObjectSanitizer<O> sanitizer;

    /*
     * WARNING - void declaration
     */
    @Override
    public final ObjectPool.Lease<O> take() {
        void var1_1;
        O obj = this.queue.poll();
        if (obj == null) {
            obj = Objects.requireNonNull(this.supplier.get());
        } else {
            this.count.decrementAndGet();
        }
        return new LeaseImpl(var1_1);
    }

    private final class LeaseImpl
    implements ObjectPool.Lease<O> {
        private @Nullable O obj;

        /*
         * WARNING - void declaration
         */
        public LeaseImpl(O obj) {
            void var2_2;
            this.obj = var2_2;
        }

        @Override
        public final O get() {
            return this.obj;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void close() {
            void var1_1;
            @Nullable O theObject = this.obj;
            this.obj = null;
            if (theObject != null && ConcurrentQueueObjectPool.this.count.get() < ConcurrentQueueObjectPool.this.maxCapacity && ConcurrentQueueObjectPool.this.sanitizer.sanitize(theObject) && ConcurrentQueueObjectPool.this.queue.offer(var1_1)) {
                ConcurrentQueueObjectPool.this.count.incrementAndGet();
            }
        }
    }
}

