/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.InterruptedIOException;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.newsclub.net.unix.ThreadUtil$$Lambda$2;

@IgnoreJRERequirement
public final class ThreadUtil {
    private static final ThreadLocal<Boolean> TREAT_AS_VIRTUAL_THREAD = new ThreadLocal();

    private ThreadUtil() {
        throw new IllegalStateException("No instances");
    }

    private static boolean isTreatAsVirtualThread() {
        return Boolean.TRUE.equals(TREAT_AS_VIRTUAL_THREAD.get());
    }

    private static void setTreatAsVirtualThread(boolean b) {
        boolean bl;
        if (ThreadUtil.isTreatAsVirtualThread()) {
            return;
        }
        TREAT_AS_VIRTUAL_THREAD.set(bl);
    }

    public static boolean isVirtualThread() {
        return ThreadUtil.isTreatAsVirtualThread();
    }

    public static boolean isVirtualThreadSupported() {
        return false;
    }

    public static boolean checkNotInterruptedOrThrow() throws InterruptedIOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void runOnSystemThread(Runnable op) throws InterruptedException {
        boolean treatAsVirtual = ThreadUtil.isTreatAsVirtualThread();
        if (treatAsVirtual) {
            ThreadUtil.setTreatAsVirtualThread(false);
        }
        try {
            Runnable runnable;
            runnable.run();
            if (!treatAsVirtual) return;
        }
        catch (Throwable throwable) {
            void var1_2;
            if (!treatAsVirtual) throw throwable;
            ThreadUtil.setTreatAsVirtualThread((boolean)var1_2);
            throw throwable;
        }
        ThreadUtil.setTreatAsVirtualThread(treatAsVirtual);
    }

    static /* synthetic */ void lambda$startNewDaemonThread$1(Runnable run0) {
        Runnable runnable;
        ThreadUtil.setTreatAsVirtualThread(true);
        runnable.run();
    }

    static /* synthetic */ Thread lambda$newVirtualThreadPerTaskExecutor$0(Runnable r) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        boolean bl = true;
        Runnable runnable3 = runnable2;
        runnable2 = ThreadUtil$$Lambda$2.lambdaFactory$$1daae6bf(runnable3);
        runnable3 = new Thread(runnable2);
        ((Thread)runnable3).setDaemon(true);
        ((Thread)runnable3).start();
        return runnable3;
    }
}

