/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$1;
import org.newsclub.net.unix.NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$2;
import org.newsclub.net.unix.NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$3;
import org.newsclub.net.unix.NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$4;
import org.newsclub.net.unix.NativeUnixSocket;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
final class NativeLibraryLoader
implements Closeable {
    private static final File TEMP_DIR;
    private static final String OS_NAME_SIMPLIFIED;
    private static final List<String> ARCHITECTURE_AND_OS;
    private static final AtomicBoolean LOADED;
    private static final boolean IS_ANDROID;

    NativeLibraryLoader() {
    }

    /*
     * WARNING - void declaration
     */
    private List<LibraryCandidate> tryProviderClass(String providerClassname, String artifactName) throws IOException, ClassNotFoundException {
        String[] stringArray;
        void var3_3;
        Object object;
        Class<?> providerClass = Class.forName(providerClassname);
        String version = NativeLibraryLoader.getArtifactVersion(providerClass, artifactName);
        String libraryNameAndVersion = "junixsocket-native-" + version;
        void var4_4 = object;
        object = this;
        String string = var3_3;
        object = System.mapLibraryName(string);
        if (((String)object).endsWith(".so")) {
            switch (OS_NAME_SIMPLIFIED) {
                case "AIX": {
                    object = ((String)object).substring(0, ((String)object).length() - 3) + ".a";
                    break;
                }
                case "OS400": {
                    object = ((String)object).substring(0, ((String)object).length() - 3) + ".srvpgm";
                }
            }
        }
        if (((String)object).startsWith("lib")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "";
            stringArray = stringArray3;
            stringArray3[1] = "lib";
        }
        String[] stringArray4 = stringArray;
        ArrayList<LibraryCandidate> arrayList = new ArrayList<LibraryCandidate>();
        for (String string2 : ARCHITECTURE_AND_OS) {
            String[] stringArray5 = new String[]{"clang", "gcc"};
            int cfr_ignored_0 = stringArray5.length;
            for (int i = 0; i < 2; ++i) {
                String string3 = stringArray5[i];
                String[] stringArray6 = stringArray4;
                int n = stringArray4.length;
                for (int j = 0; j < n; ++j) {
                    URL uRL;
                    int n2;
                    void var2_2;
                    string = stringArray6[j];
                    string = "/lib/" + string2 + "-" + string3 + "/jni/" + string + (String)object;
                    Object object2 = NativeLibraryLoader.validateResourceURL(var4_4.getResource(string));
                    if (object2 != null) {
                        arrayList.add(new ClasspathLibraryCandidate((String)var2_2, (String)var3_3, string, (URL)object2));
                    }
                    if ((string = (n2 = string.lastIndexOf(46)) == -1 ? null : string.substring(0, n2) + ".nodeps" + string.substring(n2)) == null || (uRL = NativeLibraryLoader.validateResourceURL(var4_4.getResource(string))) == null) continue;
                    arrayList.add(new ClasspathLibraryCandidate((String)var2_2, (String)var3_3, string, uRL));
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static String getArtifactVersion(Class<?> providerClass, String ... artifactNames) throws IOException {
        int n = artifactNames.length;
        if (n > 0) {
            String string;
            block7: {
                String artifactName = artifactNames[0];
                Properties p = new Properties();
                String resource = "/META-INF/maven/com.kohlschutter.junixsocket/" + artifactName + "/pom.properties";
                InputStream in = providerClass.getResourceAsStream(resource);
                try {
                    String string2;
                    void var2_5;
                    if (in == null) {
                        throw new FileNotFoundException("Could not find resource " + (String)string + " relative to " + providerClass);
                    }
                    p.load(in);
                    String version = var2_5.getProperty("version");
                    Objects.requireNonNull(version, "Could not read version from pom.properties");
                    string = string2;
                    if (in == null) break block7;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            void var3_6;
                            var3_6.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        throw new IllegalStateException("No artifact names specified");
    }

    private synchronized void setLoaded(String library) {
        NativeLibraryLoader.setLoaded0(library);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"})
    private static synchronized void setLoaded0(String library) {
        if (LOADED.compareAndSet(false, true)) {
            NativeUnixSocket.setLoaded(true);
            AFSocket.loadedLibrary = library;
            try {
                NativeUnixSocket.init();
                return;
            }
            catch (RuntimeException runtimeException) {
                library = runtimeException;
                throw runtimeException;
            }
            catch (Exception e) {
                void var0_1;
                throw new IllegalStateException((Throwable)var0_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Throwable loadLibraryOverride() {
        void var3_3;
        boolean overrideIsAbsolute;
        String libraryOverride = System.getProperty("org.newsclub.net.unix.library.override", "");
        String libraryOverrideForce = System.getProperty("org.newsclub.net.unix.library.override.force", "false");
        try {
            overrideIsAbsolute = libraryOverrideForce.length() <= 5 ? false : new File(libraryOverrideForce).isAbsolute();
        }
        catch (Exception e) {
            overrideIsAbsolute = false;
            e.printStackTrace();
        }
        if (libraryOverride.isEmpty() && var3_3 != false) {
            libraryOverride = libraryOverrideForce;
            libraryOverrideForce = "true";
        }
        if (!libraryOverride.isEmpty()) {
            try {
                void var1_1;
                System.load(libraryOverride);
                this.setLoaded((String)var1_1);
                return null;
            }
            catch (Exception | LinkageError e) {
                void var2_2;
                if (Boolean.parseBoolean((String)var2_2)) {
                    throw e;
                }
                return e;
            }
        }
        return new Exception("No library specified with -Dorg.newsclub.net.unix.library.override=");
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void loadLibrary() {
        Object object = NativeLibraryLoader.class.getClassLoader();
        object = object == null ? NativeLibraryLoader.class : object;
        synchronized (object) {
            void var3_5;
            if (LOADED.get()) {
                return;
            }
            NativeUnixSocket.initPre();
            if ("provided".equals(System.getProperty("org.newsclub.net.unix.library.override.force", ""))) {
                this.setLoaded("provided");
                return;
            }
            boolean provided = false;
            try {
                NativeUnixSocket.noop();
                provided = true;
            }
            catch (Exception | UnsatisfiedLinkError throwable) {}
            if (provided) {
                this.setLoaded("provided");
                return;
            }
            if (Boolean.parseBoolean(System.getProperty("org.newsclub.net.unix.library.disable", "false"))) {
                throw NativeLibraryLoader.initCantLoadLibraryError(Collections.singletonList(new UnsupportedOperationException("junixsocket disabled by System.property org.newsclub.net.unix.library.disable")));
            }
            ArrayList<Throwable> suppressedThrowables = new ArrayList<Throwable>();
            Throwable ex = this.loadLibraryOverride();
            if (ex == null) {
                return;
            }
            suppressedThrowables.add(ex);
            List<LibraryCandidate> candidates = this.initLibraryCandidates(suppressedThrowables);
            String loadedLibraryId = null;
            for (LibraryCandidate candidate : candidates) {
                try {
                    loadedLibraryId = candidate.load();
                    if (loadedLibraryId == null) continue;
                    break;
                }
                catch (Exception | LinkageError e) {
                    suppressedThrowables.add(e);
                }
            }
            for (LibraryCandidate libraryCandidate : var3_5) {
                libraryCandidate.close();
            }
            if (loadedLibraryId == null) {
                void var2_3;
                throw NativeLibraryLoader.initCantLoadLibraryError((List<Throwable>)var2_3);
            }
            this.setLoaded(loadedLibraryId);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static UnsatisfiedLinkError initCantLoadLibraryError(List<Throwable> suppressedThrowables) {
        void var1_1;
        String message = "Could not load native library junixsocket-native for architecture " + ARCHITECTURE_AND_OS;
        String cp = System.getProperty("java.class.path", "");
        if (cp.contains("junixsocket-native-custom/target-eclipse") || cp.contains("junixsocket-native-common/target-eclipse")) {
            message = message + "\n\n*** ECLIPSE USERS ***\nIf you're running from within Eclipse, please close the projects \"junixsocket-native-common\" and \"junixsocket-native-custom\"\n";
        }
        UnsatisfiedLinkError e = new UnsatisfiedLinkError(message);
        if (suppressedThrowables != null) {
            Iterator<Throwable> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Throwable suppressed = (Throwable)iterator.next();
                e.addSuppressed((Throwable)var2_2);
            }
        }
        throw var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<LibraryCandidate> initLibraryCandidates(List<Throwable> suppressedThrowables) {
        void var2_2;
        ArrayList<LibraryCandidate> candidates = new ArrayList<LibraryCandidate>();
        try {
            String version = NativeLibraryLoader.getArtifactVersion(this.getClass(), "junixsocket-common", "junixsocket-core");
            if (version != null) {
                candidates.add(new StandardLibraryCandidate(version));
            }
        }
        catch (Exception e) {
            suppressedThrowables.add(e);
        }
        try {
            candidates.addAll(this.tryProviderClass("org.newsclub.lib.junixsocket.custom.NarMetadata", "junixsocket-native-custom"));
        }
        catch (Exception e) {
            suppressedThrowables.add(e);
        }
        try {
            candidates.addAll(this.tryProviderClass("org.newsclub.lib.junixsocket.common.NarMetadata", "junixsocket-native-common"));
        }
        catch (Exception e) {
            void var3_6;
            void var1_1;
            var1_1.add(var3_6);
        }
        candidates.add(new StandardLibraryCandidate(null));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static String lookupArchProperty(String key, String defaultVal) {
        void var1_1;
        return System.getProperty(key, (String)var1_1).replaceAll("[ /\\\\'\";:\\$]", "");
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    /*
     * WARNING - void declaration
     */
    private static URL validateResourceURL(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URL uRL;
            InputStream unused = url.openStream();
            if (unused != null) {
                void var1_1;
                var1_1.close();
            }
            return uRL;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public final void close() {
    }

    static {
        OS_NAME_SIMPLIFIED = NativeLibraryLoader.lookupArchProperty("os.name", "UnknownOS");
        String string = NativeLibraryLoader.lookupArchProperty("os.arch", "UnknownArch");
        Object object = new ArrayList<String>();
        if (IS_ANDROID) {
            object.add(string + "-Android");
        }
        object.add(string + "-" + OS_NAME_SIMPLIFIED);
        if (OS_NAME_SIMPLIFIED.startsWith("Windows") && !"Windows10".equals(OS_NAME_SIMPLIFIED)) {
            object.add((String)(string + "-Windows10"));
        }
        if ("MacOSX".equals(OS_NAME_SIMPLIFIED) && "x86_64".equals(string)) {
            object.add((String)"aarch64-MacOSX");
        }
        ARCHITECTURE_AND_OS = object;
        LOADED = new AtomicBoolean(false);
        string = NativeLibraryLoader.lookupArchProperty("java.vm.name", "UnknownVM");
        object = NativeLibraryLoader.lookupArchProperty("java.vm.specification.vendor", "UnknownSpecificationVendor");
        IS_ANDROID = "Dalvik".equals(string) || ((String)object).contains("Android");
        String dir = System.getProperty("org.newsclub.net.unix.library.tmpdir", System.getProperty("java.io.tmpdir", null));
        TEMP_DIR = dir == null ? null : new File(string);
    }

    private static abstract class LibraryCandidate
    implements Closeable {
        protected final String libraryNameAndVersion;

        /*
         * WARNING - void declaration
         */
        protected LibraryCandidate(String libraryNameAndVersion) {
            void var1_1;
            this.libraryNameAndVersion = var1_1;
        }

        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        abstract String load() throws Exception;

        @Override
        public abstract void close();

        public String toString() {
            return super.toString() + "[" + this.libraryNameAndVersion + "]";
        }
    }

    private static final class StandardLibraryCandidate
    extends LibraryCandidate {
        /*
         * WARNING - void declaration
         */
        StandardLibraryCandidate(String version) {
            super(version == null ? "junixsocket-native" : "junixsocket-native-" + (String)var1_1);
            void var1_1;
        }

        @Override
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        final String load() throws Exception, LinkageError {
            if (this.libraryNameAndVersion != null) {
                System.loadLibrary(this.libraryNameAndVersion);
                return this.libraryNameAndVersion;
            }
            return null;
        }

        @Override
        public final void close() {
        }

        @Override
        public final String toString() {
            return super.toString() + "(standard library path)";
        }
    }

    private static final class ClasspathLibraryCandidate
    extends LibraryCandidate {
        private final String artifactName;
        private final URL library;
        private final String path;

        /*
         * WARNING - void declaration
         */
        ClasspathLibraryCandidate(String artifactName, String libraryNameAndVersion, String path, URL library) {
            super((String)var2_2);
            void var3_3;
            void var1_1;
            void var2_2;
            this.artifactName = var1_1;
            this.path = var3_3;
            this.library = library;
        }

        /*
         * WARNING - void declaration
         */
        private static void deleteLibTmpDelFiles(File libDir) {
            void var1_1;
            File file;
            File[] filesToDelete;
            File file2;
            if (libDir == null) {
                try {
                    File tempFile = File.createTempFile("libtmp", ".del");
                    libDir = tempFile.getParentFile();
                    file2 = tempFile;
                    file2.delete();
                }
                catch (IOException iOException) {
                    return;
                }
            }
            if ((filesToDelete = file.listFiles(NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$1.lambdaFactory$$4ed6e6a0())) == null || filesToDelete.length == 0) {
                return;
            }
            file = var1_1;
            int n = ((void)file).length;
            for (int i = 0; i < n; ++i) {
                File file3;
                File f;
                file2 = f = file[i];
                f.delete();
                String n2 = f.getName();
                n2 = n2.substring(0, n2.length() - 4);
                file2 = file3 = new File(file3.getParentFile(), n2);
                file3.delete();
            }
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        @Override
        final synchronized String load() throws IOException, LinkageError {
            File userDirOrNull;
            if (this.libraryNameAndVersion == null) {
                return null;
            }
            File libDir = TEMP_DIR;
            File userHomeDir = new File(System.getProperty("user.home", "."));
            if (userHomeDir.equals(userDirOrNull = new File(System.getProperty("user.dir", ".")))) {
                userDirOrNull = null;
            }
            ClasspathLibraryCandidate.deleteLibTmpDelFiles(libDir);
            ClasspathLibraryCandidate.deleteLibTmpDelFiles(userHomeDir);
            if (userDirOrNull != null) {
                ClasspathLibraryCandidate.deleteLibTmpDelFiles(userDirOrNull);
            }
            for (int attempt = 0; attempt < 3; ++attempt) {
                Object libraryIn;
                File libFile;
                try {
                    libFile = File.createTempFile("libtmp", System.mapLibraryName(this.libraryNameAndVersion), libDir);
                    libraryIn = this.library.openStream();
                    try (FileOutputStream out = new FileOutputStream(libFile);){
                        int read;
                        byte[] buf = new byte[4096];
                        while ((read = ((InputStream)libraryIn).read(buf)) >= 0) {
                            ((OutputStream)out).write(buf, 0, read);
                        }
                    }
                    finally {
                        if (libraryIn != null) {
                            ((InputStream)libraryIn).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    libraryIn = iOException;
                    throw iOException;
                }
                System.load(libFile.getAbsolutePath());
                if (libFile.delete() || !libFile.exists()) break;
                libFile.deleteOnExit();
                File markerFile = new File(libFile.getParentFile(), libFile.getName() + ".del");
                try {
                    Files.createFile(markerFile.toPath(), new FileAttribute[0]);
                    Runtime.getRuntime().addShutdownHook(new Thread(NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$2.lambdaFactory$$2483e411(libFile, markerFile)));
                }
                catch (IOException | UnsupportedOperationException exception) {}
                break;
                catch (UnsatisfiedLinkError e2222222222) {
                    File markerFile2;
                    try {
                        switch (attempt) {
                            case 0: {
                                File e2222222222 = userHomeDir;
                                break;
                            }
                            case 1: {
                                File e2222222222;
                                if (userDirOrNull != null) {
                                    e2222222222 = userDirOrNull;
                                    break;
                                }
                            }
                            default: {
                                void var1_2;
                                throw var1_2;
                            }
                        }
                        if (libFile.delete() || !libFile.exists()) continue;
                        libFile.deleteOnExit();
                        markerFile2 = new File(libFile.getParentFile(), libFile.getName() + ".del");
                    }
                    catch (Throwable throwable) {
                        if (!libFile.delete() && libFile.exists()) {
                            libFile.deleteOnExit();
                            File markerFile3 = new File(libFile.getParentFile(), libFile.getName() + ".del");
                            try {
                                void var2_4;
                                Files.createFile(markerFile3.toPath(), new FileAttribute[0]);
                                Runtime.getRuntime().addShutdownHook(new Thread(NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$4.lambdaFactory$$2483e411(libFile, (File)var2_4)));
                            }
                            catch (IOException | UnsupportedOperationException exception) {}
                        }
                        throw throwable;
                    }
                    try {
                        Files.createFile(markerFile2.toPath(), new FileAttribute[0]);
                        Runtime.getRuntime().addShutdownHook(new Thread(NativeLibraryLoader$ClasspathLibraryCandidate$$Lambda$3.lambdaFactory$$2483e411(libFile, markerFile2)));
                    }
                    catch (IOException | UnsupportedOperationException exception) {}
                    continue;
                }
            }
            return this.artifactName + "/" + this.libraryNameAndVersion;
        }

        @Override
        public final void close() {
        }

        @Override
        public final String toString() {
            return super.toString() + "(" + this.artifactName + ":" + this.path + ")";
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void lambda$load$1(File libFile, File markerFile) {
            File file;
            if (!libFile.exists() || file.delete()) {
                void var1_1;
                file = var1_1;
                file.delete();
            }
        }

        static /* synthetic */ boolean lambda$deleteLibTmpDelFiles$0(File f) {
            String string;
            if (!f.isFile()) {
                return false;
            }
            String name = f.getName();
            return name.startsWith("libtmp") && string.endsWith(".del");
        }
    }
}

