/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

final class MapValueSet<T, V>
implements Set<T> {
    private final Map<T, V> map;
    private final ValueSupplier<@NonNull V> valueSupplier;
    private final V removedSentinel;

    /*
     * WARNING - void declaration
     */
    MapValueSet(Map<? extends T, V> map, ValueSupplier<@NonNull V> valueSupplier, V removedSentinel) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.valueSupplier = (ValueSupplier)Objects.requireNonNull(var2_2);
        this.removedSentinel = var3_3;
        this.map = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void markRemoved(T elem) {
        void var1_1;
        if (this.removedSentinel == null) {
            this.map.remove(elem);
            return;
        }
        this.map.put(var1_1, this.removedSentinel);
    }

    public final void markAllRemoved() {
        if (this.removedSentinel == null) {
            this.map.clear();
            return;
        }
        for (Map.Entry<T, V> entry : this.map.entrySet()) {
            entry.setValue(this.removedSentinel);
        }
    }

    private @NonNull V getValue() {
        return Objects.requireNonNull(this.valueSupplier.supplyValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size() {
        void var2_2;
        V val = this.getValue();
        if (val.equals(this.removedSentinel)) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<T, V> en : this.map.entrySet()) {
            if (!val.equals(en.getValue())) continue;
            ++size;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEmpty() {
        V val = this.getValue();
        if (val.equals(this.removedSentinel)) {
            return true;
        }
        for (Map.Entry<T, V> en : this.map.entrySet()) {
            void var3_3;
            if (!val.equals(var3_3.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean isDefinitelyEmpty() {
        return this.getValue().equals(this.removedSentinel);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object o) {
        void var1_1;
        if (this.isDefinitelyEmpty()) {
            return false;
        }
        return this.getValue().equals(this.map.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<T> iterator() {
        void var2_2;
        void var1_1;
        if (this.isDefinitelyEmpty()) {
            return Collections.emptyIterator();
        }
        Iterator<Map.Entry<T, V>> mapit = this.map.entrySet().iterator();
        V val = this.getValue();
        return new Iterator<T>(){
            Map.Entry<T, V> nextObj = null;
            Map.Entry<T, V> currentObj = null;
            final /* synthetic */ Iterator val$mapit;
            final /* synthetic */ Object val$val;
            final /* synthetic */ MapValueSet this$0;
            {
                void var1_1;
                this.val$mapit = iterator;
                this.val$val = object;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean hasNext() {
                if (this.nextObj != null) {
                    return true;
                }
                while (this.val$mapit.hasNext()) {
                    void var1_1;
                    Map.Entry en = (Map.Entry)this.val$mapit.next();
                    if (!this.val$val.equals(en.getValue())) continue;
                    this.nextObj = var1_1;
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public T next() {
                this.currentObj = null;
                if (this.nextObj == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object next = this.nextObj.getKey();
                if (this.val$val.equals(this.nextObj.getValue())) {
                    void var1_1;
                    this.currentObj = this.nextObj;
                    this.nextObj = null;
                    return var1_1;
                }
                throw new ConcurrentModificationException();
            }

            @Override
            public void remove() {
                if (this.currentObj == null) {
                    throw new IllegalStateException();
                }
                this.this$0.markRemoved(this.currentObj.getKey());
                this.currentObj = null;
            }
        };
    }

    @Override
    public final Object[] toArray() {
        MapValueSet mapValueSet = this;
        return mapValueSet.toArray((E[])new Object[mapValueSet.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E> E[] toArray(E[] a) {
        void var1_1;
        int size;
        while (a.length < (size = this.size())) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (T elem : this) {
            a[i++] = elem;
        }
        if (i < a.length) {
            a[var2_2] = null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(T e) {
        void var1_1;
        boolean bl;
        if (this.contains(e)) {
            return false;
        }
        T t = e;
        MapValueSet mapValueSet = this;
        if (mapValueSet.map.containsKey(t)) {
            mapValueSet.map.put(t, mapValueSet.getValue());
            bl = true;
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        this.map.put(var1_1, this.getValue());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object o) {
        void var1_1;
        if (this.isDefinitelyEmpty() || !this.map.containsKey(o)) {
            return false;
        }
        this.markRemoved(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<?> c) {
        Iterator iterator;
        if (this.isDefinitelyEmpty()) {
            return c.isEmpty();
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object obj = iterator.next();
            if (this.contains(var2_2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends T> c) {
        void var2_2;
        Iterator iterator;
        boolean changed = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object elem = iterator.next();
            changed |= this.add(var3_3);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<?> c) {
        void var2_2;
        boolean changed = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            T elem = it.next();
            if (c.contains(elem)) continue;
            it.remove();
            changed = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<?> c) {
        void var2_2;
        Iterator iterator;
        if (this.isDefinitelyEmpty()) {
            return false;
        }
        boolean changed = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object obj = iterator.next();
            changed |= this.remove(var3_3);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        V val = this.getValue();
        if (val.equals(this.removedSentinel)) {
            return;
        }
        for (Map.Entry<T, V> en : this.map.entrySet()) {
            void var3_3;
            if (!val.equals(en.getValue())) continue;
            this.markRemoved(var3_3.getKey());
        }
    }

    @FunctionalInterface
    static interface ValueSupplier<V> {
        public V supplyValue();
    }
}

