/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.util.Objects;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSomeSocketChannel;
import org.newsclub.net.unix.BrokenPipeSocketException;
import org.newsclub.net.unix.InvalidArgumentSocketException;
import org.newsclub.net.unix.NotBoundSocketException;
import org.newsclub.net.unix.NotConnectedSocketException;
import org.newsclub.net.unix.SocketClosedByInterruptException;
import org.newsclub.net.unix.SocketClosedException;

final class InterruptibleChannelUtil {
    InterruptibleChannelUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static void endInterruptable(AFSomeSocketChannel channel, EndMethod end, boolean complete, Exception exception) throws AsynchronousCloseException {
        void var3_4;
        if (!complete && var3_4 instanceof ClosedChannelException) {
            complete = true;
        }
        try {
            void var2_3;
            end.end((boolean)var2_3);
            return;
        }
        catch (AsynchronousCloseException e) {
            void var1_2;
            AFSomeSocketChannel aFSomeSocketChannel;
            throw (AsynchronousCloseException)InterruptibleChannelUtil.closeAndThrow(aFSomeSocketChannel, var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Exception> T closeAndThrow(AFSomeSocketChannel channel, T exc) {
        void var1_2;
        Objects.requireNonNull(exc);
        if (channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e2) {
                void var0_1;
                exc.addSuppressed((Throwable)var0_1);
            }
        }
        return var1_2;
    }

    static IOException ioExceptionOrThrowRuntimeException(Exception exception) {
        Exception exception2;
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new IllegalStateException(exception2);
    }

    /*
     * WARNING - void declaration
     */
    static Exception handleException(AFSomeSocketChannel channel, IOException e) {
        void var1_1;
        AFServerSocketChannel aFServerSocketChannel;
        if (e instanceof NotConnectedSocketException) {
            return (NotYetConnectedException)new NotYetConnectedException().initCause(e);
        }
        if (e instanceof NotBoundSocketException) {
            return (NotYetBoundException)new NotYetBoundException().initCause(e);
        }
        if (e instanceof InvalidArgumentSocketException) {
            if (channel instanceof AFServerSocketChannel) {
                aFServerSocketChannel = (AFServerSocketChannel)channel;
                if (!((AFServerSocket)aFServerSocketChannel.socket()).isBound()) {
                    return (NotYetBoundException)new NotYetBoundException().initCause(e);
                }
            } else if (channel instanceof AFSocketChannel && !((AFSocket)((AFSocketChannel)channel).socket()).isConnected()) {
                return (NotYetConnectedException)new NotYetConnectedException().initCause(e);
            }
        }
        if (e instanceof SocketClosedException || e instanceof ClosedChannelException || e instanceof BrokenPipeSocketException) {
            AFSomeSocketChannel aFSomeSocketChannel;
            Thread t = Thread.currentThread();
            if ((e instanceof SocketClosedByInterruptException || e instanceof ClosedByInterruptException) && !t.isInterrupted()) {
                t.interrupt();
            }
            if (!(e instanceof ClosedChannelException)) {
                e = ((Thread)((Object)aFServerSocketChannel)).isInterrupted() ? (ClosedByInterruptException)new ClosedByInterruptException().initCause(e) : (e instanceof BrokenPipeSocketException ? (AsynchronousCloseException)new AsynchronousCloseException().initCause(e) : (ClosedChannelException)new ClosedChannelException().initCause(e));
            }
            return InterruptibleChannelUtil.closeAndThrow(aFSomeSocketChannel, e);
        }
        return var1_1;
    }

    @FunctionalInterface
    static interface EndMethod {
        public void end(boolean var1) throws AsynchronousCloseException;
    }
}

