/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.newsclub.net.unix.AFAddressFamilyConfig;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFFunction;
import org.newsclub.net.unix.AFGenericServerSocket;
import org.newsclub.net.unix.AFGenericServerSocketChannel;
import org.newsclub.net.unix.AFGenericSocket;
import org.newsclub.net.unix.AFGenericSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.FileDescriptorCast$$Lambda$1;
import org.newsclub.net.unix.FileDescriptorCast$$Lambda$2;
import org.newsclub.net.unix.FileDescriptorCast$3$$Lambda$1;
import org.newsclub.net.unix.FileDescriptorCast$3$$Lambda$2;
import org.newsclub.net.unix.FileDescriptorCast$3$$Lambda$3;
import org.newsclub.net.unix.FileDescriptorCast$3$$Lambda$4;
import org.newsclub.net.unix.FileDescriptorCast$3$$Lambda$5;
import org.newsclub.net.unix.FileDescriptorCast$3$$Lambda$6;
import org.newsclub.net.unix.FileDescriptorCast$4$$Lambda$1;
import org.newsclub.net.unix.FileDescriptorCast$4$$Lambda$2;
import org.newsclub.net.unix.FileDescriptorCast$4$$Lambda$3;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$1;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$2;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$3;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$4;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$5;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$6;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$7;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$8;
import org.newsclub.net.unix.FileDescriptorCast$CastingProviderMap$$Lambda$9;
import org.newsclub.net.unix.NativeUnixSocket;

public final class FileDescriptorCast
implements FileDescriptorAccess {
    private static final Map<Class<?>, CastingProviderMap> PRIMARY_TYPE_PROVIDERS_MAP = Collections.synchronizedMap(new HashMap());
    private static final AFFunction<FileDescriptor, FileInputStream> FD_IS_PROVIDER = System.getProperty("osv.version") != null ? FileDescriptorCast$$Lambda$1.lambdaFactory$$10022539() : FileDescriptorCast$$Lambda$2.lambdaFactory$$10022539();
    private static final CastingProviderMap GLOBAL_PROVIDERS_FINAL = new CastingProviderMap(){

        @Override
        protected final void addProviders() {
            this.addProvider(FileDescriptor.class, new CastingProvider<FileDescriptor>(this){
                final /* synthetic */ 1 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
        }
    };
    private static final CastingProviderMap GLOBAL_PROVIDERS = new CastingProviderMap(){

        @Override
        protected final void addProviders() {
            this.addProvider(WritableByteChannel.class, new CastingProvider<WritableByteChannel>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            this.addProvider(ReadableByteChannel.class, new CastingProvider<ReadableByteChannel>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            this.addProvider(FileChannel.class, new CastingProvider<FileChannel>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            this.addProvider(FileOutputStream.class, new CastingProvider<FileOutputStream>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            this.addProvider(FileInputStream.class, new CastingProvider<FileInputStream>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            this.addProvider(FileDescriptor.class, new CastingProvider<FileDescriptor>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            this.addProvider(Integer.class, new CastingProvider<Integer>(this){
                final /* synthetic */ 2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }
            });
            if (AFSocket.supports(AFSocketCapability.CAPABILITY_FD_AS_REDIRECT)) {
                this.addProvider(ProcessBuilder.Redirect.class, new CastingProvider<ProcessBuilder.Redirect>(this){
                    final /* synthetic */ 2 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }
                });
            }
        }
    };
    private static final int FD_IN = FileDescriptorCast.getFdIfPossible(FileDescriptor.in);
    private static final int FD_OUT = FileDescriptorCast.getFdIfPossible(FileDescriptor.out);
    private static final int FD_ERR = FileDescriptorCast.getFdIfPossible(FileDescriptor.err);

    private static int getFdIfPossible(FileDescriptor fd) {
        if (!NativeUnixSocket.isLoaded()) {
            return -1;
        }
        try {
            FileDescriptor fileDescriptor;
            if (!fd.valid()) {
                return -1;
            }
            return NativeUnixSocket.getFD(fileDescriptor);
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void registerCastingProviders(Class<?> primaryType, CastingProviderMap cpm) {
        Objects.requireNonNull(primaryType);
        CastingProviderMap prev = PRIMARY_TYPE_PROVIDERS_MAP.put(primaryType, cpm);
        if (prev != null) {
            Class<?> clazz;
            void var1_1;
            PRIMARY_TYPE_PROVIDERS_MAP.put(primaryType, (CastingProviderMap)var1_1);
            throw new IllegalStateException("Already registered: " + clazz);
        }
    }

    /*
     * WARNING - void declaration
     */
    static <A extends AFSocketAddress> void registerCastingProviders(final AFAddressFamilyConfig<A> config) {
        void var2_2;
        AFAddressFamilyConfig<A> aFAddressFamilyConfig;
        void var1_1;
        Class<AFSocket<A>> socketClass = config.socketClass();
        Class<AFDatagramSocket<A>> datagramSocketClass = config.datagramSocketClass();
        FileDescriptorCast.registerCastingProviders(socketClass, new CastingProviderMap((Class)var1_1){
            final /* synthetic */ Class val$socketClass;
            {
                this.val$socketClass = clazz;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final void addProviders() {
                void var2_2;
                void var1_1;
                this.addProviders(GLOBAL_PROVIDERS);
                FileDescriptorCast$3$$Lambda$1 cpSocketOrChannel = FileDescriptorCast$3$$Lambda$1.lambdaFactory$$48ac0f69(config);
                FileDescriptorCast$3$$Lambda$2 cpServerSocketOrChannel = FileDescriptorCast$3$$Lambda$2.lambdaFactory$$48ac0f69(config);
                this.registerGenericSocketProviders();
                3 v0 = this;
                v0.addProvider(v0.val$socketClass, FileDescriptorCast$3$$Lambda$3.lambdaFactory$$125d9342(cpSocketOrChannel));
                3 v1 = this;
                v1.addProvider(v1.config.serverSocketClass(), FileDescriptorCast$3$$Lambda$4.lambdaFactory$$125d9342(cpServerSocketOrChannel));
                3 v2 = this;
                v2.addProvider(v2.config.socketChannelClass(), FileDescriptorCast$3$$Lambda$5.lambdaFactory$$125d9342((CastingProviderSocketOrChannel)var1_1));
                3 v3 = this;
                v3.addProvider(v3.config.serverSocketChannelClass(), FileDescriptorCast$3$$Lambda$6.lambdaFactory$$125d9342((CastingProviderSocketOrChannel)var2_2));
            }
        });
        FileDescriptorCast.registerCastingProviders(datagramSocketClass, new CastingProviderMap((Class)var2_2){
            final /* synthetic */ Class val$datagramSocketClass;
            {
                this.val$datagramSocketClass = clazz;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final void addProviders() {
                void var1_1;
                this.addProviders(GLOBAL_PROVIDERS);
                FileDescriptorCast$4$$Lambda$1 cpDatagramSocketOrChannel = FileDescriptorCast$4$$Lambda$1.lambdaFactory$$48ac0f69(aFAddressFamilyConfig);
                this.registerGenericDatagramSocketProviders();
                4 v0 = this;
                v0.addProvider(v0.val$datagramSocketClass, FileDescriptorCast$4$$Lambda$2.lambdaFactory$$125d9342(cpDatagramSocketOrChannel));
                4 v1 = this;
                v1.addProvider(v1.aFAddressFamilyConfig.datagramChannelClass(), FileDescriptorCast$4$$Lambda$3.lambdaFactory$$125d9342((CastingProviderSocketOrChannel)var1_1));
            }
        });
    }

    static /* synthetic */ LenientFileInputStream lambda$static$0$1bc0c24(FileDescriptor x$0) {
        FileDescriptor fileDescriptor;
        return new LenientFileInputStream(fileDescriptor, 0);
    }

    static {
        FileDescriptorCast.registerCastingProviders(Socket.class, new CastingProviderMap(){

            @Override
            protected final void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                this.registerGenericSocketProviders();
            }
        });
        FileDescriptorCast.registerCastingProviders(DatagramSocket.class, new CastingProviderMap(){

            @Override
            protected final void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                this.registerGenericDatagramSocketProviders();
            }
        });
    }

    private static abstract class CastingProviderMap {
        private final Map<Class<?>, CastingProvider<?>> providers = new HashMap();
        private final Set<Class<?>> classes = Collections.unmodifiableSet(this.providers.keySet());

        protected CastingProviderMap() {
            this.addProviders();
            this.addProviders(GLOBAL_PROVIDERS_FINAL);
        }

        /*
         * WARNING - void declaration
         */
        protected final void registerGenericSocketProviders() {
            void var2_2;
            void var1_1;
            FileDescriptorCast$CastingProviderMap$$Lambda$1 cpSocketOrChannelGeneric = FileDescriptorCast$CastingProviderMap$$Lambda$1.lambdaFactory$$74037fb3();
            FileDescriptorCast$CastingProviderMap$$Lambda$2 cpServerSocketOrChannelGeneric = FileDescriptorCast$CastingProviderMap$$Lambda$2.lambdaFactory$$74037fb3();
            this.addProvider(AFGenericSocket.class, FileDescriptorCast$CastingProviderMap$$Lambda$3.lambdaFactory$$125d9342(cpSocketOrChannelGeneric));
            this.addProvider(AFGenericServerSocket.class, FileDescriptorCast$CastingProviderMap$$Lambda$4.lambdaFactory$$125d9342(cpServerSocketOrChannelGeneric));
            this.addProvider(AFGenericSocketChannel.class, FileDescriptorCast$CastingProviderMap$$Lambda$5.lambdaFactory$$125d9342((CastingProviderSocketOrChannel)var1_1));
            this.addProvider(AFGenericServerSocketChannel.class, FileDescriptorCast$CastingProviderMap$$Lambda$6.lambdaFactory$$125d9342((CastingProviderSocketOrChannel)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        protected final void registerGenericDatagramSocketProviders() {
            void var1_1;
            FileDescriptorCast$CastingProviderMap$$Lambda$7 cpDatagramSocketOrChannelGeneric = FileDescriptorCast$CastingProviderMap$$Lambda$7.lambdaFactory$$74037fb3();
            this.addProvider(AFDatagramSocket.class, FileDescriptorCast$CastingProviderMap$$Lambda$8.lambdaFactory$$125d9342(cpDatagramSocketOrChannelGeneric));
            this.addProvider(AFDatagramChannel.class, FileDescriptorCast$CastingProviderMap$$Lambda$9.lambdaFactory$$125d9342((CastingProviderSocketOrChannel)var1_1));
        }

        protected abstract void addProviders();

        /*
         * WARNING - void declaration
         */
        protected final <T> void addProvider(Class<T> type, CastingProvider<?> cp) {
            void var2_2;
            void var1_1;
            Objects.requireNonNull(type);
            this.addProvider0((Class<?>)var1_1, (CastingProvider<?>)var2_2);
        }

        private void addProvider0(Class<?> type, CastingProvider<?> cp) {
            while (this.providers.put((Class<?>)type, cp) != cp) {
                Class<?>[] classArray = type.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n; ++i) {
                    Class<?> cl = classArray[i];
                    this.addProvider0(cl, cp);
                }
                Class<?> scl = type.getSuperclass();
                if (scl == null) break;
                type = classArray;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected final void addProviders(CastingProviderMap other) {
            void var1_1;
            if (other == null || other == this) {
                return;
            }
            this.providers.putAll(var1_1.providers);
        }
    }

    @FunctionalInterface
    private static interface CastingProvider<T> {
    }

    private static final class LenientFileInputStream
    extends FileInputStream {
        /*
         * WARNING - void declaration
         */
        private LenientFileInputStream(FileDescriptor fdObj) {
            super((FileDescriptor)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException iOException) {
                void var1_1;
                void var2_2;
                IOException e = iOException;
                String msg = iOException.getMessage();
                if ("Invalid seek".equals(var2_2)) {
                    return 0;
                }
                throw var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ LenientFileInputStream(FileDescriptor x0, byte by) {
            this((FileDescriptor)var1_1);
            void var1_1;
        }
    }

    @FunctionalInterface
    private static interface CastingProviderSocketOrChannel<T> {
    }
}

