/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$1;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$2;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$3;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$4;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$5;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$6;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$7;
import org.newsclub.net.unix.AFSocketChannel$$Lambda$8;
import org.newsclub.net.unix.AFSocketCore;
import org.newsclub.net.unix.AFSocketExtensions;
import org.newsclub.net.unix.AFSocketOption;
import org.newsclub.net.unix.AFSomeSocket;
import org.newsclub.net.unix.AFSomeSocketChannel;
import org.newsclub.net.unix.InterruptibleChannelUtil;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketOptionsMapper;

public abstract class AFSocketChannel<A extends AFSocketAddress>
extends SocketChannel
implements AFSocketExtensions,
AFSomeSocket,
AFSomeSocketChannel {
    private final @NonNull AFSocket<A> afSocket;
    private final AtomicBoolean connectPending = new AtomicBoolean(false);

    /*
     * WARNING - void declaration
     */
    protected AFSocketChannel(AFSocket<A> socket, AFSelectorProvider<A> sp) {
        super((SelectorProvider)var2_2);
        void var1_1;
        void var2_2;
        this.afSocket = (AFSocket)Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getOption(SocketOption<T> name) throws IOException {
        void var1_1;
        if (name instanceof AFSocketOption) {
            return this.getAFCore().getOption((AFSocketOption)name);
        }
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        AFSocket<A> aFSocket = this.afSocket;
        return (T)aFSocket.getAFImpl(true).getOption(var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private <T> AFSocketChannel<A> setOption(SocketOption<T> name, T value) throws IOException {
        void var2_2;
        void var1_1;
        if (name instanceof AFSocketOption) {
            this.getAFCore().setOption((AFSocketOption)name, value);
            return this;
        }
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        AFSocket<A> aFSocket = this.afSocket;
        aFSocket.getAFImpl(true).setOption(var1_1.intValue(), (Object)var2_2);
        return this;
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return SocketOptionsMapper.SUPPORTED_SOCKET_OPTIONS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private AFSocketChannel<A> bind(SocketAddress local) throws IOException {
        void var1_1;
        this.afSocket.bind((SocketAddress)var1_1);
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final AFSocket<A> socket() {
        return this.afSocket;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isConnected() {
        void var1_1;
        boolean connected = this.afSocket.isConnected();
        if (connected) {
            this.connectPending.set(false);
        }
        return (boolean)var1_1;
    }

    @Override
    public final boolean isConnectionPending() {
        return this.connectPending.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean connect(SocketAddress remote) throws IOException {
        AFSocketChannel aFSocketChannel;
        boolean connected;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            connected = this.afSocket.connect0(remote, 0);
            if (!connected) {
                this.connectPending.set(true);
            }
            complete = true;
            aFSocketChannel = this;
        }
        catch (IOException e) {
            try {
                void var1_3;
                exception = InterruptibleChannelUtil.handleException(this, (IOException)var1_3);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                void var3_6;
                void var2_5;
                AFSocketChannel aFSocketChannel2 = this;
                InterruptibleChannelUtil.endInterruptable(aFSocketChannel2, AFSocketChannel$$Lambda$2.lambdaFactory$$39aaa8e8(aFSocketChannel2), (boolean)var2_5, (Exception)var3_6);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(aFSocketChannel, AFSocketChannel$$Lambda$1.lambdaFactory$$39aaa8e8(aFSocketChannel), true, null);
        return connected;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean finishConnect() throws IOException {
        AFSocketChannel aFSocketChannel;
        boolean connected;
        if (this.isConnected()) {
            return true;
        }
        if (!this.isConnectionPending()) {
            return false;
        }
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            connected = NativeUnixSocket.finishConnect(this.afSocket.getFileDescriptor()) || this.isConnected();
            if (connected) {
                this.connectPending.set(false);
            }
            complete = true;
            aFSocketChannel = this;
        }
        catch (IOException e) {
            try {
                void var3_4;
                exception = InterruptibleChannelUtil.handleException(this, (IOException)var3_4);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                void var2_2;
                void var1_1;
                AFSocketChannel aFSocketChannel2 = this;
                InterruptibleChannelUtil.endInterruptable(aFSocketChannel2, AFSocketChannel$$Lambda$4.lambdaFactory$$39aaa8e8(aFSocketChannel2), (boolean)var1_1, (Exception)var2_2);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(aFSocketChannel, AFSocketChannel$$Lambda$3.lambdaFactory$$39aaa8e8(aFSocketChannel), true, null);
        return connected;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(ByteBuffer dst) throws IOException {
        AFSocketChannel aFSocketChannel;
        int read;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            AFSocket<A> aFSocket = this.afSocket;
            read = aFSocket.getAFImpl(true).read(dst, null);
            complete = true;
            aFSocketChannel = this;
        }
        catch (IOException e) {
            try {
                void var1_3;
                exception = InterruptibleChannelUtil.handleException(this, (IOException)var1_3);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                void var3_6;
                void var2_5;
                AFSocketChannel aFSocketChannel2 = this;
                InterruptibleChannelUtil.endInterruptable(aFSocketChannel2, AFSocketChannel$$Lambda$6.lambdaFactory$$39aaa8e8(aFSocketChannel2), (boolean)var2_5, (Exception)var3_6);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(aFSocketChannel, AFSocketChannel$$Lambda$5.lambdaFactory$$39aaa8e8(aFSocketChannel), true, null);
        return read;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        void var2_2;
        void var1_1;
        if (length == 0) {
            return 0L;
        }
        return this.read((ByteBuffer)var1_1[var2_2]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        void var2_2;
        void var1_1;
        if (length == 0) {
            return 0L;
        }
        return this.write((ByteBuffer)var1_1[var2_2]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int write(ByteBuffer src) throws IOException {
        AFSocketChannel aFSocketChannel;
        int written;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            AFSocket<A> aFSocket = this.afSocket;
            written = aFSocket.getAFImpl(true).write(src);
            complete = true;
            aFSocketChannel = this;
        }
        catch (IOException e) {
            try {
                void var1_3;
                exception = InterruptibleChannelUtil.handleException(this, (IOException)var1_3);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                void var3_6;
                void var2_5;
                AFSocketChannel aFSocketChannel2 = this;
                InterruptibleChannelUtil.endInterruptable(aFSocketChannel2, AFSocketChannel$$Lambda$8.lambdaFactory$$39aaa8e8(aFSocketChannel2), (boolean)var2_5, (Exception)var3_6);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(aFSocketChannel, AFSocketChannel$$Lambda$7.lambdaFactory$$39aaa8e8(aFSocketChannel), true, null);
        return written;
    }

    @Override
    protected final void implCloseSelectableChannel() throws IOException {
        this.afSocket.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void implConfigureBlocking(boolean block) throws IOException {
        void var1_1;
        this.getAFCore().implConfigureBlocking((boolean)var1_1);
    }

    final AFSocketCore getAFCore() {
        AFSocket<A> aFSocket = this.afSocket;
        return aFSocket.getAFImpl(true).getCore$3b181ae1();
    }

    public final String toString() {
        return super.toString() + this.afSocket.toStringSuffix();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void lambda$write$3(AFSocketChannel rec$, boolean x$0) throws AsynchronousCloseException {
        void var1_1;
        rec$.end((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void lambda$read$2(AFSocketChannel rec$, boolean x$0) throws AsynchronousCloseException {
        void var1_1;
        rec$.end((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void lambda$finishConnect$1(AFSocketChannel rec$, boolean x$0) throws AsynchronousCloseException {
        void var1_1;
        rec$.end((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void lambda$connect$0(AFSocketChannel rec$, boolean x$0) throws AsynchronousCloseException {
        void var1_1;
        rec$.end((boolean)var1_1);
    }

    @FunctionalInterface
    protected static interface AFSocketSupplier<A extends AFSocketAddress> {
        public AFSocket<A> newInstance() throws IOException;
    }
}

