/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.google.errorprone.annotations.Immutable;
import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFInetAddress;
import org.newsclub.net.unix.AFSocketAddress$$Lambda$1;
import org.newsclub.net.unix.AFSocketAddress$$Lambda$2;
import org.newsclub.net.unix.AFSocketAddressFromHostname;
import org.newsclub.net.unix.AFSupplier;
import org.newsclub.net.unix.NativeLibraryLoader;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SentinelSocketAddress;
import org.newsclub.net.unix.SocketAddressUtil;
import org.newsclub.net.unix.pool.ObjectPool;
import org.newsclub.net.unix.pool.ObjectPool$;

@Immutable
public abstract class AFSocketAddress
extends InetSocketAddress {
    static final AFSocketAddress INTERNAL_DUMMY_BIND;
    static final AFSocketAddress INTERNAL_DUMMY_CONNECT;
    static final AFSocketAddress INTERNAL_DUMMY_DONT_CONNECT;
    private static final int SOCKADDR_NATIVE_FAMILY_OFFSET;
    private static final int SOCKADDR_NATIVE_DATA_OFFSET;
    private static final int SOCKADDR_MAX_LEN;
    private static final Map<AFAddressFamily<?>, Map<Integer, Map<ByteBuffer, AFSocketAddress>>> ADDRESS_CACHE;
    static final ObjectPool<ByteBuffer> SOCKETADDRESS_BUFFER_TL;
    private static final boolean USE_DESERIALIZATION_FOR_INIT;
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private byte[] bytes;
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private InetAddress inetAddress = null;
    private transient ByteBuffer nativeAddress;
    private transient AFAddressFamily<?> addressFamily;

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AFSocketAddress(int port, byte[] socketAddress, ObjectPool.Lease<ByteBuffer> nativeAddress, AFAddressFamily<?> af) throws SocketException {
        super(AFInetAddress.createUnresolvedHostname(socketAddress, af), port >= 0 && port <= 65535 ? port : 0);
        void var3_3;
        void var2_2;
        void var1_1;
        AFSocketAddress.initAFSocketAddress(this, (int)var1_1, (byte[])var2_2, (ObjectPool.Lease<ByteBuffer>)var3_3, af);
    }

    /*
     * WARNING - void declaration
     */
    AFSocketAddress(int port) {
        super(InetAddress.getLoopbackAddress(), (int)var1_1);
        void var1_1;
        this.nativeAddress = null;
        this.bytes = new byte[0];
        this.addressFamily = null;
    }

    /*
     * WARNING - void declaration
     */
    private static void initAFSocketAddress(AFSocketAddress addr, int port, byte[] socketAddress, ObjectPool.Lease<ByteBuffer> nativeAddress, AFAddressFamily<?> af) throws SocketException {
        void var2_2;
        void var3_3;
        if (socketAddress.length == 0) {
            throw new SocketException("Illegal address length: " + socketAddress.length);
        }
        ByteBuffer byteBuffer = addr.nativeAddress = nativeAddress == null ? null : (ByteBuffer)((ByteBuffer)var3_3.get()).duplicate().rewind();
        if (port < -1) {
            throw new IllegalArgumentException("port out of range");
        }
        if (port > 65535) {
            void var1_1;
            if (!NativeUnixSocket.isLoaded()) {
                throw (SocketException)new SocketException("Cannot set SocketAddress port - junixsocket JNI library is not available").initCause(NativeUnixSocket.unsupportedException());
            }
            NativeUnixSocket.setPort1$4ff9e5a1(addr, (int)var1_1);
        }
        addr.bytes = (byte[])var2_2.clone();
        var0.addressFamily = af;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <A extends AFSocketAddress> A newDeserializedAFSocketAddress(int port, byte[] socketAddress, ObjectPool.Lease<ByteBuffer> nativeAddress, AFAddressFamily<A> af, AFSocketAddressConstructor<A> constructor) throws SocketException {
        Object oin;
        String hostname = AFInetAddress.createUnresolvedHostname(socketAddress, af);
        if (hostname == null) return (A)constructor.newAFSocketAddress(port, socketAddress, nativeAddress);
        if (hostname.isEmpty()) {
            return (A)constructor.newAFSocketAddress(port, socketAddress, nativeAddress);
        }
        try {
            int n2 = port >= 0 && port <= 65535 ? port : 0;
            constructor = af.getSocketAddressClass();
            ByteBuffer byteBuffer = ByteBuffer.allocate(768);
            byteBuffer.putShort((short)-21267);
            byteBuffer.putShort((short)5);
            byteBuffer.put((byte)115);
            byteBuffer.put((byte)114);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, ((Class)constructor).getName());
            byteBuffer.putLong(1L);
            byteBuffer.putInt(33554552);
            byteBuffer.put((byte)114);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, AFSocketAddress.class.getName());
            byteBuffer.putLong(1L);
            byteBuffer.putInt(50332251);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, "bytes");
            byteBuffer.putInt(1946157659);
            byteBuffer.putShort((short)16972);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, "inetAddress");
            byteBuffer.put((byte)116);
            AFSocketAddress.putShortLengthEncodedClassName(byteBuffer, InetAddress.class);
            byteBuffer.putShort((short)30834);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, InetSocketAddress.class.getName());
            byteBuffer.putLong(5076001401234631237L);
            byteBuffer.putInt(50332489);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, "port");
            byteBuffer.put((byte)76);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, "addr");
            byteBuffer.putInt(1895857664);
            byteBuffer.putShort((short)844);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, "hostname");
            byteBuffer.put((byte)116);
            AFSocketAddress.putShortLengthEncodedClassName(byteBuffer, String.class);
            byteBuffer.putShort((short)30834);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, SocketAddress.class.getName());
            byteBuffer.putLong(5215720748342549866L);
            byteBuffer.putInt(33554552);
            byteBuffer.put((byte)112);
            byteBuffer.putInt(n2);
            byteBuffer.putShort((short)28788);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, hostname);
            byteBuffer.putInt(0x78707077);
            byteBuffer.put((byte)11);
            AFSocketAddress.putShortLengthUtf8(byteBuffer, "undefined");
            byteBuffer.put((byte)120);
            byteBuffer.flip();
            constructor = new byte[byteBuffer.remaining()];
            byteBuffer.get((byte[])constructor);
            oin = new ObjectInputStream(new ByteArrayInputStream((byte[])constructor));
            try {
                void var3_5;
                void var2_4;
                void var1_3;
                int n;
                AFSocketAddress addr = (AFSocketAddress)((ObjectInputStream)oin).readObject();
                AFSocketAddress.initAFSocketAddress(addr, n, (byte[])var1_3, (ObjectPool.Lease<ByteBuffer>)var2_4, var3_5);
                AFSocketAddress aFSocketAddress = addr;
                return (A)aFSocketAddress;
            }
            finally {
                ((ObjectInputStream)oin).close();
            }
        }
        catch (SocketException socketException) {
            oin = socketException;
            throw socketException;
        }
        catch (IOException | ClassNotFoundException e) {
            throw (SocketException)new SocketException("Unexpected deserialization problem").initCause(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void putShortLengthEncodedClassName(ByteBuffer bb, Class<?> klazz) {
        void var1_1;
        AFSocketAddress.putShortLengthUtf8(bb, "L" + var1_1.getName().replace('.', '/') + ";");
    }

    /*
     * WARNING - void declaration
     */
    private static void putShortLengthUtf8(ByteBuffer bb, String s) {
        void var1_1;
        ByteBuffer byteBuffer;
        byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
        bb.putShort((short)utf8.length);
        byteBuffer.put((byte[])var1_1);
    }

    protected static boolean isUseDeserializationForInit() {
        return USE_DESERIALIZATION_FOR_INIT;
    }

    public abstract boolean hasFilename();

    public abstract File getFile() throws FileNotFoundException;

    public final AFAddressFamily<?> getAddressFamily() {
        return this.addressFamily;
    }

    /*
     * WARNING - void declaration
     */
    protected static final InetAddress getInetAddress(FileDescriptor fdesc, boolean peerName, AFAddressFamily<?> af) {
        void var2_2;
        Object object;
        if (!fdesc.valid()) {
            return null;
        }
        byte[] byArray = NativeUnixSocket.sockname(af.getDomain(), fdesc, false);
        Object addr = byArray;
        if (byArray == null) {
            return null;
        }
        return AFInetAddress.wrapAddress((byte[])object, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static final <A extends AFSocketAddress> @Nullable A getSocketAddress(FileDescriptor fdesc, boolean requestPeerName, int port, AFAddressFamily<A> af) {
        void var1_2;
        if (!fdesc.valid()) {
            return null;
        }
        byte[] byArray = NativeUnixSocket.sockname(af.getDomain(), fdesc, (boolean)var1_2);
        Object addr = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            void var3_4;
            void var2_3;
            return AFSocketAddress.unwrap(AFInetAddress.wrapAddress((byte[])addr, af), (int)var2_3, var3_4);
        }
        catch (SocketException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static final AFSocketAddress preprocessSocketAddress(Class<? extends AFSocketAddress> supportedAddressClass, SocketAddress endpoint, AFSocketAddressFromHostname<?> afh) throws SocketException {
        void var1_1;
        Objects.requireNonNull(endpoint);
        if (endpoint instanceof SentinelSocketAddress) {
            return (SentinelSocketAddress)endpoint;
        }
        if (!(endpoint instanceof AFSocketAddress)) {
            InetSocketAddress isa;
            String hostname;
            if (afh != null && endpoint instanceof InetSocketAddress && afh.isHostnameSupported(hostname = (isa = (InetSocketAddress)endpoint).getHostString())) {
                try {
                    void var3_3;
                    void var2_2;
                    endpoint = var2_2.addressFromHost(hostname, var3_3.getPort());
                }
                catch (SocketException socketException) {
                    supportedAddressClass = socketException;
                    throw socketException;
                }
            }
            endpoint = AFSocketAddress.mapOrFail(endpoint, supportedAddressClass);
        }
        Objects.requireNonNull(endpoint);
        if (!supportedAddressClass.isAssignableFrom(endpoint.getClass())) {
            Class<? extends AFSocketAddress> clazz;
            throw new IllegalArgumentException("Can only connect to endpoints of type " + clazz.getName() + ", got: " + endpoint.getClass() + ": " + endpoint);
        }
        return (AFSocketAddress)var1_1;
    }

    protected final byte[] getBytes() {
        return this.bytes;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static final <A extends AFSocketAddress> A resolveAddress(byte[] socketAddress, int port, AFAddressFamily<A> af) throws SocketException {
        Map<ByteBuffer, AFSocketAddress> map;
        AFSocketAddress instance;
        int limit;
        ByteBuffer direct;
        ObjectPool.Lease<ByteBuffer> lease;
        block15: {
            Object a;
            if (socketAddress.length == 0) {
                throw new SocketException("Address cannot be empty");
            }
            if (port == -1) {
                port = 0;
            }
            lease = SOCKETADDRESS_BUFFER_TL.take();
            try {
                direct = lease.get();
                limit = NativeUnixSocket.isLoaded() ? NativeUnixSocket.bytesToSockAddr(af.getDomain(), direct, socketAddress) : -1;
                if (limit != -1) break block15;
                a = af.getAddressConstructor().newAFSocketAddress(port, socketAddress, null);
                if (lease == null) return a;
                lease.close();
            }
            catch (Throwable throwable) {
                if (lease == null) throw throwable;
                try {
                    void var3_3;
                    var3_3.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return a;
        }
        if (limit > SOCKADDR_MAX_LEN) {
            throw new IllegalStateException("Unexpected address length");
        }
        direct.rewind();
        direct.limit(limit);
        Object object = AFSocketAddress.class;
        // MONITORENTER : org.newsclub.net.unix.AFSocketAddress.class
        Map<Integer, Map<ByteBuffer, AFSocketAddress>> mapPorts = ADDRESS_CACHE.get(af);
        if (mapPorts == null) {
            instance = null;
            mapPorts = new HashMap<Integer, Map<ByteBuffer, AFSocketAddress>>();
            map = new HashMap<ByteBuffer, AFSocketAddress>();
            mapPorts.put(port, map);
            ADDRESS_CACHE.put((AFAddressFamily<?>)af, mapPorts);
        } else {
            map = mapPorts.get(port);
            if (map == null) {
                instance = null;
                map = new HashMap<ByteBuffer, AFSocketAddress>();
                mapPorts.put(port, map);
            } else {
                instance = map.get(direct);
            }
        }
        if (instance == null) {
            byte[] byArray;
            void var1_1;
            void var2_2;
            ByteBuffer key = ByteBuffer.allocate(limit);
            key.put(direct);
            key = key.asReadOnlyBuffer();
            instance = var2_2.getAddressConstructor().newAFSocketAddress((int)var1_1, byArray, ObjectPool$.unpooledLease$76b6208((Object)key));
            map.put(key, instance);
        }
        // MONITOREXIT : object
        object = instance;
        if (lease == null) return (A)object;
        lease.close();
        return (A)object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final <A extends AFSocketAddress> A ofInternal(ByteBuffer socketAddressBuffer, AFAddressFamily<A> af) throws SocketException {
        Class<AFSocketAddress> clazz = AFSocketAddress.class;
        synchronized (AFSocketAddress.class) {
            void var1_2;
            ByteBuffer byteBuffer;
            byte[] sockAddrToBytes;
            ObjectPool.Lease<ByteBuffer> leasedBuffer;
            block9: {
                AFSocketAddress address;
                Map<ByteBuffer, AFSocketAddress> map;
                socketAddressBuffer.rewind();
                Map<Integer, Map<ByteBuffer, AFSocketAddress>> mapPorts = ADDRESS_CACHE.get(af);
                if (mapPorts != null && (map = mapPorts.get(0)) != null && (address = map.get(socketAddressBuffer)) != null) {
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return (A)address;
                }
                leasedBuffer = socketAddressBuffer.isDirect() ? null : AFSocketAddress.getNativeAddressDirectBuffer(Math.min(socketAddressBuffer.limit(), SOCKADDR_MAX_LEN));
                try {
                    if (leasedBuffer != null) {
                        ByteBuffer buf = leasedBuffer.get();
                        buf.put(socketAddressBuffer);
                        socketAddressBuffer = buf;
                    }
                    if ((sockAddrToBytes = NativeUnixSocket.sockAddrToBytes(af.getDomain(), byteBuffer)) != null) break block9;
                    if (leasedBuffer == null) return null;
                    leasedBuffer.close();
                }
                catch (Throwable throwable) {
                    if (leasedBuffer == null) throw throwable;
                    try {
                        void var3_4;
                        var3_4.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return null;
            }
            byteBuffer = AFSocketAddress.resolveAddress(sockAddrToBytes, 0, var1_2);
            if (leasedBuffer == null) return (A)byteBuffer;
            leasedBuffer.close();
            return (A)byteBuffer;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized InetAddress getInetAddress(AFAddressFamily<?> af) {
        if (this.inetAddress == null) {
            void var1_1;
            this.inetAddress = AFInetAddress.wrapAddress(this.bytes, var1_1);
        }
        return this.inetAddress;
    }

    protected final InetAddress getInetAddress() {
        AFSocketAddress aFSocketAddress = this;
        return aFSocketAddress.getInetAddress(aFSocketAddress.addressFamily);
    }

    /*
     * WARNING - void declaration
     */
    protected static final <A extends AFSocketAddress> @NonNull A unwrap(InetAddress address, int port, AFAddressFamily<A> af) throws SocketException {
        void var2_2;
        void var1_1;
        InetAddress inetAddress;
        Objects.requireNonNull(address);
        return AFSocketAddress.resolveAddress(AFInetAddress.unwrapAddress(inetAddress, af), (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static final int unwrapAddressDirectBufferInternal(ByteBuffer socketAddressBuffer, SocketAddress address) throws SocketException {
        void var0_1;
        void var2_5;
        void var1_2;
        if (!NativeUnixSocket.isLoaded()) {
            throw new SocketException("Unsupported operation; junixsocket native library is not loaded");
        }
        Objects.requireNonNull(address);
        address = AFSocketAddress.mapOrFail(address, AFSocketAddress.class);
        AFSocketAddress socketAddress = address;
        AFSocketAddress aFSocketAddress = address;
        byte[] addr = ((AFSocketAddress)address).bytes;
        aFSocketAddress = var1_2;
        int n = aFSocketAddress.addressFamily.getDomain();
        int len = NativeUnixSocket.bytesToSockAddr(n, socketAddressBuffer, (byte[])var2_5);
        if (len == -1) {
            throw new SocketException("Unsupported domain");
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    final ObjectPool.Lease<ByteBuffer> getNativeAddressDirectBuffer() throws SocketException {
        void var2_2;
        void var1_1;
        void var3_3;
        ByteBuffer address = this.nativeAddress;
        if (address == null) {
            throw (SocketException)new SocketException("Cannot access native address").initCause(NativeUnixSocket.unsupportedException());
        }
        address = address.duplicate();
        ObjectPool.Lease<ByteBuffer> lease = AFSocketAddress.getNativeAddressDirectBuffer(address.limit());
        ByteBuffer direct = lease.get();
        address.position(0);
        var3_3.put((ByteBuffer)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static final ObjectPool.Lease<ByteBuffer> getNativeAddressDirectBuffer(int limit) {
        void var1_1;
        int n;
        void var2_2;
        ObjectPool.Lease<ByteBuffer> lease = SOCKETADDRESS_BUFFER_TL.take();
        ByteBuffer direct = lease.get();
        direct.position(0);
        var2_2.limit(n);
        return var1_1;
    }

    static String toUnsignedString(int i) {
        long l = i;
        return Long.toString(l & 0xFFFFFFFFL);
    }

    public static boolean canMap(SocketAddress addr) {
        return AFSocketAddress.canMap(addr, AFSocketAddress.class);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean canMap(SocketAddress addr, Class<? extends AFSocketAddress> targetAddressClass) {
        AFSocketAddress aFSocketAddress;
        void var1_1;
        if (addr == null) {
            return true;
        }
        if (targetAddressClass.isAssignableFrom(addr.getClass())) {
            return true;
        }
        AFSocketAddress supplier = SocketAddressUtil.supplyAFSocketAddress(addr);
        if (supplier == null) {
            return false;
        }
        AFSocketAddress afAddr = (AFSocketAddress)supplier.get();
        if (afAddr == null) {
            return false;
        }
        return var1_1.isAssignableFrom(aFSocketAddress.getClass());
    }

    public static AFSocketAddress mapOrFail(SocketAddress addr) {
        return AFSocketAddress.mapOrFail(addr, AFSocketAddress.class);
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends AFSocketAddress> A mapOrFail(SocketAddress addr, Class<A> targetAddressClass) {
        void var2_2;
        void var1_1;
        if (addr == null) {
            return null;
        }
        if (targetAddressClass.isAssignableFrom(addr.getClass())) {
            return (A)((AFSocketAddress)targetAddressClass.cast(addr));
        }
        AFSupplier<? extends AFSocketAddress> supplier = SocketAddressUtil.supplyAFSocketAddress(addr);
        if (supplier == null) {
            throw new IllegalArgumentException("Can only bind to endpoints of type " + AFSocketAddress.class.getName() + ": " + addr);
        }
        AFSocketAddress afAddr = supplier.get();
        if (afAddr == null || !targetAddressClass.isAssignableFrom(afAddr.getClass())) {
            SocketAddress socketAddress;
            throw new IllegalArgumentException("Can only bind to endpoints of type " + AFSocketAddress.class.getName() + ", and this specific address is unsupported: " + socketAddress);
        }
        return (A)((AFSocketAddress)var1_1.cast(var2_2));
    }

    static /* synthetic */ boolean lambda$static$1(ByteBuffer o) {
        o.clear();
        return true;
    }

    static /* synthetic */ ByteBuffer lambda$static$0() {
        int n = SOCKADDR_MAX_LEN;
        return ByteBuffer.allocateDirect(n);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        INTERNAL_DUMMY_BIND = new SentinelSocketAddress(0);
        INTERNAL_DUMMY_CONNECT = new SentinelSocketAddress(1);
        INTERNAL_DUMMY_DONT_CONNECT = new SentinelSocketAddress(2);
        SOCKADDR_NATIVE_FAMILY_OFFSET = NativeUnixSocket.isLoaded() ? NativeUnixSocket.sockAddrNativeFamilyOffset() : -1;
        SOCKADDR_NATIVE_DATA_OFFSET = NativeUnixSocket.isLoaded() ? NativeUnixSocket.sockAddrNativeDataOffset() : -1;
        SOCKADDR_MAX_LEN = NativeUnixSocket.isLoaded() ? NativeUnixSocket.sockAddrLength(0) : 256;
        ADDRESS_CACHE = new HashMap();
        SOCKETADDRESS_BUFFER_TL = ObjectPool$.newThreadLocalPool(AFSocketAddress$$Lambda$1.lambdaFactory$$2debf86b(), AFSocketAddress$$Lambda$2.lambdaFactory$$594992b4());
        String v = System.getProperty("org.newsclub.net.unix.AFSocketAddress.deserialize", "");
        USE_DESERIALIZATION_FOR_INIT = v.isEmpty() ? NativeLibraryLoader.isAndroid() : Boolean.parseBoolean((String)var0);
    }

    @FunctionalInterface
    protected static interface AFSocketAddressConstructor<T extends AFSocketAddress> {
        public @NonNull T newAFSocketAddress(int var1, byte[] var2, ObjectPool.Lease<ByteBuffer> var3) throws SocketException;
    }
}

