/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.IllegalBlockingModeException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketImpl;
import org.newsclub.net.unix.AFSomeSocketThing;
import org.newsclub.net.unix.BrokenPipeSocketException;
import org.newsclub.net.unix.Closeables;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketAddressFilter;

public abstract class AFServerSocket<A extends AFSocketAddress>
extends ServerSocket
implements AFSomeSocketThing {
    private final AFSocketImpl<A> implementation;
    private @Nullable A boundEndpoint;
    private final Closeables closeables = new Closeables();
    private final AtomicBoolean created = new AtomicBoolean(false);
    private final AtomicBoolean deleteOnClose = new AtomicBoolean(true);
    private final AFServerSocketChannel<A> channel = this.newChannel();
    private @Nullable SocketAddressFilter bindFilter;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AFServerSocket() throws IOException {
        this((FileDescriptor)null);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AFServerSocket(FileDescriptor fdObj) throws IOException {
        void var1_1;
        this.implementation = this.newImpl((FileDescriptor)var1_1);
        AFServerSocket aFServerSocket = this;
        NativeUnixSocket.initServerImpl(aFServerSocket, aFServerSocket.implementation);
        this.getAFImpl().setOption(4, Boolean.TRUE);
    }

    protected abstract AFServerSocketChannel<A> newChannel();

    protected abstract AFSocketImpl<A> newImpl(FileDescriptor var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void bind(SocketAddress endpoint) throws IOException {
        void var1_1;
        this.bind((SocketAddress)var1_1, 50);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void bind(SocketAddress endpoint, int backlog) throws IOException {
        void var2_4;
        void var1_1;
        AFSocketAddress endpointCast;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        boolean bindErrorOk = this.bindFilter != null ? (endpoint = this.bindFilter.apply(endpoint)) != null && this.isBound() : false;
        endpoint = AFSocketAddress.mapOrFail(endpoint);
        try {
            endpointCast = (AFSocketAddress)endpoint;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Can only bind to specific endpoints", e);
        }
        try {
            this.getAFImpl().bind$4ff9e5a1((AFSocketAddress)e, this.getReuseAddress() ? 1 : 0);
        }
        catch (SocketException e) {
            void var1_3;
            void var3_5;
            if (var3_5 != false) {
                return;
            }
            throw var1_3;
        }
        AFServerSocket aFServerSocket = this;
        aFServerSocket.setBoundEndpoint(aFServerSocket.getAFImpl().getLocalSocketAddress());
        if (this.boundEndpoint0() == null) {
            this.setBoundEndpoint(endpointCast);
        }
        if (var1_1 == AFSocketAddress.INTERNAL_DUMMY_BIND) {
            return;
        }
        this.implementation.listen((int)var2_4);
    }

    @Override
    public final boolean isBound() {
        return this.boundEndpoint0() != null && this.implementation.getFD().valid();
    }

    @Override
    public final boolean isClosed() {
        return super.isClosed() || this.isBound() && !this.implementation.getFD().valid() || this.implementation.isClosed();
    }

    @Override
    public AFSocket<A> accept() throws IOException {
        return this.accept1(true);
    }

    /*
     * WARNING - void declaration
     */
    final AFSocket<A> accept1(boolean throwOnFail) throws IOException {
        void var2_3;
        void var3_4;
        AFSocket<A> as = this.newSocketInstance();
        boolean success = this.implementation.accept0(as.getAFImpl(false));
        if (this.isClosed()) {
            throw new BrokenPipeSocketException("Socket is closed");
        }
        if (var3_4 == false) {
            void var1_1;
            if (var1_1 != false) {
                if (this.getChannel().isBlocking()) {
                    return null;
                }
                throw new IllegalBlockingModeException();
            }
            return null;
        }
        as.getAFImpl(true);
        as.connect(AFSocketAddress.INTERNAL_DUMMY_CONNECT);
        AFSocket<A> aFSocket = as;
        aFSocket.getAFImpl(true).updatePorts(this.getAFImpl().getLocalPort1(), this.getAFImpl().getRemotePort());
        return var2_3;
    }

    protected abstract AFSocket<A> newSocketInstance() throws IOException;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + (this.isBound() ? this.boundEndpoint0() : "unbound") + "]";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws IOException {
        IOException ex;
        block14: {
            File f22;
            AFServerSocket localSocketAddressValid2;
            SocketAddress socketAddress;
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            if (this.isClosed()) {
                return;
            }
            AFServerSocket aFServerSocket = this;
            boolean localSocketAddressValid2 = aFServerSocket.isClosed() ? false : ((socketAddress = aFServerSocket.getLocalSocketAddress()) == null ? false : ((InetSocketAddress)socketAddress).equals(aFServerSocket.getAFImpl().getLocalSocketAddress()));
            A endpoint = this.boundEndpoint;
            IOException superException = null;
            try {
                super.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                superException = iOException;
            }
            if (this.implementation != null) {
                try {
                    this.implementation.close();
                }
                catch (IOException e) {
                    if (superException == null) {
                        superException = e;
                    }
                    superException.addSuppressed(e);
                }
            }
            ex = null;
            try {
                void var3_6;
                this.closeables.close((IOException)var3_6);
                if (endpoint == null || !((AFSocketAddress)endpoint).hasFilename() || !localSocketAddressValid2) break block14;
                localSocketAddressValid2 = this;
            }
            catch (Throwable throwable) {
                void f22;
                if (endpoint != null && ((AFSocketAddress)endpoint).hasFilename() && f22 != false) {
                    Object f22 = this;
                    if (((AFServerSocket)f22).deleteOnClose.get() && !((File)(f22 = ((AFSocketAddress)socketAddress).getFile())).delete() && ((File)f22).exists()) {
                        void var1_4;
                        new IOException("Could not delete socket file after close: " + var1_4);
                    }
                }
                throw throwable;
            }
            if (localSocketAddressValid2.deleteOnClose.get() && !(f22 = ((AFSocketAddress)endpoint).getFile()).delete() && f22.exists()) {
                ex = new IOException("Could not delete socket file after close: " + f22);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final @Nullable A getLocalSocketAddress() {
        void var1_1;
        @Nullable A ep = this.boundEndpoint0();
        if (ep == null) {
            ep = this.getAFImpl().getLocalSocketAddress();
            this.setBoundEndpoint(ep);
        }
        return var1_1;
    }

    private synchronized @Nullable A boundEndpoint0() {
        return this.boundEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setBoundEndpoint(@Nullable A addr) {
        void var1_2;
        void port22;
        this.boundEndpoint = addr;
        int port22 = addr == null ? -1 : port22.getPort();
        this.getAFImpl().updatePorts((int)var1_2, -1);
    }

    @Override
    public final int getLocalPort() {
        if (this.boundEndpoint0() == null) {
            AFServerSocket aFServerSocket = this;
            aFServerSocket.setBoundEndpoint(aFServerSocket.getAFImpl().getLocalSocketAddress());
        }
        if (this.boundEndpoint0() == null) {
            return -1;
        }
        return this.getAFImpl().getLocalPort1();
    }

    final AFSocketImpl<A> getAFImpl() {
        if (this.created.compareAndSet(false, true)) {
            try {
                this.getAFImpl().create(true);
                this.getSoTimeout();
            }
            catch (IOException iOException) {}
        }
        return this.implementation;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFServerSocketChannel<A> getChannel() {
        return this.channel;
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.getAFImpl().getInetAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        void var1_1;
        if (size <= 0) {
            throw new IllegalArgumentException("receive buffer size must be a positive number");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getAFImpl().setOption(4098, (Object)((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        void var1_1;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getAFImpl().getOption(4098);
        if (o instanceof Number) {
            void var2_2;
            result = ((Number)var2_2).intValue();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        void var1_1;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.getAFImpl().setOption(4102, (Object)((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getAFImpl().getOption(4102);
        if (o instanceof Number) {
            void var1_1;
            return ((Number)var1_1).intValue();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        void var1_1;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getAFImpl().setOption(4, (Object)((boolean)var1_1));
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getAFImpl().getOption(4);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        void var1_1;
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getAFImpl().getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> ServerSocket setOption(SocketOption<T> name, T value) throws IOException {
        void var2_2;
        void var1_1;
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getAFImpl().setOption(var1_1, var2_2);
        return this;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.getAFImpl().supportedOptions();
    }

    static /* synthetic */ SocketAddress lambda$forceBindAddress$0(SocketAddress endpoint, SocketAddress orig) throws IOException {
        SocketAddress socketAddress;
        if (orig == null) {
            return null;
        }
        return socketAddress;
    }

    public static interface Constructor<A extends AFSocketAddress> {
        public @NonNull AFServerSocket<A> newInstance(FileDescriptor var1) throws IOException;
    }
}

